/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.uplink;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.collections.HashTrieMap;
import swim.runtime.LinkBinding;
import swim.runtime.uplink.ListOperation;
import swim.runtime.uplink.UplinkModem;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

public abstract class SeqUplinkModem
extends UplinkModem {
    final ConcurrentLinkedQueue<Value> downQueue = new ConcurrentLinkedQueue();
    protected volatile Iterator<Map.Entry<Value, Value>> syncQueue;
    protected volatile HashTrieMap<Value, ListOperation> keyQueue = HashTrieMap.empty();
    volatile Value lastKey;
    volatile int lastSyncIndex;
    static final AtomicReferenceFieldUpdater<SeqUplinkModem, HashTrieMap<Value, ListOperation>> KEY_QUEUE = AtomicReferenceFieldUpdater.newUpdater(SeqUplinkModem.class, HashTrieMap.class, "keyQueue");

    public SeqUplinkModem(LinkBinding linkBinding) {
        super(linkBinding);
    }

    @Override
    protected boolean downQueueIsEmpty() {
        return this.downQueue.isEmpty() && this.syncQueue == null;
    }

    @Override
    protected void queueDown(Value body) {
        this.downQueue.add(body);
    }

    public void syncDown(Iterator<Map.Entry<Value, Value>> syncQueue) {
        this.syncQueue = syncQueue;
    }

    public void cueDownKey(Value key, ListOperation listOperation) {
        HashTrieMap newKeyQueue;
        HashTrieMap<Value, ListOperation> oldKeyQueue;
        while ((oldKeyQueue = this.keyQueue) != (newKeyQueue = oldKeyQueue.updated((Object)key, (Object)listOperation)) && !KEY_QUEUE.compareAndSet(this, oldKeyQueue, (HashTrieMap<Value, ListOperation>)newKeyQueue)) {
        }
        if (oldKeyQueue != newKeyQueue) {
            this.cueDown();
        }
    }

    protected abstract Value nextDownKey(Value var1, ListOperation var2);

    @Override
    protected Value nextDownQueue() {
        Iterator<Map.Entry<Value, Value>> syncQueue = this.syncQueue;
        if (syncQueue != null) {
            if (syncQueue.hasNext()) {
                Map.Entry<Value, Value> entry = syncQueue.next();
                Record header = Record.of().attr("update", (Value)Record.of().slot("key", Record.fromObject((Object)entry.getKey())).slot("index", this.lastSyncIndex)).concat((Item)entry.getValue());
                ++this.lastSyncIndex;
                return header;
            }
            this.syncQueue = null;
            this.lastSyncIndex = 0;
            return null;
        }
        return this.downQueue.poll();
    }

    @Override
    protected Value nextDownCue() {
        ListOperation listOperation;
        Value key;
        HashTrieMap newKeyQueue;
        HashTrieMap<Value, ListOperation> oldKeyQueue;
        do {
            oldKeyQueue = this.keyQueue;
            key = (Value)oldKeyQueue.nextKey((Object)this.lastKey);
            listOperation = (ListOperation)((Object)oldKeyQueue.get((Object)key));
        } while (oldKeyQueue != (newKeyQueue = oldKeyQueue.removed((Object)key)) && !KEY_QUEUE.compareAndSet(this, oldKeyQueue, (HashTrieMap<Value, ListOperation>)newKeyQueue));
        if (key != null) {
            this.lastKey = key;
            if (!newKeyQueue.isEmpty()) {
                int newStatus;
                int oldStatus;
                while ((oldStatus = this.status) != (newStatus = oldStatus | 0x10) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
                }
            }
            return this.nextDownKey(key, listOperation);
        }
        return null;
    }
}

