/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.agent.AgentContext;
import swim.api.data.SpatialData;
import swim.api.http.function.DecodeRequestHttp;
import swim.api.http.function.DidRequestHttp;
import swim.api.http.function.DidRespondHttp;
import swim.api.http.function.DoRespondHttp;
import swim.api.http.function.WillRequestHttp;
import swim.api.http.function.WillRespondHttp;
import swim.api.lane.Lane;
import swim.api.lane.SpatialLane;
import swim.api.lane.function.DidCommand;
import swim.api.lane.function.DidEnter;
import swim.api.lane.function.DidLeave;
import swim.api.lane.function.DidUplink;
import swim.api.lane.function.WillCommand;
import swim.api.lane.function.WillEnter;
import swim.api.lane.function.WillLeave;
import swim.api.lane.function.WillUplink;
import swim.concurrent.Conts;
import swim.math.Z2Form;
import swim.observable.function.DidClear;
import swim.observable.function.DidMoveShape;
import swim.observable.function.DidRemoveShape;
import swim.observable.function.DidUpdateShape;
import swim.observable.function.WillClear;
import swim.observable.function.WillMoveShape;
import swim.observable.function.WillRemoveShape;
import swim.observable.function.WillUpdateShape;
import swim.runtime.LaneBinding;
import swim.runtime.lane.LaneView;
import swim.runtime.lane.SpatialLaneModel;
import swim.spatial.SpatialMap;
import swim.structure.Form;

public class SpatialLaneView<K, S, V>
extends LaneView
implements SpatialLane<K, S, V> {
    protected final AgentContext agentContext;
    protected Form<K> keyForm;
    protected Z2Form<S> shapeForm;
    protected Form<V> valueForm;
    protected SpatialLaneModel<S> laneBinding;
    protected SpatialData<K, S, V> dataView;
    protected int flags;
    static final int RESIDENT = 1;
    static final int TRANSIENT = 2;
    static final int SIGNED = 4;

    SpatialLaneView(AgentContext agentContext, Form<K> keyForm, Z2Form<S> shapeForm, Form<V> valueForm, int flags, Object observers) {
        super(observers);
        this.agentContext = agentContext;
        this.keyForm = keyForm;
        this.shapeForm = shapeForm;
        this.valueForm = valueForm;
        this.flags = flags;
    }

    public SpatialLaneView(AgentContext agentContext, Form<K> keyForm, Z2Form<S> shapeForm, Form<V> valueForm) {
        this(agentContext, keyForm, shapeForm, valueForm, 0, null);
    }

    @Override
    public AgentContext agentContext() {
        return this.agentContext;
    }

    @Override
    public SpatialLaneModel<S> getLaneBinding() {
        return this.laneBinding;
    }

    public void setLaneBinding(SpatialLaneModel<S> laneBinding) {
        this.laneBinding = laneBinding;
        this.dataView = laneBinding.data.keyForm(this.keyForm).valueForm(this.valueForm);
    }

    @Override
    public LaneBinding createLaneBinding() {
        return new SpatialLaneModel<S>(this.shapeForm, this.flags);
    }

    public Form<K> keyForm() {
        return this.keyForm;
    }

    public <K2> SpatialLane<K2, S, V> keyForm(Form<K2> keyForm) {
        return new SpatialLaneView<K2, S, V>(this.agentContext, keyForm, this.shapeForm, this.valueForm, this.flags, this.typesafeObservers(this.observers));
    }

    public <K2> SpatialLane<K2, S, V> keyClass(Class<K2> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public void setKeyForm(Form<K> keyForm) {
        this.keyForm = keyForm;
    }

    public Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> SpatialLane<K, S, V2> valueForm(Form<V2> valueForm) {
        return new SpatialLaneView<K, S, V2>(this.agentContext, this.keyForm, this.shapeForm, valueForm, this.flags, this.typesafeObservers(this.observers));
    }

    public <V2> SpatialLane<K, S, V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public void setValueForm(Form<V> valueForm) {
        this.valueForm = valueForm;
    }

    protected Object typesafeObservers(Object observers) {
        return observers;
    }

    public final boolean isResident() {
        return (this.flags & 1) != 0;
    }

    public SpatialLane<K, S, V> isResident(boolean isResident) {
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        SpatialLaneModel<S> laneBinding = this.laneBinding;
        if (laneBinding != null) {
            laneBinding.isResident(isResident);
        }
        return this;
    }

    void didSetResident(boolean isResident) {
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public final boolean isTransient() {
        return (this.flags & 2) != 0;
    }

    public SpatialLane<K, S, V> isTransient(boolean isTransient) {
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        SpatialLaneModel<S> laneBinding = this.laneBinding;
        if (laneBinding != null) {
            laneBinding.isTransient(isTransient);
        }
        return this;
    }

    void didSetTransient(boolean isTransient) {
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public final boolean isSigned() {
        return (this.flags & 4) != 0;
    }

    public SpatialLane<K, S, V> isSigned(boolean isSigned) {
        this.didSetSigned(isSigned);
        SpatialLaneModel<S> laneBinding = this.laneBinding;
        if (laneBinding != null) {
            laneBinding.isSigned(isSigned);
        }
        return this;
    }

    void didSetSigned(boolean isSigned) {
        this.flags = isSigned ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    @Override
    public void close() {
        this.laneBinding.closeLaneView(this);
    }

    @Override
    public SpatialLaneView<K, S, V> observe(Object observer) {
        return (SpatialLaneView)super.observe(observer);
    }

    @Override
    public SpatialLaneView<K, S, V> unobserve(Object observer) {
        return (SpatialLaneView)super.unobserve(observer);
    }

    public SpatialLane<K, S, V> willUpdate(WillUpdateShape<K, S, V> willUpdate) {
        return this.observe(willUpdate);
    }

    public SpatialLane<K, S, V> didUpdate(DidUpdateShape<K, S, V> didUpdate) {
        return this.observe(didUpdate);
    }

    public SpatialLane<K, S, V> willMove(WillMoveShape<K, S, V> willMove) {
        return this.observe(willMove);
    }

    public SpatialLane<K, S, V> didMove(DidMoveShape<K, S, V> didMove) {
        return this.observe(didMove);
    }

    public SpatialLane<K, S, V> willRemove(WillRemoveShape<K, S> willRemove) {
        return this.observe(willRemove);
    }

    public SpatialLane<K, S, V> didRemove(DidRemoveShape<K, S, V> didRemove) {
        return this.observe(didRemove);
    }

    public SpatialLane<K, S, V> willClear(WillClear willClear) {
        return this.observe(willClear);
    }

    public SpatialLane<K, S, V> didClear(DidClear didClear) {
        return this.observe(didClear);
    }

    @Override
    public SpatialLaneView<K, S, V> willCommand(WillCommand willCommand) {
        return this.observe(willCommand);
    }

    @Override
    public SpatialLaneView<K, S, V> didCommand(DidCommand didCommand) {
        return this.observe(didCommand);
    }

    @Override
    public SpatialLaneView<K, S, V> willUplink(WillUplink willUplink) {
        return this.observe(willUplink);
    }

    @Override
    public SpatialLaneView<K, S, V> didUplink(DidUplink didUplink) {
        return this.observe(didUplink);
    }

    @Override
    public SpatialLaneView<K, S, V> willEnter(WillEnter willEnter) {
        return this.observe(willEnter);
    }

    @Override
    public SpatialLaneView<K, S, V> didEnter(DidEnter didEnter) {
        return this.observe(didEnter);
    }

    @Override
    public SpatialLaneView<K, S, V> willLeave(WillLeave willLeave) {
        return this.observe(willLeave);
    }

    @Override
    public SpatialLaneView<K, S, V> didLeave(DidLeave didLeave) {
        return this.observe(didLeave);
    }

    @Override
    public SpatialLaneView<K, S, V> decodeRequest(DecodeRequestHttp<Object> decodeRequest) {
        return this.observe(decodeRequest);
    }

    @Override
    public SpatialLaneView<K, S, V> willRequest(WillRequestHttp<?> willRequest) {
        return this.observe(willRequest);
    }

    @Override
    public SpatialLaneView<K, S, V> didRequest(DidRequestHttp<Object> didRequest) {
        return this.observe(didRequest);
    }

    @Override
    public SpatialLaneView<K, S, V> doRespond(DoRespondHttp<Object> doRespond) {
        return this.observe(doRespond);
    }

    @Override
    public SpatialLaneView<K, S, V> willRespond(WillRespondHttp<?> willRespond) {
        return this.observe(willRespond);
    }

    @Override
    public SpatialLaneView<K, S, V> didRespond(DidRespondHttp<?> didRespond) {
        return this.observe(didRespond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<Boolean, V> dispatchWillUpdate(Link link, K key, S shape, V newValue, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLane((Lane)this);
                        SwimContext.setLink((Link)link);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillUpdateShape)) break block12;
                        if (((WillUpdateShape)observers).isPreemptive() != preemptive) break block13;
                        try {
                            newValue = ((WillUpdateShape)observers).willUpdate(key, shape, newValue);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillUpdateShape)) continue;
                        if (((WillUpdateShape)observer).isPreemptive() == preemptive) {
                            try {
                                newValue = ((WillUpdateShape)observer).willUpdate(key, shape, newValue);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            AbstractMap.SimpleImmutableEntry<Boolean, V> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Boolean, V>(complete, newValue);
            return simpleImmutableEntry;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidUpdate(Link link, K key, S shape, V newValue, V oldValue, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLane((Lane)this);
                        SwimContext.setLink((Link)link);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidUpdateShape)) break block12;
                        if (((DidUpdateShape)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidUpdateShape)observers).didUpdate(key, shape, newValue, oldValue);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidUpdateShape)) continue;
                        if (((DidUpdateShape)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidUpdateShape)observer).didUpdate(key, shape, newValue, oldValue);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<Boolean, V> dispatchWillMove(Link link, K key, S newShape, V newValue, S oldShape, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLane((Lane)this);
                        SwimContext.setLink((Link)link);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillMoveShape)) break block12;
                        if (((WillMoveShape)observers).isPreemptive() != preemptive) break block13;
                        try {
                            newValue = ((WillMoveShape)observers).willMove(key, newShape, newValue, oldShape);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillMoveShape)) continue;
                        if (((WillMoveShape)observer).isPreemptive() == preemptive) {
                            try {
                                newValue = ((WillMoveShape)observer).willMove(key, newShape, newValue, oldShape);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            AbstractMap.SimpleImmutableEntry<Boolean, V> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Boolean, V>(complete, newValue);
            return simpleImmutableEntry;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidMove(Link link, K key, S newShape, V newValue, S oldShape, V oldValue, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLane((Lane)this);
                        SwimContext.setLink((Link)link);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillMoveShape)) break block12;
                        if (((DidMoveShape)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidMoveShape)observers).didMove(key, newShape, newValue, oldShape, oldValue);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillMoveShape)) continue;
                        if (((DidMoveShape)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidMoveShape)observer).didMove(key, newShape, newValue, oldShape, oldValue);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillRemove(Link link, K key, S shape, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLane((Lane)this);
                        SwimContext.setLink((Link)link);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillMoveShape)) break block12;
                        if (((WillRemoveShape)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillRemoveShape)observers).willRemove(key, shape);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillMoveShape)) continue;
                        if (((WillRemoveShape)observers).isPreemptive() == preemptive) {
                            try {
                                ((WillRemoveShape)observers).willRemove(key, shape);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidRemove(Link link, K key, S shape, V oldValue, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLane((Lane)this);
                        SwimContext.setLink((Link)link);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillMoveShape)) break block12;
                        if (((DidRemoveShape)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidRemoveShape)observers).didRemove(key, shape, oldValue);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillMoveShape)) continue;
                        if (((DidRemoveShape)observers).isPreemptive() == preemptive) {
                            try {
                                ((DidRemoveShape)observers).didRemove(key, shape, oldValue);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchWillClear(Link link, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLane((Lane)this);
                        SwimContext.setLink((Link)link);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillClear)) break block12;
                        if (((WillClear)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillClear)observers).willClear();
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillClear)) continue;
                        if (((WillClear)observer).isPreemptive() == preemptive) {
                            try {
                                ((WillClear)observer).willClear();
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidClear(Link link, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLane((Lane)this);
                        SwimContext.setLink((Link)link);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidClear)) break block12;
                        if (((DidClear)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidClear)observers).didClear();
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidClear)) continue;
                        if (((DidClear)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidClear)observer).didClear();
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    public V laneWillUpdate(K key, S shape, V newValue) {
        return newValue;
    }

    public void laneDidUpdate(K key, S shape, V newValue, V oldValue) {
    }

    public V laneWillMove(K key, S newShape, V newValue, S oldShape) {
        return newValue;
    }

    public V laneDidMove(K key, S newShape, V newValue, S oldShape, V oldValue) {
        return newValue;
    }

    public void laneWillRemove(K key, S shape) {
    }

    public void laneDidRemove(K key, S shape) {
    }

    public void laneWillClear() {
    }

    public void laneDidClear() {
    }

    public SpatialMap<K, S, V> snapshot() {
        return this.dataView.snapshot();
    }

    public Iterator<SpatialMap.Entry<K, S, V>> iterator() {
        return this.dataView.iterator();
    }

    public boolean isEmpty() {
        return this.dataView.isEmpty();
    }

    public int size() {
        return this.dataView.size();
    }

    public boolean containsKey(K key, S shape) {
        return this.dataView.containsKey(key, shape);
    }

    public boolean containsKey(Object key) {
        return this.dataView.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.dataView.containsValue(value);
    }

    public V get(K key, S shape) {
        return (V)this.dataView.get(key, shape);
    }

    public V get(Object key) {
        return (V)this.dataView.get(key);
    }

    public V put(K key, S shape, V newValue) {
        return (V)this.dataView.put(key, shape, newValue);
    }

    public V move(K key, S oldShape, S newShape, V newValue) {
        return (V)this.dataView.move(key, oldShape, newShape, newValue);
    }

    public V remove(K key, S shape) {
        return (V)this.dataView.remove(key, shape);
    }

    public void clear() {
        this.dataView.clear();
    }

    public Iterator<SpatialMap.Entry<K, S, V>> iterator(S shape) {
        return this.dataView.iterator(shape);
    }

    public Iterator<K> keyIterator() {
        return this.dataView.keyIterator();
    }

    public Iterator<V> valueIterator() {
        return this.dataView.valueIterator();
    }
}

