/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.uplink;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.auth.Identity;
import swim.api.function.DidClose;
import swim.api.uplink.Uplink;
import swim.api.uplink.function.OnCommand;
import swim.api.uplink.function.OnEvent;
import swim.api.uplink.function.OnLink;
import swim.api.uplink.function.OnLinked;
import swim.api.uplink.function.OnSync;
import swim.api.uplink.function.OnSynced;
import swim.api.uplink.function.OnUnlink;
import swim.api.uplink.function.OnUnlinked;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.LaneBinding;
import swim.runtime.LinkBinding;
import swim.runtime.LinkContext;
import swim.runtime.LinkKeys;
import swim.runtime.uplink.UplinkModemOnCommand;
import swim.runtime.uplink.UplinkModemOnLink;
import swim.runtime.uplink.UplinkModemOnSync;
import swim.runtime.uplink.UplinkModemOnUnlink;
import swim.runtime.uplink.UplinkModemPullDown;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;
import swim.warp.Envelope;
import swim.warp.EventMessage;
import swim.warp.LinkRequest;
import swim.warp.LinkedResponse;
import swim.warp.SyncRequest;
import swim.warp.SyncedResponse;
import swim.warp.UnlinkRequest;
import swim.warp.UnlinkedResponse;

public abstract class UplinkModem
implements LinkContext,
Uplink {
    protected final LinkBinding linkBinding;
    protected final Value linkKey;
    protected volatile int status;
    protected volatile Object observers;
    static final int LINKED = 1;
    static final int LINKING = 2;
    static final int SYNCING = 4;
    static final int UNLINKING = 8;
    static final int CUED_DOWN = 16;
    static final int FEEDING_DOWN = 32;
    static final int FEEDING_UP = 64;
    static final int PULLING_UP = 128;
    static final AtomicIntegerFieldUpdater<UplinkModem> STATUS = AtomicIntegerFieldUpdater.newUpdater(UplinkModem.class, "status");
    static final AtomicReferenceFieldUpdater<UplinkModem, Object> OBSERVERS = AtomicReferenceFieldUpdater.newUpdater(UplinkModem.class, Object.class, "observers");

    UplinkModem(LinkBinding linkBinding, Value linkKey) {
        this.linkBinding = linkBinding;
        this.linkKey = linkKey.commit();
    }

    UplinkModem(LinkBinding linkBinding) {
        this(linkBinding, LinkKeys.generateLinkKey());
    }

    public abstract LaneBinding laneBinding();

    public final LinkBinding linkBinding() {
        return this.linkBinding;
    }

    public abstract Stage stage();

    public final Uri hostUri() {
        return this.linkBinding.hostUri();
    }

    public final Uri nodeUri() {
        return this.linkBinding.nodeUri();
    }

    public final Uri laneUri() {
        return this.linkBinding.laneUri();
    }

    @Override
    public final Value linkKey() {
        return this.linkKey;
    }

    public final float prio() {
        return this.linkBinding.prio();
    }

    public final float rate() {
        return this.linkBinding.rate();
    }

    public final Value body() {
        return this.linkBinding.body();
    }

    @Override
    public boolean isConnectedUp() {
        return true;
    }

    @Override
    public boolean isRemoteUp() {
        return false;
    }

    @Override
    public boolean isSecureUp() {
        return true;
    }

    @Override
    public String securityProtocolUp() {
        return null;
    }

    @Override
    public String cipherSuiteUp() {
        return null;
    }

    @Override
    public InetSocketAddress localAddressUp() {
        return null;
    }

    @Override
    public Identity localIdentityUp() {
        return null;
    }

    @Override
    public Principal localPrincipalUp() {
        return null;
    }

    @Override
    public Collection<Certificate> localCertificatesUp() {
        return FingerTrieSeq.empty();
    }

    @Override
    public InetSocketAddress remoteAddressUp() {
        return null;
    }

    @Override
    public Identity remoteIdentityUp() {
        return null;
    }

    @Override
    public Principal remotePrincipalUp() {
        return null;
    }

    @Override
    public Collection<Certificate> remoteCertificatesUp() {
        return FingerTrieSeq.empty();
    }

    public boolean isConnected() {
        return this.linkBinding.isConnectedDown();
    }

    public boolean isRemote() {
        return this.linkBinding.isRemoteDown();
    }

    public boolean isSecure() {
        return this.linkBinding.isSecureDown();
    }

    public String securityProtocol() {
        return this.linkBinding.securityProtocolDown();
    }

    public String cipherSuite() {
        return this.linkBinding.cipherSuiteDown();
    }

    public InetSocketAddress localAddress() {
        return this.linkBinding.localAddressDown();
    }

    public Identity localIdentity() {
        return this.linkBinding.localIdentityDown();
    }

    public Principal localPrincipal() {
        return this.linkBinding.localPrincipalDown();
    }

    public Collection<Certificate> localCertificates() {
        return this.linkBinding.localCertificatesDown();
    }

    public InetSocketAddress remoteAddress() {
        return this.linkBinding.remoteAddressDown();
    }

    public Identity remoteIdentity() {
        return this.linkBinding.remoteIdentityDown();
    }

    public Principal remotePrincipal() {
        return this.linkBinding.remotePrincipalDown();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.linkBinding.remoteCertificatesDown();
    }

    public UplinkModem observe(Object newObserver) {
        Object[] newObservers;
        Object oldObservers;
        do {
            if ((oldObservers = this.observers) == null) {
                newObservers = newObserver;
                continue;
            }
            if (!(oldObservers instanceof Object[])) {
                Object[] newArray = new Object[]{oldObservers, newObserver};
                newObservers = newArray;
                continue;
            }
            Object[] oldArray = (Object[])oldObservers;
            int oldCount = oldArray.length;
            Object[] newArray = new Object[oldCount + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldCount);
            newArray[oldCount] = newObserver;
            newObservers = newArray;
        } while (!OBSERVERS.compareAndSet(this, oldObservers, newObservers));
        return this;
    }

    public UplinkModem unobserve(Object oldObserver) {
        Object oldObservers;
        while ((oldObservers = this.observers) != null) {
            Object[] newObservers;
            if (!(oldObservers instanceof Object[])) {
                if (oldObservers != oldObserver) break;
                newObservers = null;
            } else {
                Object[] oldArray = (Object[])oldObservers;
                int oldCount = oldArray.length;
                if (oldCount == 2) {
                    if (oldArray[0] == oldObserver) {
                        newObservers = oldArray[1];
                    } else {
                        if (oldArray[1] != oldObserver) break;
                        newObservers = oldArray[0];
                    }
                } else {
                    int i;
                    for (i = 0; i < oldCount && oldArray[i] != oldObserver; ++i) {
                    }
                    if (i >= oldCount) break;
                    Object[] newArray = new Object[oldCount - 1];
                    System.arraycopy(oldArray, 0, newArray, 0, i);
                    System.arraycopy(oldArray, i + 1, newArray, i, oldCount - 1 - i);
                    newObservers = newArray;
                }
            }
            if (!OBSERVERS.compareAndSet(this, oldObservers, newObservers)) continue;
            break;
        }
        return this;
    }

    public UplinkModem onEvent(OnEvent onEvent) {
        this.observe(onEvent);
        return this;
    }

    public UplinkModem onCommand(OnCommand onCommand) {
        this.observe(onCommand);
        return this;
    }

    public UplinkModem onLink(OnLink onLink) {
        this.observe(onLink);
        return this;
    }

    public UplinkModem onLinked(OnLinked onLinked) {
        this.observe(onLinked);
        return this;
    }

    public UplinkModem onSync(OnSync onSync) {
        this.observe(onSync);
        return this;
    }

    public UplinkModem onSynced(OnSynced onSynced) {
        this.observe(onSynced);
        return this;
    }

    public UplinkModem onUnlink(OnUnlink onUnlink) {
        this.observe(onUnlink);
        return this;
    }

    public UplinkModem onUnlinked(OnUnlinked onUnlinked) {
        this.observe(onUnlinked);
        return this;
    }

    public UplinkModem didClose(DidClose didClose) {
        this.observe(didClose);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchOnEvent(EventMessage message) {
        block12: {
            Link oldLink = SwimContext.getLink();
            SwimContext.setLink((Link)this);
            try {
                Object observers = this.observers;
                if (observers instanceof OnEvent) {
                    try {
                        ((OnEvent)observers).onEvent(message);
                        break block12;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.didFail(error);
                            break block12;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnEvent)) continue;
                        try {
                            ((OnEvent)observer).onEvent(message);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            finally {
                SwimContext.setLink((Link)oldLink);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchOnCommand(CommandMessage message, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        SwimContext.setLink((Link)this);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof OnCommand)) break block12;
                        if (((OnCommand)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((OnCommand)observers).onCommand(message);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnCommand)) continue;
                        if (((OnCommand)observer).isPreemptive() == preemptive) {
                            try {
                                ((OnCommand)observer).onCommand(message);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.didFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchOnLink(LinkRequest request, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        SwimContext.setLink((Link)this);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof OnLink)) break block12;
                        if (((OnLink)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((OnLink)observers).onLink(request);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnLink)) continue;
                        if (((OnLink)observer).isPreemptive() == preemptive) {
                            try {
                                ((OnLink)observer).onLink(request);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.didFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchOnLinked(LinkedResponse response) {
        block12: {
            Link oldLink = SwimContext.getLink();
            SwimContext.setLink((Link)this);
            try {
                Object observers = this.observers;
                if (observers instanceof OnLinked) {
                    try {
                        ((OnLinked)observers).onLinked(response);
                        break block12;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.didFail(error);
                            break block12;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnLinked)) continue;
                        try {
                            ((OnLinked)observer).onLinked(response);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            finally {
                SwimContext.setLink((Link)oldLink);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchOnSync(SyncRequest request, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        SwimContext.setLink((Link)this);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof OnSync)) break block12;
                        if (((OnSync)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((OnSync)observers).onSync(request);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnSync)) continue;
                        if (((OnSync)observer).isPreemptive() == preemptive) {
                            try {
                                ((OnSync)observer).onSync(request);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.didFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchOnSynced(SyncedResponse response) {
        block12: {
            Link oldLink = SwimContext.getLink();
            SwimContext.setLink((Link)this);
            try {
                Object observers = this.observers;
                if (observers instanceof OnSynced) {
                    try {
                        ((OnSynced)observers).onSynced(response);
                        break block12;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.didFail(error);
                            break block12;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnSynced)) continue;
                        try {
                            ((OnSynced)observer).onSynced(response);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            finally {
                SwimContext.setLink((Link)oldLink);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchOnUnlink(UnlinkRequest request, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        SwimContext.setLink((Link)this);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof OnUnlink)) break block12;
                        if (((OnUnlink)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((OnUnlink)observers).onUnlink(request);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnUnlink)) continue;
                        if (((OnUnlink)observer).isPreemptive() == preemptive) {
                            try {
                                ((OnUnlink)observer).onUnlink(request);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.didFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchOnUnlinked(UnlinkedResponse response) {
        block12: {
            Link oldLink = SwimContext.getLink();
            SwimContext.setLink((Link)this);
            try {
                Object observers = this.observers;
                if (observers instanceof OnUnlinked) {
                    try {
                        ((OnUnlinked)observers).onUnlinked(response);
                        break block12;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.didFail(error);
                            break block12;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnUnlinked)) continue;
                        try {
                            ((OnUnlinked)observer).onUnlinked(response);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            finally {
                SwimContext.setLink((Link)oldLink);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchDidClose() {
        block12: {
            Link oldLink = SwimContext.getLink();
            SwimContext.setLink((Link)this);
            try {
                Object observers = this.observers;
                if (observers instanceof DidClose) {
                    try {
                        ((DidClose)observers).didClose();
                        break block12;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.didFail(error);
                            break block12;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidClose)) continue;
                        try {
                            ((DidClose)observer).didClose();
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.didFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            finally {
                SwimContext.setLink((Link)oldLink);
            }
        }
    }

    protected boolean downQueueIsEmpty() {
        return true;
    }

    protected void queueDown(Value body) {
        throw new UnsupportedOperationException();
    }

    protected Value nextDownQueue() {
        return null;
    }

    protected EventMessage nextDownQueueEvent() {
        Value body = this.nextDownQueue();
        if (body != null) {
            return new EventMessage(this.nodeUri(), this.laneUri(), body);
        }
        return null;
    }

    protected Value nextDownCue() {
        return null;
    }

    protected EventMessage nextDownCueEvent() {
        Value body = this.nextDownCue();
        if (body != null) {
            return new EventMessage(this.nodeUri(), this.laneUri(), body);
        }
        return null;
    }

    public void sendDown(Value body) {
        int newStatus;
        int oldStatus;
        this.queueDown(body);
        while ((oldStatus = this.status) != (newStatus = oldStatus | 0x20) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (oldStatus != newStatus) {
            this.linkBinding.feedDown();
        }
    }

    public void cueDown() {
        int newStatus;
        int oldStatus;
        while (oldStatus != (newStatus = ((oldStatus = this.status) & 1) != 0 ? oldStatus | 0x20 | 0x10 : oldStatus | 0x10) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 0x20) != (newStatus & 0x20)) {
            this.linkBinding.feedDown();
        }
    }

    @Override
    public void pullDown() {
        this.stage().execute((Runnable)new UplinkModemPullDown(this));
    }

    protected void runPullDown() {
        try {
            this.pullDownEnvelope();
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    protected void pullDownEnvelope() {
        int newStatus;
        int oldStatus;
        do {
            if (((oldStatus = this.status) & 8) != 0) {
                newStatus = oldStatus & 0xFFFFFFF7;
                continue;
            }
            if ((oldStatus & 2) != 0) {
                newStatus = oldStatus & 0xFFFFFFFD;
                continue;
            }
            newStatus = oldStatus;
            break;
        } while (!STATUS.compareAndSet(this, oldStatus, newStatus));
        if ((oldStatus & 8) != (newStatus & 8)) {
            UnlinkedResponse response = this.unlinkedResponse();
            this.pullDownUnlinked(response);
            this.linkBinding.pushDown((Envelope)response);
        } else if ((oldStatus & 2) != (newStatus & 2)) {
            LinkedResponse response = this.linkedResponse();
            this.pullDownLinked(response);
            this.linkBinding.pushDown((Envelope)response);
            if ((newStatus & 4) != 0) {
                this.linkBinding.feedDown();
            } else {
                do {
                    if (((oldStatus = this.status) & 0x10) != 0 || !this.downQueueIsEmpty()) {
                        newStatus = oldStatus;
                        break;
                    }
                    newStatus = oldStatus & 0xFFFFFFDF;
                } while (!STATUS.compareAndSet(this, oldStatus, newStatus));
                if (oldStatus == newStatus) {
                    this.linkBinding.feedDown();
                }
            }
        } else {
            EventMessage message = this.nextDownQueueEvent();
            if (message == null && (oldStatus & 0x10) != 0) {
                while (!STATUS.compareAndSet(this, oldStatus = this.status, newStatus = oldStatus & 0xFFFFFFEF)) {
                }
                message = this.nextDownCueEvent();
            }
            if (message != null) {
                this.pullDownEvent(message);
                this.linkBinding.pushDown((Envelope)message);
                while (oldStatus != (newStatus = ((oldStatus = this.status) & 0x14) == 0 && this.downQueueIsEmpty() ? oldStatus & 0xFFFFFFDF : oldStatus | 0x20) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
                }
                if ((newStatus & 0x20) != 0) {
                    this.linkBinding.feedDown();
                }
            } else if ((oldStatus & 4) != 0) {
                SyncedResponse response = this.syncedResponse();
                this.pullDownSynced(response);
                this.linkBinding.pushDown((Envelope)response);
                while (!STATUS.compareAndSet(this, oldStatus, newStatus = ((oldStatus = this.status) & 0x10) == 0 && this.downQueueIsEmpty() ? oldStatus & 0xFFFFFFDB : oldStatus & 0xFFFFFFFB)) {
                }
                if ((newStatus & 0x20) != 0) {
                    this.linkBinding.feedDown();
                }
            } else {
                this.linkBinding.skipDown();
                do {
                    if (((oldStatus = this.status) & 0x10) != 0 || !this.downQueueIsEmpty()) {
                        newStatus = oldStatus;
                        break;
                    }
                    newStatus = oldStatus & 0xFFFFFFDF;
                } while (!STATUS.compareAndSet(this, oldStatus, newStatus));
                if ((newStatus & 0x20) != 0) {
                    this.linkBinding.feedDown();
                }
            }
        }
    }

    protected void pullDownEvent(EventMessage message) {
        this.onEvent(message);
        this.dispatchOnEvent(message);
    }

    protected void pullDownLinked(LinkedResponse response) {
        this.didLink(response);
        this.dispatchOnLinked(response);
    }

    protected void pullDownSynced(SyncedResponse response) {
        this.didSync(response);
        this.dispatchOnSynced(response);
    }

    protected void pullDownUnlinked(UnlinkedResponse response) {
        this.didUnlink(response);
        this.dispatchOnUnlinked(response);
    }

    public void cueUp() {
        int newStatus;
        int oldStatus;
        while (oldStatus != (newStatus = ((oldStatus = this.status) & 0x40) != 0 ? oldStatus & 0xFFFFFFBF | 0x80 : oldStatus & 0xFFFFFF7F) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 0x40) != 0) {
            this.linkBinding.pullUp();
        }
    }

    @Override
    public void feedUp() {
        int newStatus;
        int oldStatus;
        while (oldStatus != (newStatus = ((oldStatus = this.status) & 0x80) == 0 ? oldStatus & 0xFFFFFFBF | 0x80 : oldStatus | 0x40) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 0x80) == 0) {
            this.linkBinding.pullUp();
        }
    }

    @Override
    public void pushUp(Envelope envelope) {
        if (envelope instanceof CommandMessage) {
            this.pushUpCommand((CommandMessage)envelope);
        } else if (envelope instanceof LinkRequest) {
            this.pushUpLink((LinkRequest)envelope);
        } else if (envelope instanceof SyncRequest) {
            this.pushUpSync((SyncRequest)envelope);
        } else if (envelope instanceof UnlinkRequest) {
            this.pushUpUnlink((UnlinkRequest)envelope);
        } else {
            this.pushUpEnvelope(envelope);
        }
    }

    protected void pushUpCommand(CommandMessage message) {
        this.onCommand(message);
        this.laneBinding().pushUpCommand(message);
        if (!this.dispatchOnCommand(message, true)) {
            this.stage().execute((Runnable)new UplinkModemOnCommand(this, message));
        } else {
            this.cueUp();
        }
    }

    protected void runOnCommand(CommandMessage message) {
        block6: {
            try {
                this.dispatchOnCommand(message, false);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break block6;
                }
                throw error;
            }
            finally {
                this.cueUp();
            }
        }
    }

    protected void pushUpLink(LinkRequest request) {
        this.willLink(request);
        if (!this.dispatchOnLink(request, true)) {
            this.stage().execute((Runnable)new UplinkModemOnLink(this, request));
        } else {
            this.cueUp();
        }
    }

    protected void runOnLink(LinkRequest request) {
        block6: {
            try {
                this.dispatchOnLink(request, false);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break block6;
                }
                throw error;
            }
            finally {
                this.cueUp();
            }
        }
    }

    protected void pushUpSync(SyncRequest request) {
        this.willSync(request);
        if (!this.dispatchOnSync(request, true)) {
            this.stage().execute((Runnable)new UplinkModemOnSync(this, request));
        } else {
            this.cueUp();
        }
    }

    protected void runOnSync(SyncRequest request) {
        block6: {
            try {
                this.dispatchOnSync(request, false);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break block6;
                }
                throw error;
            }
            finally {
                this.cueUp();
            }
        }
    }

    protected void pushUpUnlink(UnlinkRequest request) {
        this.willUnlink(request);
        if (!this.dispatchOnUnlink(request, true)) {
            this.stage().execute((Runnable)new UplinkModemOnUnlink(this, request));
        }
    }

    protected void runOnUnlink(UnlinkRequest request) {
        try {
            this.dispatchOnUnlink(request, false);
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    protected void pushUpEnvelope(Envelope envelope) {
        this.cueUp();
    }

    @Override
    public void skipUp() {
        this.cueUp();
    }

    public void unlink() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFF8 | 0x20 | 8) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 0x20) == 0) {
            this.linkBinding.feedDown();
        }
        if ((oldStatus & 0x40) != 0) {
            this.linkBinding.pullUp();
        }
    }

    @Override
    public void closeUp() {
        this.laneBinding().closeUplink(this.linkKey);
    }

    public void close() {
        this.closeUp();
    }

    @Override
    public void didOpenDown() {
    }

    @Override
    public void didCloseDown() {
    }

    protected void onEvent(EventMessage message) {
    }

    protected void onCommand(CommandMessage message) {
    }

    protected void willLink(LinkRequest request) {
        int newStatus;
        int oldStatus;
        while (oldStatus != (newStatus = ((oldStatus = this.status) & 0x40) == 0 ? oldStatus & 0xFFFFFF7F | 0x20 | 2 | 1 : oldStatus | 0x20 | 2 | 1) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 0x20) == 0) {
            this.linkBinding.feedDown();
        }
        if ((oldStatus & 0x40) != 0) {
            this.linkBinding.pullUp();
        }
    }

    protected void didLink(LinkedResponse response) {
    }

    protected void willSync(SyncRequest request) {
        int newStatus;
        int oldStatus;
        do {
            if (((oldStatus = this.status) & 1) == 0) {
                if ((oldStatus & 0x40) == 0) {
                    newStatus = oldStatus & 0xFFFFFF7F | 0x20 | 4 | 2 | 1;
                    continue;
                }
                newStatus = oldStatus | 0x20 | 4 | 2 | 1;
                continue;
            }
            newStatus = (oldStatus & 0x40) == 0 ? oldStatus & 0xFFFFFF7F | 0x20 | 4 : oldStatus | 0x20 | 4;
        } while (oldStatus != newStatus && !STATUS.compareAndSet(this, oldStatus, newStatus));
        if ((oldStatus & 0x20) == 0) {
            this.linkBinding.feedDown();
        }
        if ((oldStatus & 0x40) != 0) {
            this.linkBinding.pullUp();
        }
    }

    protected void didSync(SyncedResponse response) {
    }

    protected void willUnlink(UnlinkRequest request) {
        int newStatus;
        int oldStatus;
        while (oldStatus != (newStatus = ((oldStatus = this.status) & 0x40) == 0 ? oldStatus & 0xFFFFFF78 | 0x20 | 8 : oldStatus & 0xFFFFFFF8 | 0x20 | 8) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 0x20) == 0) {
            this.linkBinding.feedDown();
        }
        if ((oldStatus & 0x40) != 0) {
            this.linkBinding.pullUp();
        }
    }

    protected void didUnlink(UnlinkedResponse response) {
        this.close();
    }

    protected void didFail(Throwable error) {
        this.laneBinding().didFail(error);
    }

    protected LinkedResponse linkedResponse() {
        return new LinkedResponse(this.nodeUri(), this.laneUri(), this.prio(), this.rate(), this.body());
    }

    protected SyncedResponse syncedResponse() {
        return new SyncedResponse(this.nodeUri(), this.laneUri());
    }

    protected UnlinkedResponse unlinkedResponse() {
        return new UnlinkedResponse(this.nodeUri(), this.laneUri());
    }

    @Override
    public void traceUp(Object message) {
        this.laneBinding().trace(message);
    }

    @Override
    public void debugUp(Object message) {
        this.laneBinding().debug(message);
    }

    @Override
    public void infoUp(Object message) {
        this.laneBinding().info(message);
    }

    @Override
    public void warnUp(Object message) {
        this.laneBinding().warn(message);
    }

    @Override
    public void errorUp(Object message) {
        this.laneBinding().error(message);
    }

    public void trace(Object message) {
        this.linkBinding.traceDown(message);
    }

    public void debug(Object message) {
        this.linkBinding.debugDown(message);
    }

    public void info(Object message) {
        this.linkBinding.infoDown(message);
    }

    public void warn(Object message) {
        this.linkBinding.warnDown(message);
    }

    public void error(Object message) {
        this.linkBinding.errorDown(message);
    }
}

