/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.agent.AgentContext;
import swim.api.http.function.DecodeRequestHttp;
import swim.api.http.function.DidRequestHttp;
import swim.api.http.function.DidRespondHttp;
import swim.api.http.function.DoRespondHttp;
import swim.api.http.function.WillRequestHttp;
import swim.api.http.function.WillRespondHttp;
import swim.api.lane.Lane;
import swim.api.lane.ValueLane;
import swim.api.lane.function.DidCommand;
import swim.api.lane.function.DidEnter;
import swim.api.lane.function.DidLeave;
import swim.api.lane.function.DidUplink;
import swim.api.lane.function.WillCommand;
import swim.api.lane.function.WillEnter;
import swim.api.lane.function.WillLeave;
import swim.api.lane.function.WillUplink;
import swim.concurrent.Conts;
import swim.observable.function.DidSet;
import swim.observable.function.WillSet;
import swim.runtime.lane.LaneView;
import swim.runtime.lane.ValueLaneModel;
import swim.streamlet.Inlet;
import swim.streamlet.Outlet;
import swim.structure.Form;
import swim.structure.Item;
import swim.util.Cursor;

public class ValueLaneView<V>
extends LaneView
implements ValueLane<V> {
    protected final AgentContext agentContext;
    protected Form<V> valueForm;
    protected int flags;
    protected ValueLaneModel laneBinding;
    protected Outlet<? extends V> input;
    protected Inlet<? super V>[] outputs;
    protected int version;
    static final int RESIDENT = 1;
    static final int TRANSIENT = 2;
    static final int SIGNED = 4;

    ValueLaneView(AgentContext agentContext, Form<V> valueForm, int flags, Object observers) {
        super(observers);
        this.agentContext = agentContext;
        this.valueForm = valueForm;
        this.flags = flags;
        this.input = null;
        this.outputs = null;
        this.version = -1;
    }

    public ValueLaneView(AgentContext agentContext, Form<V> valueForm) {
        this(agentContext, valueForm, 1, null);
    }

    @Override
    public AgentContext agentContext() {
        return this.agentContext;
    }

    @Override
    public ValueLaneModel getLaneBinding() {
        return this.laneBinding;
    }

    void setLaneBinding(ValueLaneModel laneBinding) {
        this.laneBinding = laneBinding;
    }

    @Override
    public ValueLaneModel createLaneBinding() {
        return new ValueLaneModel(this.flags);
    }

    public final Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> ValueLaneView<V2> valueForm(Form<V2> valueForm) {
        return new ValueLaneView<V2>(this.agentContext, valueForm, this.flags, this.typesafeObservers(this.observers));
    }

    public <V2> ValueLaneView<V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public void setValueForm(Form<V> valueForm) {
        this.valueForm = valueForm;
    }

    protected Object typesafeObservers(Object observers) {
        return observers;
    }

    public final boolean isResident() {
        return (this.flags & 1) != 0;
    }

    public ValueLaneView<V> isResident(boolean isResident) {
        this.didSetResident(isResident);
        ValueLaneModel laneBinding = this.laneBinding;
        if (laneBinding != null) {
            laneBinding.isResident(isResident);
        }
        return this;
    }

    void didSetResident(boolean isResident) {
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public final boolean isTransient() {
        return (this.flags & 2) != 0;
    }

    public ValueLaneView<V> isTransient(boolean isTransient) {
        this.didSetTransient(isTransient);
        ValueLaneModel laneBinding = this.laneBinding;
        if (laneBinding != null) {
            laneBinding.isTransient(isTransient);
        }
        return this;
    }

    void didSetTransient(boolean isTransient) {
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public final boolean isSigned() {
        return (this.flags & 4) != 0;
    }

    public ValueLaneView<V> isSigned(boolean isSigned) {
        this.didSetSigned(isSigned);
        ValueLaneModel laneBinding = this.laneBinding;
        if (laneBinding != null) {
            laneBinding.isSigned(isSigned);
        }
        return this;
    }

    void didSetSigned(boolean isSigned) {
        this.flags = isSigned ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    @Override
    public void close() {
        this.laneBinding.closeLaneView(this);
    }

    @Override
    public ValueLaneView<V> observe(Object observer) {
        return (ValueLaneView)super.observe(observer);
    }

    @Override
    public ValueLaneView<V> unobserve(Object observer) {
        return (ValueLaneView)super.unobserve(observer);
    }

    public ValueLaneView<V> willSet(WillSet<V> willSet) {
        return this.observe(willSet);
    }

    public ValueLaneView<V> didSet(DidSet<V> didSet) {
        return this.observe(didSet);
    }

    @Override
    public ValueLaneView<V> willCommand(WillCommand willCommand) {
        return this.observe(willCommand);
    }

    @Override
    public ValueLaneView<V> didCommand(DidCommand didCommand) {
        return this.observe(didCommand);
    }

    @Override
    public ValueLaneView<V> willUplink(WillUplink willUplink) {
        return this.observe(willUplink);
    }

    @Override
    public ValueLaneView<V> didUplink(DidUplink didUplink) {
        return this.observe(didUplink);
    }

    @Override
    public ValueLaneView<V> willEnter(WillEnter willEnter) {
        return this.observe(willEnter);
    }

    @Override
    public ValueLaneView<V> didEnter(DidEnter didEnter) {
        return this.observe(didEnter);
    }

    @Override
    public ValueLaneView<V> willLeave(WillLeave willLeave) {
        return this.observe(willLeave);
    }

    @Override
    public ValueLaneView<V> didLeave(DidLeave didLeave) {
        return this.observe(didLeave);
    }

    @Override
    public ValueLaneView<V> decodeRequest(DecodeRequestHttp<Object> decodeRequest) {
        return this.observe(decodeRequest);
    }

    @Override
    public ValueLaneView<V> willRequest(WillRequestHttp<?> willRequest) {
        return this.observe(willRequest);
    }

    @Override
    public ValueLaneView<V> didRequest(DidRequestHttp<Object> didRequest) {
        return this.observe(didRequest);
    }

    @Override
    public ValueLaneView<V> doRespond(DoRespondHttp<Object> doRespond) {
        return this.observe(doRespond);
    }

    @Override
    public ValueLaneView<V> willRespond(WillRespondHttp<?> willRespond) {
        return this.observe(willRespond);
    }

    @Override
    public ValueLaneView<V> didRespond(DidRespondHttp<?> didRespond) {
        return this.observe(didRespond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map.Entry<Boolean, V> dispatchWillSet(Link link, V newValue, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLane((Lane)this);
                        SwimContext.setLink((Link)link);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillSet)) break block12;
                        if (((WillSet)observers).isPreemptive() != preemptive) break block13;
                        try {
                            newValue = ((WillSet)observers).willSet(newValue);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillSet)) continue;
                        if (((WillSet)observer).isPreemptive() == preemptive) {
                            try {
                                newValue = ((WillSet)observer).willSet(newValue);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            AbstractMap.SimpleImmutableEntry<Boolean, V> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Boolean, V>(complete, newValue);
            return simpleImmutableEntry;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidSet(Link link, V newValue, V oldValue, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLane((Lane)this);
                        SwimContext.setLink((Link)link);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidSet)) break block12;
                        if (((DidSet)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidSet)observers).didSet(newValue, oldValue);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidSet)) continue;
                        if (((DidSet)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidSet)observer).didSet(newValue, oldValue);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    public V laneWillSet(V newValue) {
        return newValue;
    }

    public void laneDidSet(V newValue, V oldValue) {
        this.invalidate();
        this.reconcile(0);
    }

    public V get() {
        Object state = this.valueForm.cast((Item)this.laneBinding.get());
        if (state == null) {
            state = this.valueForm.unit();
        }
        return (V)state;
    }

    public V set(V newValue) {
        return this.laneBinding.set(this, newValue);
    }

    public Outlet<? extends V> input() {
        return this.input;
    }

    public void bindInput(Outlet<? extends V> input) {
        if (this.input != null) {
            this.input.unbindOutput((Inlet)this);
        }
        this.input = input;
        if (this.input != null) {
            this.input.bindOutput((Inlet)this);
        }
    }

    public void unbindInput() {
        if (this.input != null) {
            this.input.unbindOutput((Inlet)this);
        }
        this.input = null;
    }

    public void disconnectInputs() {
        Outlet<? extends V> input = this.input;
        if (input != null) {
            input.unbindOutput((Inlet)this);
            this.input = null;
            input.disconnectInputs();
        }
    }

    public Iterator<Inlet<? super V>> outputIterator() {
        return this.outputs != null ? Cursor.array((Object[])this.outputs) : Cursor.empty();
    }

    public void bindOutput(Inlet<? super V> output) {
        Inlet<? super V>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        Inlet[] newOutputs = new Inlet[n + 1];
        if (n > 0) {
            System.arraycopy(oldOutputs, 0, newOutputs, 0, n);
        }
        newOutputs[n] = output;
        this.outputs = newOutputs;
    }

    public void unbindOutput(Inlet<? super V> output) {
        Inlet<? super V>[] oldOutputs = this.outputs;
        int n = oldOutputs != null ? oldOutputs.length : 0;
        for (int i = 0; i < n; ++i) {
            if (oldOutputs[i] != output) continue;
            if (n > 1) {
                Inlet[] newOutputs = new Inlet[n - 1];
                System.arraycopy(oldOutputs, 0, newOutputs, 0, i);
                System.arraycopy(oldOutputs, i + 1, newOutputs, i, n - 1 - i);
                this.outputs = newOutputs;
                break;
            }
            this.outputs = null;
            break;
        }
    }

    public void unbindOutputs() {
        Inlet<? super V>[] outputs = this.outputs;
        if (outputs != null) {
            this.outputs = null;
            for (Inlet<? super V> output : outputs) {
                output.unbindInput();
            }
        }
    }

    public void disconnectOutputs() {
        Inlet<? super V>[] outputs = this.outputs;
        if (outputs != null) {
            this.outputs = null;
            for (Inlet<? super V> output : outputs) {
                output.unbindInput();
                output.disconnectOutputs();
            }
        }
    }

    public void invalidateOutput() {
        this.invalidate();
    }

    public void invalidateInput() {
        this.invalidate();
    }

    public void invalidate() {
        if (this.version >= 0) {
            this.willInvalidate();
            this.version = -1;
            this.onInvalidate();
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].invalidateOutput();
            }
            this.didInvalidate();
        }
    }

    public void reconcileOutput(int version) {
        this.reconcile(version);
    }

    public void reconcileInput(int version) {
        this.reconcile(version);
    }

    public void reconcile(int version) {
        if (this.version < 0) {
            this.willReconcile(version);
            this.version = version;
            if (this.input != null) {
                this.input.reconcileInput(version);
            }
            this.onReconcile(version);
            int n = this.outputs != null ? this.outputs.length : 0;
            for (int i = 0; i < n; ++i) {
                this.outputs[i].reconcileOutput(version);
            }
            this.didReconcile(version);
        }
    }

    protected void willInvalidate() {
    }

    protected void onInvalidate() {
    }

    protected void didInvalidate() {
    }

    protected void willReconcile(int version) {
    }

    protected void onReconcile(int version) {
        if (this.input != null) {
            Object value = this.input.get();
            this.set(value);
        }
    }

    protected void didReconcile(int version) {
    }
}

