/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Iterator;
import java.util.Map;
import swim.api.uplink.Uplink;
import swim.collections.FingerTrieSeq;
import swim.runtime.LinkBinding;
import swim.runtime.lane.DemandMapLaneUplink;
import swim.runtime.lane.DemandMapLaneView;
import swim.runtime.lane.LaneModel;
import swim.runtime.lane.LaneView;
import swim.structure.Record;
import swim.structure.Value;

public class DemandMapLaneModel
extends LaneModel<DemandMapLaneView<?, ?>, DemandMapLaneUplink> {
    @Override
    protected DemandMapLaneUplink createUplink(LinkBinding link) {
        return new DemandMapLaneUplink(this, link);
    }

    @Override
    protected void didOpenLaneView(DemandMapLaneView<?, ?> view) {
        view.setLaneBinding(this);
    }

    void cueDownKey(Value key) {
        FingerTrieSeq uplinks;
        do {
            uplinks = this.uplinks;
            int n = uplinks.size();
            for (int i = 0; i < n; ++i) {
                ((DemandMapLaneUplink)uplinks.get(i)).cueDownKey(key);
            }
        } while (uplinks != this.uplinks);
    }

    void remove(Value key) {
        this.sendDown((Value)Record.create((int)1).attr("remove", (Value)Record.create((int)1).slot("key", key)));
    }

    Value nextDownCue(Value key, Uplink uplink) {
        Object views = this.views;
        if (views instanceof DemandMapLaneView) {
            return ((DemandMapLaneView)views).nextDownCue(key, uplink);
        }
        if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                Value value = ((DemandMapLaneView)viewArray[i]).nextDownCue(key, uplink);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    Iterator<Map.Entry<Value, Value>> syncKeys(Uplink uplink) {
        Object views = this.views;
        if (views instanceof DemandMapLaneView) {
            return ((DemandMapLaneView)views).syncKeys(uplink);
        }
        if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                Iterator<Map.Entry<Value, Value>> iterator = ((DemandMapLaneView)viewArray[i]).syncKeys(uplink);
                if (iterator == null) continue;
                return iterator;
            }
        }
        return null;
    }
}

