/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import java.util.Map;
import swim.runtime.downlink.DownlinkRelay;
import swim.runtime.downlink.ListDownlinkModel;
import swim.runtime.downlink.ListDownlinkView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.EventMessage;

final class ListDownlinkRelayRemove
extends DownlinkRelay<ListDownlinkModel, ListDownlinkView<?>> {
    final EventMessage message;
    final int index;
    Object key;
    Form<Object> valueForm;
    Value oldValue;
    Object oldObject;

    ListDownlinkRelayRemove(ListDownlinkModel model, EventMessage message, int index, Object key) {
        super(model, 4);
        this.message = message;
        this.index = index;
        this.key = key;
    }

    ListDownlinkRelayRemove(ListDownlinkModel model, int index, Object key) {
        super(model, 1, 3);
        this.message = null;
        this.index = index;
        this.key = key;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 2) {
            ((ListDownlinkModel)this.model).state.remove(this.index, this.key);
            if (this.oldValue == null) {
                this.oldValue = Value.absent();
            }
            if (this.valueForm != null) {
                this.oldObject = this.valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = this.valueForm.unit();
                }
            }
        }
    }

    @Override
    boolean runPhase(ListDownlinkView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.downlinkWillReceive(this.message);
            }
            return view.dispatchWillReceive(this.message.body(), preemptive);
        }
        if (phase == 1) {
            view.downlinkWillRemoveValue(this.index);
            Form valueForm = view.valueForm;
            this.valueForm = valueForm;
            Map.Entry entry = ((ListDownlinkModel)this.model).state.getEntry(this.index, this.key);
            this.oldValue = (Value)entry.getValue();
            this.key = entry.getKey();
            this.oldObject = valueForm.cast((Item)this.oldValue);
            if (this.oldObject == null) {
                this.oldObject = valueForm.unit();
            }
            if (preemptive) {
                view.downlinkWillRemove(this.index);
            }
            return view.dispatchWillRemove(this.index, preemptive);
        }
        if (phase == 2) {
            view.downlinkDidRemoveValue(this.index, this.oldValue);
            Form valueForm = view.valueForm;
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.downlinkDidRemove(this.index, this.oldObject);
            }
            return view.dispatchDidRemove(this.index, this.oldObject, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.downlinkDidReceive(this.message);
            }
            return view.dispatchDidReceive(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        if (this.message != null) {
            ((ListDownlinkModel)this.model).cueDown();
        } else {
            Record header = Record.create((int)2).slot("key", Value.fromObject((Object)this.key)).slot("index", this.index);
            ((ListDownlinkModel)this.model).pushUp((Value)Record.create((int)1).attr("remove", (Value)header));
        }
    }
}

