/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.downlink.Downlink;
import swim.api.policy.Policy;
import swim.api.policy.PolicyDirective;
import swim.collections.HashTrieMap;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.runtime.HostBinding;
import swim.runtime.HostContext;
import swim.runtime.HttpBinding;
import swim.runtime.LaneBinding;
import swim.runtime.LinkBinding;
import swim.runtime.NodeBinding;
import swim.runtime.PushRequest;
import swim.runtime.TierContext;
import swim.store.StoreBinding;
import swim.structure.Value;
import swim.uri.Uri;

public class HostProxy
implements HostBinding,
HostContext {
    protected final HostBinding hostBinding;
    protected HostContext hostContext;

    public HostProxy(HostBinding hostBinding) {
        this.hostBinding = hostBinding;
    }

    public final HostBinding hostBinding() {
        return this.hostBinding;
    }

    @Override
    public final HostContext hostContext() {
        return this.hostContext;
    }

    @Override
    public void setHostContext(HostContext hostContext) {
        this.hostContext = hostContext;
        this.hostBinding.setHostContext(this);
    }

    @Override
    public final TierContext tierContext() {
        return this;
    }

    @Override
    public <T> T unwrapHost(Class<T> hostClass) {
        if (hostClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return this.hostBinding.unwrapHost(hostClass);
    }

    @Override
    public Uri meshUri() {
        return this.hostContext.meshUri();
    }

    @Override
    public Value partKey() {
        return this.hostContext.partKey();
    }

    @Override
    public Uri hostUri() {
        return this.hostContext.hostUri();
    }

    @Override
    public Policy policy() {
        return this.hostContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this.hostContext.schedule();
    }

    @Override
    public Stage stage() {
        return this.hostContext.stage();
    }

    @Override
    public StoreBinding store() {
        return this.hostContext.store();
    }

    @Override
    public boolean isConnected() {
        return this.hostBinding.isConnected();
    }

    @Override
    public boolean isRemote() {
        return this.hostBinding.isRemote();
    }

    @Override
    public boolean isSecure() {
        return this.hostBinding.isSecure();
    }

    @Override
    public boolean isPrimary() {
        return this.hostBinding.isPrimary();
    }

    @Override
    public void setPrimary(boolean isPrimary) {
        this.hostBinding.setPrimary(isPrimary);
    }

    @Override
    public boolean isReplica() {
        return this.hostBinding.isReplica();
    }

    @Override
    public void setReplica(boolean isReplica) {
        this.hostBinding.setReplica(isReplica);
    }

    @Override
    public boolean isMaster() {
        return this.hostBinding.isMaster();
    }

    @Override
    public boolean isSlave() {
        return this.hostBinding.isSlave();
    }

    @Override
    public void didBecomeMaster() {
        this.hostBinding.didBecomeMaster();
    }

    @Override
    public void didBecomeSlave() {
        this.hostBinding.didBecomeSlave();
    }

    @Override
    public HashTrieMap<Uri, NodeBinding> getNodes() {
        return this.hostBinding.getNodes();
    }

    @Override
    public NodeBinding getNode(Uri nodeUri) {
        return this.hostBinding.getNode(nodeUri);
    }

    @Override
    public NodeBinding openNode(Uri nodeUri) {
        return this.hostBinding.openNode(nodeUri);
    }

    @Override
    public NodeBinding openNode(Uri nodeUri, NodeBinding node) {
        return this.hostBinding.openNode(nodeUri, node);
    }

    @Override
    public NodeBinding createNode(Uri nodeUri) {
        return this.hostContext.createNode(nodeUri);
    }

    @Override
    public NodeBinding injectNode(Uri nodeUri, NodeBinding node) {
        return this.hostContext.injectNode(nodeUri, node);
    }

    @Override
    public LaneBinding injectLane(Uri nodeUri, Uri laneUri, LaneBinding lane) {
        return this.hostContext.injectLane(nodeUri, laneUri, lane);
    }

    @Override
    public PolicyDirective<Identity> authenticate(Credentials credentials) {
        return this.hostContext.authenticate(credentials);
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.hostContext.bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.hostContext.openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
        this.hostContext.closeDownlink(link);
    }

    @Override
    public void httpDownlink(HttpBinding http) {
        this.hostContext.httpDownlink(http);
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.hostContext.pushDown(pushRequest);
    }

    @Override
    public void openUplink(LinkBinding link) {
        this.hostBinding.openUplink(link);
    }

    @Override
    public void httpUplink(HttpBinding http) {
        this.hostBinding.httpUplink(http);
    }

    @Override
    public void pushUp(PushRequest pushRequest) {
        this.hostBinding.pushUp(pushRequest);
    }

    public void trace(Object message) {
        this.hostContext.trace(message);
    }

    public void debug(Object message) {
        this.hostContext.debug(message);
    }

    public void info(Object message) {
        this.hostContext.info(message);
    }

    public void warn(Object message) {
        this.hostContext.warn(message);
    }

    public void error(Object message) {
        this.hostContext.error(message);
    }

    @Override
    public boolean isClosed() {
        return this.hostBinding.isClosed();
    }

    @Override
    public boolean isOpened() {
        return this.hostBinding.isOpened();
    }

    @Override
    public boolean isLoaded() {
        return this.hostBinding.isLoaded();
    }

    @Override
    public boolean isStarted() {
        return this.hostBinding.isStarted();
    }

    @Override
    public void open() {
        this.hostBinding.open();
    }

    @Override
    public void load() {
        this.hostBinding.load();
    }

    @Override
    public void start() {
        this.hostBinding.start();
    }

    @Override
    public void stop() {
        this.hostBinding.stop();
    }

    @Override
    public void unload() {
        this.hostBinding.unload();
    }

    @Override
    public void close() {
        this.hostBinding.close();
    }

    @Override
    public void willOpen() {
        this.hostContext.willOpen();
    }

    @Override
    public void didOpen() {
        this.hostContext.didOpen();
    }

    @Override
    public void willLoad() {
        this.hostContext.willLoad();
    }

    @Override
    public void didLoad() {
        this.hostContext.didLoad();
    }

    @Override
    public void willStart() {
        this.hostContext.willStart();
    }

    @Override
    public void didStart() {
        this.hostContext.didStart();
    }

    @Override
    public void didConnect() {
        this.hostContext.didConnect();
    }

    @Override
    public void didDisconnect() {
        this.hostContext.didDisconnect();
    }

    @Override
    public void willStop() {
        this.hostContext.willStop();
    }

    @Override
    public void didStop() {
        this.hostContext.didStop();
    }

    @Override
    public void willUnload() {
        this.hostContext.willUnload();
    }

    @Override
    public void didUnload() {
        this.hostContext.didUnload();
    }

    @Override
    public void willClose() {
        this.hostContext.willClose();
    }

    @Override
    public void didClose() {
        this.hostBinding.didClose();
    }

    @Override
    public void didFail(Throwable error) {
        this.hostBinding.didFail(error);
    }
}

