/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttPubRel;

final class MqttPubRelDecoder
extends Decoder<MqttPubRel> {
    final MqttDecoder mqtt;
    final int packetFlags;
    final int packetId;
    final int remaining;
    final int step;

    MqttPubRelDecoder(MqttDecoder mqtt, int packetFlags, int packetId, int remaining, int step) {
        this.mqtt = mqtt;
        this.packetFlags = packetFlags;
        this.packetId = packetId;
        this.remaining = remaining;
        this.step = step;
    }

    MqttPubRelDecoder(MqttDecoder mqtt) {
        this(mqtt, 0, 0, 0, 1);
    }

    public Decoder<MqttPubRel> feed(InputBuffer input) {
        return MqttPubRelDecoder.decode(input, this.mqtt, this.packetFlags, this.packetId, this.remaining, this.step);
    }

    static Decoder<MqttPubRel> decode(InputBuffer input, MqttDecoder mqtt, int packetFlags, int packetId, int remaining, int step) {
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return MqttPubRelDecoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6 && remaining > 0 && input.isCont()) {
            packetId = input.head() << 8;
            input = input.step();
            --remaining;
            step = 7;
        }
        if (step == 7 && remaining > 0 && input.isCont()) {
            packetId |= input.head();
            input = input.step();
            --remaining;
            step = 8;
        }
        if (step == 8 && remaining == 0) {
            return MqttPubRelDecoder.done((Object)mqtt.pubRel(packetFlags, packetId));
        }
        if (remaining < 0) {
            return MqttPubRelDecoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return MqttPubRelDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return MqttPubRelDecoder.error((Throwable)input.trap());
        }
        return new MqttPubRelDecoder(mqtt, packetFlags, packetId, remaining, step);
    }

    static Decoder<MqttPubRel> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttPubRelDecoder.decode(input, mqtt, 0, 0, 0, 1);
    }
}

