/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import java.nio.ByteBuffer;
import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttEntity;
import swim.mqtt.MqttPacket;
import swim.mqtt.MqttPayload;
import swim.mqtt.MqttQoS;
import swim.util.Murmur3;

public final class MqttPublish<T>
extends MqttPacket<T>
implements Debug {
    final int packetFlags;
    final String topicName;
    final int packetId;
    final MqttEntity<T> payload;
    static final int RETAIN_FLAG = 1;
    static final int QOS_MASK = 6;
    static final int QOS_SHIFT = 1;
    static final int DUP_FLAG = 8;
    private static int hashSeed;

    MqttPublish(int packetFlags, String topicName, int packetId, MqttEntity<T> payload) {
        this.packetFlags = packetFlags;
        this.topicName = topicName;
        this.packetId = packetId;
        this.payload = payload;
    }

    @Override
    public int packetType() {
        return 3;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public boolean retain() {
        return (this.packetFlags & 1) != 0;
    }

    public MqttPublish<T> retain(boolean retain) {
        int packetFlags = retain ? this.packetFlags | 1 : this.packetFlags & 0xFFFFFFFE;
        return new MqttPublish<T>(packetFlags, this.topicName, this.packetId, this.payload);
    }

    public MqttQoS qos() {
        return MqttQoS.from((this.packetFlags & 6) >>> 1);
    }

    public MqttPublish<T> qos(MqttQoS qos) {
        int packetFlags = this.packetFlags & 0xFFFFFFF9 | qos.code << 1 & 6;
        return new MqttPublish<T>(packetFlags, this.topicName, this.packetId, this.payload);
    }

    public boolean dup() {
        return (this.packetFlags & 8) != 0;
    }

    public MqttPublish<T> dup(boolean dup) {
        int packetFlags = dup ? this.packetFlags | 8 : this.packetFlags & 0xFFFFFFF7;
        return new MqttPublish<T>(packetFlags, this.topicName, this.packetId, this.payload);
    }

    public String topicName() {
        return this.topicName;
    }

    public MqttPublish<T> topicName(String topicName) {
        return new MqttPublish<T>(this.packetFlags, topicName, this.packetId, this.payload);
    }

    public boolean hasPacketId() {
        return (this.packetFlags & 6) >>> 1 != 0;
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttPublish<T> packetId(int packetId) {
        return new MqttPublish<T>(this.packetFlags, this.topicName, packetId, this.payload);
    }

    public MqttEntity<T> payload() {
        return this.payload;
    }

    public <U> MqttPublish<U> payload(MqttEntity<U> payload) {
        return new MqttPublish<U>(this.packetFlags, this.topicName, this.packetId, payload);
    }

    public <U> MqttPublish<U> payload(Encoder<?, ?> content, int length) {
        return new MqttPublish(this.packetFlags, this.topicName, this.packetId, MqttPayload.from(content, length));
    }

    public <U> MqttPublish<U> payload(ByteBuffer data) {
        return new MqttPublish(this.packetFlags, this.topicName, this.packetId, MqttPayload.from(data));
    }

    public MqttPublish<String> payload(String content) {
        return new MqttPublish<String>(this.packetFlags, this.topicName, this.packetId, MqttPayload.from(content));
    }

    @Override
    int bodySize(MqttEncoder mqtt) {
        int size = mqtt.sizeOfString(this.topicName);
        if (this.hasPacketId()) {
            size += 2;
        }
        return size += this.payload.mqttSize();
    }

    public Encoder<?, MqttPublish<T>> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.publishEncoder(this);
    }

    public Encoder<?, MqttPublish<T>> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodePublish(this, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttPublish) {
            MqttPublish that = (MqttPublish)other;
            return this.packetFlags == that.packetFlags && this.topicName.equals(that.topicName) && this.packetId == that.packetId && this.payload.equals(that.payload);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttPublish.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.topicName.hashCode()), (int)this.packetId), (int)this.payload.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttPublish").write(46).write("from").write(40).debug((Object)this.topicName).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
        if (this.retain()) {
            output = output.write(46).write("retain").write(40).write("true").write(41);
        }
        if (this.qos().code != 0) {
            output = output.write(46).write("qos").write(40).debug((Object)this.qos()).write(41);
        }
        if (this.dup()) {
            output = output.write(46).write("dup").write(40).write("true").write(41);
        }
        if (this.hasPacketId()) {
            output = output.write(46).write("packetId").write(40).debug((Object)this.packetId).write(41);
        }
        if (this.payload.isDefined()) {
            output = output.write(46).write("payload").write(40).debug(this.payload).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> MqttPublish<T> from(int packetFlags, String topicName, int packetId, MqttEntity<T> payload) {
        return new MqttPublish<T>(packetFlags, topicName, packetId, payload);
    }

    public static <T> MqttPublish<T> from(String topicName, int packetId, MqttEntity<T> payload) {
        return new MqttPublish<T>(0, topicName, packetId, payload);
    }

    public static <T> MqttPublish<T> from(String topicName, MqttEntity<T> payload) {
        return new MqttPublish<T>(0, topicName, 0, payload);
    }

    public static MqttPublish<Object> from(String topicName) {
        return new MqttPublish<Object>(0, topicName, 0, MqttEntity.empty());
    }
}

