/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttPubAck
extends MqttPacket<Object>
implements Debug {
    final int packetFlags;
    final int packetId;
    private static int hashSeed;

    MqttPubAck(int packetFlags, int packetId) {
        this.packetFlags = packetFlags;
        this.packetId = packetId;
    }

    @Override
    public int packetType() {
        return 4;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttPubAck packetFlags(int packetFlags) {
        return new MqttPubAck(packetFlags, this.packetId);
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttPubAck packetId(int packetId) {
        return new MqttPubAck(this.packetFlags, packetId);
    }

    @Override
    int bodySize(MqttEncoder mqtt) {
        return 2;
    }

    public Encoder<?, MqttPubAck> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.pubAckEncoder(this);
    }

    public Encoder<?, MqttPubAck> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodePubAck(this, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttPubAck) {
            MqttPubAck that = (MqttPubAck)other;
            return this.packetFlags == that.packetFlags && this.packetId == that.packetId;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttPubAck.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.packetId));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttPubAck").write(46).write("from").write(40).debug((Object)this.packetId).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttPubAck from(int packetFlags, int packetId) {
        return new MqttPubAck(packetFlags, packetId);
    }

    public static MqttPubAck from(int packetId) {
        return new MqttPubAck(0, packetId);
    }
}

