/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttConnStatus;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttConnAck
extends MqttPacket<Object>
implements Debug {
    final int packetFlags;
    final int connectFlags;
    final int connectCode;
    static final int SESSION_PRESENT_FLAG = 1;
    private static int hashSeed;
    private static MqttConnAck accepted;

    MqttConnAck(int packetFlags, int connectFlags, int connectCode) {
        this.packetFlags = packetFlags;
        this.connectFlags = connectFlags;
        this.connectCode = connectCode;
    }

    @Override
    public int packetType() {
        return 2;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttConnAck packetFlags(int packetFlags) {
        return new MqttConnAck(packetFlags, this.connectFlags, this.connectCode);
    }

    public int connectFlags() {
        return this.connectFlags;
    }

    public int connectCode() {
        return this.connectCode;
    }

    public boolean sessionPresent() {
        return (this.connectFlags & 1) != 0;
    }

    public MqttConnAck sessionPresent(boolean sessionPresent) {
        int connectFlags = sessionPresent ? this.connectFlags | 1 : this.connectFlags & 0xFFFFFFFE;
        return new MqttConnAck(this.packetFlags, connectFlags, this.connectCode);
    }

    public MqttConnStatus connectStatus() {
        return MqttConnStatus.from(this.connectCode);
    }

    public MqttConnAck connectStatus(MqttConnStatus connectStatus) {
        return new MqttConnAck(this.packetFlags, this.connectFlags, connectStatus.code);
    }

    @Override
    int bodySize(MqttEncoder mqtt) {
        return 2;
    }

    public Encoder<?, MqttConnAck> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.connAckEncoder(this);
    }

    public Encoder<?, MqttConnAck> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodeConnAck(this, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttConnAck) {
            MqttConnAck that = (MqttConnAck)other;
            return this.packetFlags == that.packetFlags && this.connectFlags == that.connectFlags && this.connectCode == that.connectCode;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttConnAck.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.connectFlags), (int)this.connectCode));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttConnAck").write(46);
        if (this.packetFlags == 0 && this.connectFlags == 0 && this.connectCode == 0) {
            output = output.write(46).write("accepted").write(40).write(41);
        } else {
            output = output.write("from").write(40).debug((Object)this.connectStatus()).write(41);
            if (this.packetFlags != 0) {
                output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
            }
            if (this.sessionPresent()) {
                output = output.write(46).write("sessionPresent").write(40).write("true").write(41);
            }
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttConnAck accepted() {
        if (accepted == null) {
            accepted = new MqttConnAck(0, 0, 0);
        }
        return accepted;
    }

    public static MqttConnAck from(int packetFlags, int connectFlags, int connectCode) {
        if (packetFlags == 0 && connectFlags == 0 && connectCode == 0) {
            return MqttConnAck.accepted();
        }
        return new MqttConnAck(packetFlags, connectFlags, connectCode);
    }

    public static MqttConnAck from(MqttConnStatus connectStatus) {
        if (connectStatus.code == 0) {
            return MqttConnAck.accepted();
        }
        return new MqttConnAck(0, 0, connectStatus.code);
    }
}

