/*
 * Decompiled with CFR 0.152.
 */
package swim.io.mqtt;

import swim.io.SocketSettings;
import swim.io.mqtt.MqttSettings;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class MqttSettingsForm
extends Form<MqttSettings> {
    MqttSettingsForm() {
    }

    public MqttSettings unit() {
        return MqttSettings.standard();
    }

    public Class<?> type() {
        return MqttSettings.class;
    }

    public Item mold(MqttSettings settings) {
        if (settings != null) {
            MqttSettings standard = MqttSettings.standard();
            Record mqtt = Record.create((int)2).attr("mqtt");
            if (settings.maxPayloadSize != standard.maxPayloadSize) {
                mqtt.slot("maxPayloadSize", settings.maxPayloadSize);
            }
            return Record.of((Object)mqtt).concat(SocketSettings.form().mold((Object)settings.socketSettings));
        }
        return Item.extant();
    }

    public MqttSettings cast(Item item) {
        Value value = item.toValue();
        MqttSettings standard = MqttSettings.standard();
        int maxPayloadSize = standard.maxPayloadSize;
        for (Item member : value) {
            if (!member.getAttr("mqtt").isDefined()) continue;
            maxPayloadSize = member.get("maxPayloadSize").intValue(maxPayloadSize);
        }
        SocketSettings socketSettings = (SocketSettings)SocketSettings.form().cast((Item)value);
        return new MqttSettings(socketSettings, maxPayloadSize);
    }
}

