/*
 * Decompiled with CFR 0.152.
 */
package swim.io.mqtt;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.io.SocketSettings;
import swim.io.TcpSettings;
import swim.io.TlsSettings;
import swim.io.mqtt.MqttSettingsForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class MqttSettings
implements Debug {
    protected final SocketSettings socketSettings;
    protected final int maxPayloadSize;
    private static int hashSeed;
    private static MqttSettings standard;
    private static Form<MqttSettings> form;

    public MqttSettings(SocketSettings socketSettings, int maxPayloadSize) {
        this.socketSettings = socketSettings;
        this.maxPayloadSize = maxPayloadSize;
    }

    public final SocketSettings socketSettings() {
        return this.socketSettings;
    }

    public MqttSettings socketSettings(SocketSettings socketSettings) {
        return this.copy(socketSettings, this.maxPayloadSize);
    }

    public final TlsSettings tlsSettings() {
        return this.socketSettings.tlsSettings();
    }

    public MqttSettings tlsSettings(TlsSettings tlsSettings) {
        return this.socketSettings(this.socketSettings.tlsSettings(tlsSettings));
    }

    public final TcpSettings tcpSettings() {
        return this.socketSettings.tcpSettings();
    }

    public MqttSettings tcpSettings(TcpSettings tcpSettings) {
        return this.socketSettings(this.socketSettings.tcpSettings(tcpSettings));
    }

    public final int maxPayloadSize() {
        return this.maxPayloadSize;
    }

    public MqttSettings maxPayloadSize(int maxPayloadSize) {
        return this.copy(this.socketSettings, maxPayloadSize);
    }

    protected MqttSettings copy(SocketSettings socketSettings, int maxPayloadSize) {
        return new MqttSettings(socketSettings, maxPayloadSize);
    }

    public Value toValue() {
        return MqttSettings.form().mold((Object)this).toValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttSettings) {
            MqttSettings that = (MqttSettings)other;
            return this.socketSettings.equals((Object)that.socketSettings) && this.maxPayloadSize == that.maxPayloadSize;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttSettings.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.socketSettings.hashCode()), (int)this.maxPayloadSize));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttSettings").write(46).write("standard").write(40).write(41).write(46).write("socketSettings").write(40).debug((Object)this.socketSettings).write(41).write(46).write("maxPayloadSize").write(40).debug((Object)this.maxPayloadSize).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttSettings standard() {
        if (standard == null) {
            int maxPayloadSize;
            try {
                maxPayloadSize = Integer.parseInt(System.getProperty("swim.mqtt.max.payload.size"));
            }
            catch (NumberFormatException error) {
                maxPayloadSize = 0x1000000;
            }
            standard = new MqttSettings(SocketSettings.standard(), maxPayloadSize);
        }
        return standard;
    }

    public static MqttSettings from(SocketSettings socketSettings) {
        return MqttSettings.standard().socketSettings(socketSettings);
    }

    @Kind
    public static Form<MqttSettings> form() {
        if (form == null) {
            form = new MqttSettingsForm();
        }
        return form;
    }
}

