/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.ConnectionParser;
import swim.util.Murmur3;

public final class Connection
extends HttpHeader {
    final FingerTrieSeq<String> options;
    private static int hashSeed;
    private static Connection close;
    private static Connection upgrade;

    Connection(FingerTrieSeq<String> options) {
        this.options = options;
    }

    @Override
    public boolean isBlank() {
        return this.options.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "connection";
    }

    @Override
    public String name() {
        return "Connection";
    }

    public FingerTrieSeq<String> options() {
        return this.options;
    }

    public boolean contains(String option) {
        FingerTrieSeq<String> options = this.options;
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            if (!option.equalsIgnoreCase((String)options.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return http.writeTokenList(this.options.iterator(), output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Connection) {
            Connection that = (Connection)other;
            return this.options.equals(that.options);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Connection.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.options.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("Connection").write(46).write("from").write(40);
        int n = this.options.size();
        if (n > 0) {
            output.debug(this.options.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").write((String)this.options.get(i));
            }
        }
        output = output.write(41);
    }

    public static Connection close() {
        if (close == null) {
            close = new Connection((FingerTrieSeq<String>)FingerTrieSeq.of((Object[])new String[]{"close"}));
        }
        return close;
    }

    public static Connection upgrade() {
        if (upgrade == null) {
            upgrade = new Connection((FingerTrieSeq<String>)FingerTrieSeq.of((Object[])new String[]{"Upgrade"}));
        }
        return upgrade;
    }

    public static Connection from(FingerTrieSeq<String> options) {
        if (options.size() == 1) {
            String option = (String)options.head();
            if ("close".equals(option)) {
                return Connection.close();
            }
            if ("Upgrade".equals(option)) {
                return Connection.upgrade();
            }
        }
        return new Connection(options);
    }

    public static Connection from(String ... options) {
        return Connection.from((FingerTrieSeq<String>)FingerTrieSeq.of((Object[])options));
    }

    public static Parser<Connection> parseHttpValue(Input input, HttpParser http) {
        return ConnectionParser.parse(input, http);
    }
}

