/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.util.Iterator;
import swim.codec.Output;
import swim.codec.Unicode;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpHeader;
import swim.http.HttpRequest;
import swim.http.HttpWriter;

final class HttpRequestWriter<T>
extends Writer<Object, HttpRequest<T>> {
    final HttpWriter http;
    final HttpRequest<T> request;
    final Iterator<HttpHeader> headers;
    final Writer<?, ?> part;
    final int step;

    HttpRequestWriter(HttpWriter http, HttpRequest<T> request, Iterator<HttpHeader> headers, Writer<?, ?> part, int step) {
        this.http = http;
        this.request = request;
        this.headers = headers;
        this.part = part;
        this.step = step;
    }

    HttpRequestWriter(HttpWriter http, HttpRequest<T> request) {
        this(http, request, null, null, 1);
    }

    public Writer<Object, HttpRequest<T>> pull(Output<?> output) {
        return HttpRequestWriter.write(output, this.http, this.request, this.headers, this.part, this.step);
    }

    static <T> Writer<Object, HttpRequest<T>> write(Output<?> output, HttpWriter http, HttpRequest<T> request, Iterator<HttpHeader> headers, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? request.method.writeHttp(output, http) : part.pull(output)).isDone()) {
                part = null;
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2 && output.isCont()) {
            output = output.write(32);
            step = 3;
        }
        if (step == 3) {
            if ((part = part == null ? Unicode.writeString((Object)request.uri.toString(), (Output)output) : part.pull(output)).isDone()) {
                part = null;
                step = 4;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 4 && output.isCont()) {
            output = output.write(32);
            step = 5;
        }
        if (step == 5) {
            if ((part = part == null ? request.version.writeHttp(output, http) : part.pull(output)).isDone()) {
                part = null;
                step = 6;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 6 && output.isCont()) {
            output = output.write(13);
            step = 7;
        }
        if (step == 7 && output.isCont()) {
            output = output.write(10);
            step = 8;
        }
        while (true) {
            if (step == 8) {
                if (part == null) {
                    if (headers == null) {
                        headers = request.headers.iterator();
                    }
                    if (!headers.hasNext()) {
                        step = 11;
                        break;
                    }
                    part = ((HttpHeader)headers.next()).writeHttp(output, http);
                } else {
                    part = part.pull(output);
                }
                if (part.isDone()) {
                    part = null;
                    step = 9;
                } else if (part.isError()) {
                    return part.asError();
                }
            }
            if (step == 9 && output.isCont()) {
                output = output.write(13);
                step = 10;
            }
            if (step != 10 || !output.isCont()) break;
            output = output.write(10);
            step = 8;
        }
        if (step == 11 && output.isCont()) {
            output = output.write(13);
            step = 12;
        }
        if (step == 12 && output.isCont()) {
            output = output.write(10);
            return HttpRequestWriter.done(request);
        }
        if (output.isDone()) {
            return HttpRequestWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return HttpRequestWriter.error((Throwable)output.trap());
        }
        return new HttpRequestWriter<T>(http, request, headers, (Writer<?, ?>)part, step);
    }

    static <T> Writer<Object, HttpRequest<T>> write(Output<?> output, HttpWriter http, HttpRequest<T> request) {
        return HttpRequestWriter.write(output, http, request, null, null, 1);
    }
}

