/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.Http;
import swim.http.HttpHeader;
import swim.http.HttpParser;

final class HttpHeaderParser
extends Parser<HttpHeader> {
    final HttpParser http;
    final StringBuilder name;
    final Parser<? extends HttpHeader> value;
    final int step;

    HttpHeaderParser(HttpParser http, StringBuilder name, Parser<? extends HttpHeader> value, int step) {
        this.http = http;
        this.name = name;
        this.value = value;
        this.step = step;
    }

    HttpHeaderParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<HttpHeader> feed(Input input) {
        return HttpHeaderParser.parse(input, this.http, this.name, this.value, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<HttpHeader> parse(Input input, HttpParser http, StringBuilder name, Parser<? extends HttpHeader> value, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return HttpHeaderParser.error((Diagnostic)Diagnostic.expected((String)"HTTP header name", (Input)input));
                input = input.step();
                if (name == null) {
                    name = new StringBuilder();
                }
                name.appendCodePoint(c);
                step = 2;
            } else if (input.isDone()) {
                return HttpHeaderParser.error((Diagnostic)Diagnostic.expected((String)"HTTP header name", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                name.appendCodePoint(c);
            }
            if (input.isCont()) {
                step = 3;
            } else if (input.isDone()) {
                return HttpHeaderParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
            }
        }
        if (step == 3) {
            if (input.isCont() && input.head() == 58) {
                input = input.step();
                step = 4;
            } else if (!input.isEmpty()) {
                return HttpHeaderParser.error((Diagnostic)Diagnostic.expected((int)58, (Input)input));
            }
        }
        if (step == 4) {
            while (input.isCont() && Http.isSpace(c = input.head())) {
                input = input.step();
            }
            if (!input.isEmpty()) {
                step = 5;
            }
        }
        if (step == 5) {
            if ((value = value == null ? http.parseHeaderValue(name.toString(), input) : value.feed(input)).isDone()) {
                step = 6;
            } else if (value.isError()) {
                return value.asError();
            }
        }
        if (step == 6) {
            while (input.isCont() && Http.isSpace(c = input.head())) {
                input = input.step();
            }
            if (!input.isEmpty()) {
                return value;
            }
        }
        if (!input.isError()) return new HttpHeaderParser(http, name, value, step);
        return HttpHeaderParser.error((Throwable)input.trap());
    }

    static Parser<HttpHeader> parse(Input input, HttpParser http) {
        return HttpHeaderParser.parse(input, http, null, null, 1);
    }
}

