/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Base10;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.LanguageRange;

final class LanguageRangeParser
extends Parser<LanguageRange> {
    final HttpParser http;
    final StringBuilder tag;
    final StringBuilder subtag;
    final Parser<Float> weight;
    final int step;

    LanguageRangeParser(HttpParser http, StringBuilder tag, StringBuilder subtag, Parser<Float> weight, int step) {
        this.http = http;
        this.tag = tag;
        this.subtag = subtag;
        this.weight = weight;
        this.step = step;
    }

    LanguageRangeParser(HttpParser http) {
        this(http, null, null, null, 1);
    }

    public Parser<LanguageRange> feed(Input input) {
        return LanguageRangeParser.parse(input, this.http, this.tag, this.subtag, this.weight, this.step);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<LanguageRange> parse(Input input, HttpParser http, StringBuilder tag, StringBuilder subtag, Parser<Float> weight2222, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (Http.isAlpha(c)) {
                    input = input.step();
                    if (tag == null) {
                        tag = new StringBuilder();
                    }
                    tag.appendCodePoint(c);
                    step = 2;
                } else {
                    if (c != 42) return LanguageRangeParser.error((Diagnostic)Diagnostic.expected((String)"language tag", (Input)input));
                    input = input.step();
                    tag = new StringBuilder("*");
                    step = 18;
                }
            } else if (input.isDone()) {
                return LanguageRangeParser.error((Diagnostic)Diagnostic.expected((String)"language tag", (Input)input));
            }
        }
        while (step >= 2 && step <= 8) {
            if (input.isCont()) {
                c = input.head();
                if (Http.isAlpha(c)) {
                    input = input.step();
                    tag.appendCodePoint(c);
                    ++step;
                    continue;
                }
                if (c == 45) {
                    input = input.step();
                    step = 9;
                    break;
                }
                step = 18;
                break;
            }
            if (!input.isDone()) break;
            step = 18;
            break;
        }
        if (step == 9) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isAlpha(c) && !Base10.isDigit((int)c)) return LanguageRangeParser.error((Diagnostic)Diagnostic.expected((String)"language subtag", (Input)input));
                input = input.step();
                if (subtag == null) {
                    subtag = new StringBuilder();
                }
                subtag.appendCodePoint(c);
                step = 10;
            } else if (input.isDone()) {
                return LanguageRangeParser.error((Diagnostic)Diagnostic.expected((String)"language subtag", (Input)input));
            }
        }
        while (step >= 10 && step <= 17) {
            if (input.isCont()) {
                c = input.head();
                if (Http.isAlpha(c) || Base10.isDigit((int)c)) {
                    input = input.step();
                    subtag.appendCodePoint(c);
                    ++step;
                    continue;
                }
                step = 18;
                break;
            }
            if (!input.isDone()) break;
            step = 18;
            break;
        }
        if (step == 18) {
            void weight2222;
            if (weight2222 == null) {
                Parser<Float> weight2222 = http.parseQValue(input);
            } else {
                Object weight2222;
                Parser weight2222 = weight2222.feed(input);
            }
            if (weight2222.isDone()) {
                Float qvalue = (Float)weight2222.bind();
                float q = qvalue != null ? qvalue.floatValue() : 1.0f;
                return LanguageRangeParser.done((Object)http.languageRange(tag.toString(), subtag != null ? subtag.toString() : null, q));
            }
            if (weight2222.isError()) {
                return weight2222.asError();
            }
        }
        if (!input.isError()) void weight2222;
        return new LanguageRangeParser(http, tag, subtag, (Parser<Float>)weight2222, step);
        return LanguageRangeParser.error((Throwable)input.trap());
    }

    static Parser<LanguageRange> parse(Input input, HttpParser http) {
        return LanguageRangeParser.parse(input, http, null, null, null, 1);
    }
}

