/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import swim.codec.Binary;
import swim.codec.Debug;
import swim.codec.Decoder;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.InputBuffer;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpEntity;
import swim.http.HttpHeader;
import swim.http.HttpMessage;
import swim.http.HttpWriter;
import swim.http.MediaType;
import swim.http.TransferCoding;
import swim.http.header.ContentType;
import swim.http.header.TransferEncoding;
import swim.util.Murmur3;

public final class HttpChunked<T>
extends HttpEntity<T>
implements Debug {
    final T value;
    final Encoder<?, ?> content;
    final MediaType mediaType;
    private static int hashSeed;

    HttpChunked(T value, Encoder<?, ?> content, MediaType mediaType) {
        this.value = value;
        this.content = content;
        this.mediaType = mediaType;
    }

    @Override
    public boolean isDefined() {
        return this.value != null;
    }

    @Override
    public T get() {
        return this.value;
    }

    public Encoder<?, ?> content() {
        return this.content;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public MediaType mediaType() {
        return this.mediaType;
    }

    @Override
    public FingerTrieSeq<TransferCoding> transferCodings() {
        return TransferEncoding.chunked().codings();
    }

    @Override
    public FingerTrieSeq<HttpHeader> headers() {
        FingerTrieSeq headers = FingerTrieSeq.empty();
        if (this.mediaType != null) {
            headers = headers.appended((Object)ContentType.from(this.mediaType));
        }
        headers = headers.appended((Object)TransferEncoding.chunked());
        return headers;
    }

    @Override
    public <T2> Encoder<?, HttpMessage<T2>> httpEncoder(HttpMessage<T2> message, HttpWriter http) {
        return http.chunkedEncoder(message, this.content);
    }

    @Override
    public <T2> Encoder<?, HttpMessage<T2>> encodeHttp(HttpMessage<T2> message, OutputBuffer<?> output, HttpWriter http) {
        return http.encodeChunked(message, this.content, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpChunked) {
            HttpChunked that = (HttpChunked)other;
            return (this.value == null ? that.value == null : this.value.equals(that.value)) && this.content.equals(that.content) && (this.mediaType == null ? that.mediaType == null : this.mediaType.equals(that.mediaType));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpChunked.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash(this.value)), (int)this.content.hashCode()), (int)Murmur3.hash((Object)this.mediaType)));
    }

    public void debug(Output<?> output) {
        output = output.write("HttpChunked").write(46).write("from").write(40);
        if (this.value != null) {
            output.debug(this.value).write(", ");
        }
        output.debug(this.content);
        if (this.mediaType != null) {
            output = output.write(", ").debug((Object)this.mediaType);
        }
        output = output.write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> HttpChunked<T> from(T value, Encoder<?, T> content, MediaType mediaType) {
        return new HttpChunked<T>(value, content, mediaType);
    }

    public static <T> HttpChunked<T> from(T value, Encoder<?, T> content) {
        return new HttpChunked<T>(value, content, null);
    }

    public static <T> HttpChunked<T> from(Encoder<?, T> content, MediaType mediaType) {
        return new HttpChunked<Object>(null, content, mediaType);
    }

    public static <T> HttpChunked<T> from(Encoder<?, T> content) {
        return new HttpChunked<Object>(null, content, null);
    }

    public static <T> HttpChunked<T> fromFile(String path, MediaType mediaType) throws IOException {
        FileChannel channel = FileChannel.open(Paths.get(path, new String[0]), StandardOpenOption.READ);
        return new HttpChunked<Object>(null, Binary.channelEncoder((ReadableByteChannel)channel), mediaType);
    }

    public static <T> HttpChunked<T> fromFile(String path) throws IOException {
        return HttpChunked.fromFile(path, MediaType.forFile(path));
    }

    public static <T> Decoder<HttpMessage<T>> httpDecoder(HttpMessage<?> message, Decoder<T> content) {
        return Http.standardParser().chunkedDecoder(message, content);
    }

    public static <T> Decoder<HttpMessage<T>> decodeHttp(HttpMessage<?> message, Decoder<T> content, InputBuffer input) {
        return Http.standardParser().decodeChunked(message, content, input);
    }
}

