/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpWriter;

final class ContentCodingWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final String name;
    final float weight;
    final Writer<?, ?> part;
    final int step;

    ContentCodingWriter(HttpWriter http, String name, float weight, Writer<?, ?> part, int step) {
        this.http = http;
        this.name = name;
        this.weight = weight;
        this.part = part;
        this.step = step;
    }

    ContentCodingWriter(HttpWriter http, String name, float weight) {
        this(http, name, weight, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return ContentCodingWriter.write(output, this.http, this.name, this.weight, this.part, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String name, float weight, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? http.writeToken(name, output) : part.pull(output)).isDone()) {
                part = null;
                if (weight == 1.0f) {
                    return ContentCodingWriter.done();
                }
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2) {
            if ((part = part == null ? http.writeQValue(weight, output) : part.pull(output)).isDone()) {
                return ContentCodingWriter.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return ContentCodingWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return ContentCodingWriter.error((Throwable)output.trap());
        }
        return new ContentCodingWriter(http, name, weight, part, step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String name, float weight) {
        return ContentCodingWriter.write(output, http, name, weight, null, 1);
    }
}

