/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpCharset;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.AcceptCharsetParser;
import swim.util.Builder;
import swim.util.Murmur3;

public final class AcceptCharset
extends HttpHeader {
    final FingerTrieSeq<HttpCharset> charsets;
    private static int hashSeed;

    AcceptCharset(FingerTrieSeq<HttpCharset> charsets) {
        this.charsets = charsets;
    }

    @Override
    public boolean isBlank() {
        return this.charsets.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "accept-charset";
    }

    @Override
    public String name() {
        return "Accept-Charset";
    }

    public FingerTrieSeq<HttpCharset> charsets() {
        return this.charsets;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return http.writeParamList(this.charsets.iterator(), output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof AcceptCharset) {
            AcceptCharset that = (AcceptCharset)other;
            return this.charsets.equals(that.charsets);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(AcceptCharset.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.charsets.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("AcceptCharset").write(46).write("from").write(40);
        int n = this.charsets.size();
        if (n > 0) {
            output.debug(this.charsets.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.charsets.get(i));
            }
        }
        output = output.write(41);
    }

    public static AcceptCharset from(FingerTrieSeq<HttpCharset> charsets) {
        return new AcceptCharset(charsets);
    }

    public static AcceptCharset from(HttpCharset ... charsets) {
        return new AcceptCharset((FingerTrieSeq<HttpCharset>)FingerTrieSeq.of((Object[])charsets));
    }

    public static AcceptCharset from(String ... charsetStrings) {
        Builder charsets = FingerTrieSeq.builder();
        int n = charsetStrings.length;
        for (int i = 0; i < n; ++i) {
            charsets.add((Object)HttpCharset.parse(charsetStrings[i]));
        }
        return new AcceptCharset((FingerTrieSeq<HttpCharset>)((FingerTrieSeq)charsets.bind()));
    }

    public static Parser<AcceptCharset> parseHttpValue(Input input, HttpParser http) {
        return AcceptCharsetParser.parse(input, http);
    }
}

