/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.WebSocketExtension;
import swim.http.header.SecWebSocketExtensionsParser;
import swim.util.Builder;
import swim.util.Murmur3;

public final class SecWebSocketExtensions
extends HttpHeader {
    final FingerTrieSeq<WebSocketExtension> extensions;
    private static int hashSeed;

    SecWebSocketExtensions(FingerTrieSeq<WebSocketExtension> extensions) {
        this.extensions = extensions;
    }

    @Override
    public boolean isBlank() {
        return this.extensions.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "sec-websocket-extensions";
    }

    @Override
    public String name() {
        return "Sec-WebSocket-Extensions";
    }

    public FingerTrieSeq<WebSocketExtension> extensions() {
        return this.extensions;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return http.writeParamList(this.extensions.iterator(), output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SecWebSocketExtensions) {
            SecWebSocketExtensions that = (SecWebSocketExtensions)other;
            return this.extensions.equals(that.extensions);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(SecWebSocketExtensions.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.extensions.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("SecWebSocketExtensions").write(46).write("from").write(40);
        int n = this.extensions.size();
        if (n > 0) {
            output.debug(this.extensions.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.extensions.get(i));
            }
        }
        output = output.write(41);
    }

    public static SecWebSocketExtensions from(FingerTrieSeq<WebSocketExtension> extensions) {
        return new SecWebSocketExtensions(extensions);
    }

    public static SecWebSocketExtensions from(WebSocketExtension ... extensions) {
        return new SecWebSocketExtensions((FingerTrieSeq<WebSocketExtension>)FingerTrieSeq.of((Object[])extensions));
    }

    public static SecWebSocketExtensions from(String ... extensionStrings) {
        Builder extensions = FingerTrieSeq.builder();
        int n = extensionStrings.length;
        for (int i = 0; i < n; ++i) {
            extensions.add((Object)WebSocketExtension.parse(extensionStrings[i]));
        }
        return new SecWebSocketExtensions((FingerTrieSeq<WebSocketExtension>)((FingerTrieSeq)extensions.bind()));
    }

    public static Parser<SecWebSocketExtensions> parseHttpValue(Input input, HttpParser http) {
        return SecWebSocketExtensionsParser.parse(input, http);
    }
}

