/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Base10;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.header.MaxForwards;

final class MaxForwardsParser
extends Parser<MaxForwards> {
    final int count;
    final int step;

    MaxForwardsParser(int count, int step) {
        this.count = count;
        this.step = step;
    }

    MaxForwardsParser() {
        this(0, 1);
    }

    public Parser<MaxForwards> feed(Input input) {
        return MaxForwardsParser.parse(input, this.count, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<MaxForwards> parse(Input input, int count, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Base10.isDigit((int)c)) return MaxForwardsParser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
                input = input.step();
                count = Base10.decodeDigit((int)c);
                step = 2;
            } else if (input.isDone()) {
                return MaxForwardsParser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Base10.isDigit((int)(c = input.head()))) {
                input = input.step();
                if ((count = 10 * count + Base10.decodeDigit((int)c)) >= 0) continue;
                return MaxForwardsParser.error((Diagnostic)Diagnostic.message((String)"max forwards overflow", (Input)input));
            }
            if (!input.isEmpty()) {
                return MaxForwardsParser.done((Object)MaxForwards.from(count));
            }
        }
        if (!input.isError()) return new MaxForwardsParser(count, step);
        return MaxForwardsParser.error((Throwable)input.trap());
    }

    static Parser<MaxForwards> parse(Input input) {
        return MaxForwardsParser.parse(input, 0, 1);
    }
}

