/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.LanguageRange;
import swim.http.header.AcceptLanguage;
import swim.util.Builder;

final class AcceptLanguageParser
extends Parser<AcceptLanguage> {
    final HttpParser http;
    final Parser<LanguageRange> language;
    final Builder<LanguageRange, FingerTrieSeq<LanguageRange>> languages;
    final int step;

    AcceptLanguageParser(HttpParser http, Parser<LanguageRange> language, Builder<LanguageRange, FingerTrieSeq<LanguageRange>> languages, int step) {
        this.http = http;
        this.language = language;
        this.languages = languages;
        this.step = step;
    }

    AcceptLanguageParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<AcceptLanguage> feed(Input input) {
        return AcceptLanguageParser.parse(input, this.http, this.language, this.languages, this.step);
    }

    static Parser<AcceptLanguage> parse(Input input, HttpParser http, Parser<LanguageRange> language, Builder<LanguageRange, FingerTrieSeq<LanguageRange>> languages, int step) {
        block18: {
            int c = 0;
            if (step == 1) {
                if ((language = language == null ? http.parseLanguageRange(input) : language.feed(input)).isDone()) {
                    if (languages == null) {
                        languages = FingerTrieSeq.builder();
                    }
                    languages.add((Object)((LanguageRange)language.bind()));
                    language = null;
                    step = 2;
                } else if (language.isError()) {
                    return language.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 44) {
                        input = input.step();
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return AcceptLanguageParser.done((Object)AcceptLanguage.from((FingerTrieSeq<LanguageRange>)((FingerTrieSeq)languages.bind())));
                    }
                }
                if (step == 3) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        step = 4;
                    } else if (input.isDone()) {
                        return AcceptLanguageParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 4) break block18;
                if (!(language = language == null ? http.parseLanguageRange(input) : language.feed(input)).isDone()) break;
                languages.add((Object)((LanguageRange)language.bind()));
                language = null;
                step = 2;
            }
            if (language.isError()) {
                return language.asError();
            }
        }
        if (input.isError()) {
            return AcceptLanguageParser.error((Throwable)input.trap());
        }
        return new AcceptLanguageParser(http, (Parser<LanguageRange>)language, (Builder<LanguageRange, FingerTrieSeq<LanguageRange>>)languages, step);
    }

    static Parser<AcceptLanguage> parse(Input input, HttpParser http) {
        return AcceptLanguageParser.parse(input, http, null, null, 1);
    }
}

