/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.HashTrieMap;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.TransferCoding;

final class TransferCodingParser
extends Parser<TransferCoding> {
    final HttpParser http;
    final StringBuilder name;
    final Parser<HashTrieMap<String, String>> params;
    final int step;

    TransferCodingParser(HttpParser http, StringBuilder name, Parser<HashTrieMap<String, String>> params, int step) {
        this.http = http;
        this.name = name;
        this.params = params;
        this.step = step;
    }

    TransferCodingParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<TransferCoding> feed(Input input) {
        return TransferCodingParser.parse(input, this.http, this.name, this.params, this.step);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<TransferCoding> parse(Input input, HttpParser http, StringBuilder name, Parser<HashTrieMap<String, String>> params2222, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return TransferCodingParser.error((Diagnostic)Diagnostic.expected((String)"transfer coding", (Input)input));
                input = input.step();
                if (name == null) {
                    name = new StringBuilder();
                }
                name.appendCodePoint(c);
                step = 2;
            } else if (input.isDone()) {
                return TransferCodingParser.error((Diagnostic)Diagnostic.expected((String)"transfer coding", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                name.appendCodePoint(c);
            }
            if (input.isCont()) {
                step = 3;
            } else if (input.isDone()) {
                return TransferCodingParser.done((Object)http.transferCoding(name.toString(), (HashTrieMap<String, String>)HashTrieMap.empty()));
            }
        }
        if (step == 3) {
            void params2222;
            if (params2222 == null) {
                Parser<HashTrieMap<String, String>> params2222 = http.parseParamMap(input);
            } else {
                Object params2222;
                Parser params2222 = params2222.feed(input);
            }
            if (params2222.isDone()) {
                return TransferCodingParser.done((Object)http.transferCoding(name.toString(), (HashTrieMap<String, String>)((HashTrieMap)params2222.bind())));
            }
            if (params2222.isError()) {
                return params2222.asError();
            }
        }
        if (!input.isError()) void params2222;
        return new TransferCodingParser(http, name, (Parser<HashTrieMap<String, String>>)params2222, step);
        return TransferCodingParser.error((Throwable)input.trap());
    }

    static Parser<TransferCoding> parse(Input input, HttpParser http) {
        return TransferCodingParser.parse(input, http, null, null, 1);
    }
}

