/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Decoder;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.InputBuffer;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.http.ChunkExtension;
import swim.http.ChunkExtensionParser;
import swim.http.CommentParser;
import swim.http.ContentCoding;
import swim.http.ContentCodingParser;
import swim.http.HttpBodyDecoder;
import swim.http.HttpCharset;
import swim.http.HttpCharsetParser;
import swim.http.HttpChunkHeader;
import swim.http.HttpChunkHeaderParser;
import swim.http.HttpChunkTrailer;
import swim.http.HttpChunkTrailerParser;
import swim.http.HttpChunkedDecoder;
import swim.http.HttpHeader;
import swim.http.HttpHeaderParser;
import swim.http.HttpMessage;
import swim.http.HttpMethod;
import swim.http.HttpMethodParser;
import swim.http.HttpRequest;
import swim.http.HttpRequestParser;
import swim.http.HttpResponse;
import swim.http.HttpResponseParser;
import swim.http.HttpStatus;
import swim.http.HttpStatusParser;
import swim.http.HttpVersion;
import swim.http.HttpVersionParser;
import swim.http.LanguageRange;
import swim.http.LanguageRangeParser;
import swim.http.MediaRange;
import swim.http.MediaRangeParser;
import swim.http.MediaType;
import swim.http.MediaTypeParser;
import swim.http.ParamMapParser;
import swim.http.Product;
import swim.http.ProductParser;
import swim.http.QValueParser;
import swim.http.TokenListParser;
import swim.http.TransferCoding;
import swim.http.TransferCodingParser;
import swim.http.UpgradeProtocol;
import swim.http.UpgradeProtocolParser;
import swim.http.WebSocketExtension;
import swim.http.WebSocketExtensionParser;
import swim.http.WebSocketParam;
import swim.http.WebSocketParamParser;
import swim.http.header.Accept;
import swim.http.header.AcceptCharset;
import swim.http.header.AcceptEncoding;
import swim.http.header.AcceptLanguage;
import swim.http.header.Allow;
import swim.http.header.Connection;
import swim.http.header.ContentEncoding;
import swim.http.header.ContentLength;
import swim.http.header.ContentType;
import swim.http.header.Expect;
import swim.http.header.Host;
import swim.http.header.MaxForwards;
import swim.http.header.Origin;
import swim.http.header.RawHeader;
import swim.http.header.SecWebSocketAccept;
import swim.http.header.SecWebSocketExtensions;
import swim.http.header.SecWebSocketKey;
import swim.http.header.SecWebSocketProtocol;
import swim.http.header.SecWebSocketVersion;
import swim.http.header.Server;
import swim.http.header.TransferEncoding;
import swim.http.header.Upgrade;
import swim.http.header.UserAgent;
import swim.uri.Uri;

public class HttpParser {
    public <T> HttpRequest<T> request(HttpMethod method, Uri uri, HttpVersion version, FingerTrieSeq<HttpHeader> headers) {
        return HttpRequest.from(method, uri, version, headers);
    }

    public <T> HttpResponse<T> response(HttpVersion version, HttpStatus status, FingerTrieSeq<HttpHeader> headers) {
        return HttpResponse.from(version, status, headers);
    }

    public HttpMethod method(String name) {
        return HttpMethod.from(name);
    }

    public HttpStatus status(int code, String phrase) {
        return HttpStatus.from(code, phrase);
    }

    public HttpVersion version(int major, int minor) {
        return HttpVersion.from(major, minor);
    }

    public HttpChunkHeader chunkHeader(long size, FingerTrieSeq<ChunkExtension> extensions) {
        return HttpChunkHeader.from(size, extensions);
    }

    public HttpChunkTrailer chunkTrailer(FingerTrieSeq<HttpHeader> headers) {
        return HttpChunkTrailer.from(headers);
    }

    public ChunkExtension chunkExtension(String name, String value) {
        return ChunkExtension.from(name, value);
    }

    public HttpCharset charset(String name, float weight) {
        return HttpCharset.from(name, weight);
    }

    public LanguageRange languageRange(String tag, String subtag, float weight) {
        return LanguageRange.from(tag, subtag, weight);
    }

    public MediaRange mediaRange(String type, String subtype, float weight, HashTrieMap<String, String> params) {
        return MediaRange.from(type, subtype, weight, params);
    }

    public MediaType mediaType(String type, String subtype, HashTrieMap<String, String> params) {
        return MediaType.from(type, subtype, params);
    }

    public Product product(String name, String version, FingerTrieSeq<String> comments) {
        return Product.from(name, version, comments);
    }

    public ContentCoding contentCoding(String name, float weight) {
        return ContentCoding.from(name, weight);
    }

    public TransferCoding transferCoding(String name, HashTrieMap<String, String> params) {
        return TransferCoding.from(name, params);
    }

    public UpgradeProtocol upgradeProtocol(String name, String version) {
        return UpgradeProtocol.from(name, version);
    }

    public WebSocketParam webSocketParam(String key, String value) {
        return WebSocketParam.from(key, value);
    }

    public WebSocketExtension webSocketExtension(String name, FingerTrieSeq<WebSocketParam> params) {
        return WebSocketExtension.from(name, params);
    }

    public <T> Parser<HttpRequest<T>> requestParser() {
        return new HttpRequestParser(this);
    }

    public <T> Parser<HttpRequest<T>> parseRequest(Input input) {
        return HttpRequestParser.parse(input, this);
    }

    public <T> HttpRequest<T> parseRequestString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseRequest(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (HttpRequest)parser.bind();
    }

    public <T> Parser<HttpResponse<T>> responseParser() {
        return new HttpResponseParser(this);
    }

    public <T> Parser<HttpResponse<T>> parseResponse(Input input) {
        return HttpResponseParser.parse(input, this);
    }

    public <T> HttpResponse<T> parseResponseString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseResponse(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (HttpResponse)parser.bind();
    }

    public Parser<HttpMethod> methodParser() {
        return new HttpMethodParser(this);
    }

    public Parser<HttpMethod> parseMethod(Input input) {
        return HttpMethodParser.parse(input, this);
    }

    public HttpMethod parseMethodString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseMethod(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (HttpMethod)parser.bind();
    }

    public Parser<HttpStatus> statusParser() {
        return new HttpStatusParser(this);
    }

    public Parser<HttpStatus> parseStatus(Input input) {
        return HttpStatusParser.parse(input, this);
    }

    public HttpStatus parseStatusString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseStatus(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (HttpStatus)parser.bind();
    }

    public Parser<HttpVersion> versionParser() {
        return new HttpVersionParser(this);
    }

    public Parser<HttpVersion> parseVersion(Input input) {
        return HttpVersionParser.parse(input, this);
    }

    public HttpVersion parseVersionString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseVersion(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (HttpVersion)parser.bind();
    }

    public Parser<HttpHeader> headerParser() {
        return new HttpHeaderParser(this);
    }

    public Parser<HttpHeader> parseHeader(Input input) {
        return HttpHeaderParser.parse(input, this);
    }

    public HttpHeader parseHeaderString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseHeader(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (HttpHeader)parser.bind();
    }

    public Parser<? extends HttpHeader> parseHeaderValue(String name, Input input) {
        if ("Accept".equalsIgnoreCase(name)) {
            return Accept.parseHttpValue(input, this);
        }
        if ("Accept-Charset".equalsIgnoreCase(name)) {
            return AcceptCharset.parseHttpValue(input, this);
        }
        if ("Accept-Encoding".equalsIgnoreCase(name)) {
            return AcceptEncoding.parseHttpValue(input, this);
        }
        if ("Accept-Language".equalsIgnoreCase(name)) {
            return AcceptLanguage.parseHttpValue(input, this);
        }
        if ("Allow".equalsIgnoreCase(name)) {
            return Allow.parseHttpValue(input, this);
        }
        if ("Connection".equalsIgnoreCase(name)) {
            return Connection.parseHttpValue(input, this);
        }
        if ("Content-Encoding".equalsIgnoreCase(name)) {
            return ContentEncoding.parseHttpValue(input, this);
        }
        if ("Content-Length".equalsIgnoreCase(name)) {
            return ContentLength.parseHttpValue(input, this);
        }
        if ("Content-Type".equalsIgnoreCase(name)) {
            return ContentType.parseHttpValue(input, this);
        }
        if ("Expect".equalsIgnoreCase(name)) {
            return Expect.parseHttpValue(input, this);
        }
        if ("Host".equalsIgnoreCase(name)) {
            return Host.parseHttpValue(input, this);
        }
        if ("Max-Forwards".equalsIgnoreCase(name)) {
            return MaxForwards.parseHttpValue(input, this);
        }
        if ("Origin".equalsIgnoreCase(name)) {
            return Origin.parseHttpValue(input, this);
        }
        if ("Sec-WebSocket-Accept".equalsIgnoreCase(name)) {
            return SecWebSocketAccept.parseHttpValue(input, this);
        }
        if ("Sec-WebSocket-Extensions".equalsIgnoreCase(name)) {
            return SecWebSocketExtensions.parseHttpValue(input, this);
        }
        if ("Sec-WebSocket-Key".equalsIgnoreCase(name)) {
            return SecWebSocketKey.parseHttpValue(input, this);
        }
        if ("Sec-WebSocket-Protocol".equalsIgnoreCase(name)) {
            return SecWebSocketProtocol.parseHttpValue(input, this);
        }
        if ("Sec-WebSocket-Version".equalsIgnoreCase(name)) {
            return SecWebSocketVersion.parseHttpValue(input, this);
        }
        if ("Server".equals(name)) {
            return Server.parseHttpValue(input, this);
        }
        if ("Transfer-Encoding".equalsIgnoreCase(name)) {
            return TransferEncoding.parseHttpValue(input, this);
        }
        if ("Upgrade".equalsIgnoreCase(name)) {
            return Upgrade.parseHttpValue(input, this);
        }
        if ("User-Agent".equalsIgnoreCase(name)) {
            return UserAgent.parseHttpValue(input, this);
        }
        return RawHeader.parseHttpValue(input, this, name.toLowerCase(), name);
    }

    public Parser<HttpChunkHeader> chunkHeaderParser() {
        return new HttpChunkHeaderParser(this);
    }

    public Parser<HttpChunkHeader> parseChunkHeader(Input input) {
        return HttpChunkHeaderParser.parse(input, this);
    }

    public HttpChunkHeader parseChunkHeaderString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseChunkHeader(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (HttpChunkHeader)parser.bind();
    }

    public Parser<HttpChunkTrailer> chunkTrailerParser() {
        return new HttpChunkTrailerParser(this);
    }

    public Parser<HttpChunkTrailer> parseChunkTrailer(Input input) {
        return HttpChunkTrailerParser.parse(input, this);
    }

    public HttpChunkTrailer parseChunkTrailerString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseChunkTrailer(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (HttpChunkTrailer)parser.bind();
    }

    public Parser<ChunkExtension> chunkExtensionParser() {
        return new ChunkExtensionParser(this);
    }

    public Parser<ChunkExtension> parseChunkExtension(Input input) {
        return ChunkExtensionParser.parse(input, this);
    }

    public ChunkExtension parseChunkExtensionString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseChunkExtension(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (ChunkExtension)parser.bind();
    }

    public Parser<HttpCharset> charsetParser() {
        return new HttpCharsetParser(this);
    }

    public Parser<HttpCharset> parseCharset(Input input) {
        return HttpCharsetParser.parse(input, this);
    }

    public HttpCharset parseCharsetString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseCharset(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (HttpCharset)parser.bind();
    }

    public Parser<LanguageRange> languageRangeParser() {
        return new LanguageRangeParser(this);
    }

    public Parser<LanguageRange> parseLanguageRange(Input input) {
        return LanguageRangeParser.parse(input, this);
    }

    public LanguageRange parseLanguageRangeString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseLanguageRange(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (LanguageRange)parser.bind();
    }

    public Parser<MediaRange> mediaRangeParser() {
        return new MediaRangeParser(this);
    }

    public Parser<MediaRange> parseMediaRange(Input input) {
        return MediaRangeParser.parse(input, this);
    }

    public MediaRange parseMediaRangeString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseMediaRange(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (MediaRange)parser.bind();
    }

    public Parser<MediaType> mediaTypeParser() {
        return new MediaTypeParser(this);
    }

    public Parser<MediaType> parseMediaType(Input input) {
        return MediaTypeParser.parse(input, this);
    }

    public MediaType parseMediaTypeString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseMediaType(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (MediaType)parser.bind();
    }

    public Parser<Product> productParser() {
        return new ProductParser(this);
    }

    public Parser<Product> parseProduct(Input input) {
        return ProductParser.parse(input, this);
    }

    public Product parseProductString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseProduct(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (Product)parser.bind();
    }

    public Parser<ContentCoding> contentCodingParser() {
        return new ContentCodingParser(this);
    }

    public Parser<ContentCoding> parseContentCoding(Input input) {
        return ContentCodingParser.parse(input, this);
    }

    public ContentCoding parseContentCodingString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseContentCoding(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (ContentCoding)parser.bind();
    }

    public Parser<TransferCoding> transferCodingParser() {
        return new TransferCodingParser(this);
    }

    public Parser<TransferCoding> parseTransferCoding(Input input) {
        return TransferCodingParser.parse(input, this);
    }

    public TransferCoding parseTransferCodingString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseTransferCoding(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (TransferCoding)parser.bind();
    }

    public Parser<UpgradeProtocol> upgradeProtocolParser() {
        return new UpgradeProtocolParser(this);
    }

    public Parser<UpgradeProtocol> parseUpgradeProtocol(Input input) {
        return UpgradeProtocolParser.parse(input, this);
    }

    public UpgradeProtocol parseUpgradeProtocolString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseUpgradeProtocol(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (UpgradeProtocol)parser.bind();
    }

    public Parser<WebSocketParam> webSocketParamParser() {
        return new WebSocketParamParser(this);
    }

    public Parser<WebSocketParam> parseWebSocketParam(Input input) {
        return WebSocketParamParser.parse(input, this);
    }

    public WebSocketParam parseWebSocketParamString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseWebSocketParam(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (WebSocketParam)parser.bind();
    }

    public Parser<WebSocketExtension> webSocketExtensionParser() {
        return new WebSocketExtensionParser(this);
    }

    public Parser<WebSocketExtension> parseWebSocketExtension(Input input) {
        return WebSocketExtensionParser.parse(input, this);
    }

    public WebSocketExtension parseWebSocketExtensionString(String string) {
        Input input = Unicode.stringInput((String)string);
        Parser parser = this.parseWebSocketExtension(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return (WebSocketExtension)parser.bind();
    }

    public Parser<Float> parseQValue(Input input) {
        return QValueParser.parse(input);
    }

    public Parser<Float> parseQValueRest(Input input) {
        return QValueParser.parseRest(input);
    }

    public Parser<String> parseComment(Input input) {
        return CommentParser.parse(input);
    }

    public Parser<FingerTrieSeq<String>> parseTokenList(Input input) {
        return TokenListParser.parse(input);
    }

    public Parser<HashTrieMap<String, String>> parseParamMap(Input input) {
        return ParamMapParser.parse(input);
    }

    public Parser<HashTrieMap<String, String>> parseParamMapRest(Input input) {
        return ParamMapParser.parseRest(input);
    }

    public Parser<HashTrieMap<String, String>> parseParamMapRest(StringBuilder key, Input input) {
        return ParamMapParser.parseRest(input, key);
    }

    public <T> Decoder<HttpMessage<T>> bodyDecoder(HttpMessage<?> message, Decoder<T> content, long length) {
        return new HttpBodyDecoder<T>(message, content, length);
    }

    public <T> Decoder<HttpMessage<T>> decodeBody(HttpMessage<?> message, Decoder<T> content, long length, InputBuffer input) {
        return HttpBodyDecoder.decode(input, message, content, length);
    }

    public <T> Decoder<HttpMessage<T>> chunkedDecoder(HttpMessage<?> message, Decoder<T> content) {
        return new HttpChunkedDecoder<T>(this, message, content);
    }

    public <T> Decoder<HttpMessage<T>> decodeChunked(HttpMessage<?> message, Decoder<T> content, InputBuffer input) {
        return HttpChunkedDecoder.decode(input, this, message, content);
    }
}

