/*
 * Decompiled with CFR 0.152.
 */
package swim.concurrent;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.concurrent.Call;
import swim.concurrent.Cont;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.concurrent.StageClock;
import swim.concurrent.Task;
import swim.concurrent.TaskFunction;
import swim.concurrent.TaskRef;
import swim.concurrent.TheaterCall;
import swim.concurrent.TheaterTask;
import swim.concurrent.TheaterWorkerFactory;
import swim.concurrent.TimerFunction;
import swim.concurrent.TimerRef;

public class Theater
implements Stage,
Thread.UncaughtExceptionHandler {
    final String name;
    final Schedule schedule;
    final ForkJoinPool pool;
    volatile int status;
    static final int STARTED = 1;
    static final int STOPPED = 2;
    static final AtomicInteger THEATER_COUNT = new AtomicInteger(0);
    static final AtomicIntegerFieldUpdater<Theater> STATUS = AtomicIntegerFieldUpdater.newUpdater(Theater.class, "status");

    public Theater(String name, int parallelism, Schedule schedule) {
        this.name = name != null ? name : "SwimStage" + THEATER_COUNT.getAndIncrement() + ".";
        this.schedule = schedule != null ? schedule : new StageClock(this);
        this.pool = new ForkJoinPool(parallelism, new TheaterWorkerFactory(this), this, true);
    }

    public Theater(String name, int parallelism) {
        this(name, parallelism, null);
    }

    public Theater(String name, Schedule schedule) {
        this(name, Runtime.getRuntime().availableProcessors(), schedule);
    }

    public Theater(String name) {
        this(name, Runtime.getRuntime().availableProcessors(), null);
    }

    public Theater(int parallelism, Schedule schedule) {
        this(null, parallelism, schedule);
    }

    public Theater(int parallelism) {
        this(null, parallelism, null);
    }

    public Theater(Schedule schedule) {
        this(null, Runtime.getRuntime().availableProcessors(), schedule);
    }

    public Theater() {
        this(null, Runtime.getRuntime().availableProcessors(), null);
    }

    public void start() {
        int newStatus;
        int oldStatus;
        while (!STATUS.compareAndSet(this, oldStatus, newStatus = ((oldStatus = STATUS.get(this)) & 2) == 0 ? oldStatus | 1 : oldStatus)) {
        }
        if (oldStatus != newStatus) {
            this.didStart();
        } else if ((oldStatus & 2) != 0) {
            throw new IllegalStateException("Can't restart stopped theater");
        }
    }

    public void stop() {
        int newStatus;
        int oldStatus;
        while (!STATUS.compareAndSet(this, oldStatus = STATUS.get(this), newStatus = oldStatus | 2)) {
        }
        if (oldStatus != newStatus) {
            this.pool.shutdown();
            boolean interrupted = false;
            while (!this.pool.isTerminated()) {
                try {
                    this.pool.awaitTermination(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            this.didStop();
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void execute(Runnable runnable) {
        this.start();
        this.pool.execute(runnable);
    }

    @Override
    public TaskRef task(TaskFunction task) {
        this.start();
        TheaterTask context = new TheaterTask(this, task);
        if (task instanceof Task) {
            ((Task)task).setTaskContext(context);
        }
        return context;
    }

    @Override
    public <T> Call<T> call(Cont<T> cont) {
        this.start();
        return new TheaterCall<T>(this, cont);
    }

    @Override
    public TimerRef timer(TimerFunction timer) {
        this.start();
        return this.schedule.timer(timer);
    }

    @Override
    public TimerRef setTimer(long millis, TimerFunction timer) {
        this.start();
        return this.schedule.setTimer(millis, timer);
    }

    protected void didStart() {
    }

    protected void didStop() {
    }

    protected void didFail(Throwable error) {
        error.printStackTrace();
    }

    protected void taskWillCue(TaskFunction task) {
    }

    protected void taskDidCancel(TaskFunction task) {
    }

    protected void taskWillRun(TaskFunction task) {
    }

    protected void taskDidRun(TaskFunction task) {
    }

    protected void taskDidFail(TaskFunction task, Throwable error) {
    }

    protected void callWillCue(Cont<?> cont) {
    }

    protected <T> void callWillBind(Cont<T> cont, T value) {
    }

    protected <T> void callDidBind(Cont<?> cont, T value) {
    }

    protected void callWillTrap(Cont<?> cont, Throwable error) {
    }

    protected void callDidTrap(Cont<?> cont, Throwable error) {
    }

    protected void callDidFail(Cont<?> cont, Throwable error) {
    }

    @Override
    public void uncaughtException(Thread thead, Throwable error) {
        this.didFail(error);
    }
}

