/*
 * Decompiled with CFR 0.152.
 */
package swim.concurrent;

import swim.concurrent.ScheduleDef;
import swim.concurrent.TheaterDef;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Value;

final class TheaterForm
extends Form<TheaterDef> {
    final Form<ScheduleDef> scheduleForm;
    final TheaterDef unit;

    TheaterForm(Form<ScheduleDef> scheduleForm, TheaterDef unit) {
        this.scheduleForm = scheduleForm;
        this.unit = unit;
    }

    public String tag() {
        return "theater";
    }

    public TheaterDef unit() {
        return this.unit;
    }

    public Form<TheaterDef> unit(TheaterDef unit) {
        return new TheaterForm(this.scheduleForm, unit);
    }

    public Class<TheaterDef> type() {
        return TheaterDef.class;
    }

    public Item mold(TheaterDef theaterDef) {
        if (theaterDef != null) {
            Record record = Record.create((int)3).attr(this.tag());
            record.slot("parallelism", theaterDef.parallelism);
            if (theaterDef.scheduleDef != null) {
                record.add(this.scheduleForm.mold((Object)theaterDef.scheduleDef));
            }
            return theaterDef.name != null ? Slot.of((String)theaterDef.name, (Value)record) : record;
        }
        return Item.extant();
    }

    public TheaterDef cast(Item item) {
        Value value = item.toValue();
        Value header = value.getAttr(this.tag());
        if (header.isDefined()) {
            String name = item.key().stringValue(null);
            int parallelism = Runtime.getRuntime().availableProcessors();
            ScheduleDef scheduleDef = null;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                Item member = value.getItem(i);
                if (member.keyEquals((Object)"parallelism")) {
                    parallelism = member.toValue().intValue(parallelism);
                    continue;
                }
                ScheduleDef newScheduleDef = (ScheduleDef)this.scheduleForm.cast(member);
                if (newScheduleDef == null) continue;
                scheduleDef = newScheduleDef;
            }
            return new TheaterDef(name, parallelism, scheduleDef);
        }
        return null;
    }
}

