/*
 * Decompiled with CFR 0.152.
 */
package swim.api.downlink;

import java.util.Iterator;
import java.util.Map;
import swim.api.downlink.DownlinkRecord;
import swim.api.downlink.MapDownlink;
import swim.observable.function.DidClear;
import swim.observable.function.DidDrop;
import swim.observable.function.DidRemoveKey;
import swim.observable.function.DidTake;
import swim.observable.function.DidUpdateKey;
import swim.streamlet.KeyEffect;
import swim.structure.Item;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;

public class MapDownlinkRecord
extends DownlinkRecord
implements DidUpdateKey<Value, Value>,
DidRemoveKey<Value, Value>,
DidDrop,
DidTake,
DidClear {
    protected final MapDownlink<Value, Value> downlink;

    public MapDownlinkRecord(MapDownlink<Value, Value> downlink) {
        this.downlink = downlink;
        this.downlink.observe((Object)this);
    }

    @Override
    public MapDownlink<Value, Value> downlink() {
        return this.downlink;
    }

    public boolean isEmpty() {
        return this.downlink.isEmpty();
    }

    public boolean isArray() {
        return this.downlink.isEmpty();
    }

    public boolean isObject() {
        return true;
    }

    public int size() {
        return this.downlink.size();
    }

    public boolean containsKey(Value key) {
        return this.downlink.containsKey(key);
    }

    public boolean containsKey(String key) {
        return this.downlink.containsKey(Text.from((String)key));
    }

    public Value get(Value key) {
        return (Value)this.downlink.get(key);
    }

    public Value get(String key) {
        return (Value)this.downlink.get(key);
    }

    public Value getAttr(Text key) {
        return Value.absent();
    }

    public Value getAttr(String key) {
        return Value.absent();
    }

    public Value getSlot(Value key) {
        return this.get(key);
    }

    public Value getSlot(String key) {
        return this.get(key);
    }

    public Item get(int index) {
        Map.Entry entry = this.downlink.getEntry(index);
        if (entry != null) {
            return Slot.of((Value)((Value)entry.getKey()), (Value)((Value)entry.getValue()));
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    public Item getItem(int index) {
        Map.Entry entry = this.downlink.getEntry(index);
        if (entry != null) {
            return Slot.of((Value)((Value)entry.getKey()), (Value)((Value)entry.getValue()));
        }
        return Item.absent();
    }

    public Value put(Value key, Value newValue) {
        return (Value)this.downlink.put(key, newValue);
    }

    public Value put(String key, Value newValue) {
        return (Value)this.downlink.put(Text.from((String)key), newValue);
    }

    public Value putAttr(Text key, Value newValue) {
        throw new UnsupportedOperationException();
    }

    public Value putAttr(String key, Value newValue) {
        throw new UnsupportedOperationException();
    }

    public Value putSlot(Value key, Value newValue) {
        return this.put(key, newValue);
    }

    public Value putSlot(String key, Value newValue) {
        return this.put(key, newValue);
    }

    public Item setItem(int index, Item newItem) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Item item) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, Item item) {
        throw new UnsupportedOperationException();
    }

    public Item remove(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean removeKey(Value key) {
        return this.downlink.remove(key) != null;
    }

    public boolean removeKey(String key) {
        return this.downlink.remove(Text.from((String)key)) != null;
    }

    public void clear() {
        this.downlink.clear();
    }

    public Iterator<Value> keyIterator() {
        return this.downlink.keyIterator();
    }

    public void didUpdate(Value key, Value newValue, Value oldValue) {
        this.invalidateInputKey(key, KeyEffect.UPDATE);
        this.reconcileInput(0);
    }

    public void didRemove(Value key, Value oldValue) {
        this.invalidateInputKey(key, KeyEffect.REMOVE);
        this.reconcileInput(0);
    }

    public void didDrop(int lower) {
    }

    public void didTake(int upper) {
    }

    public void didClear() {
    }
}

