/*
 * Decompiled with CFR 0.152.
 */
package swim.api.agent;

import java.util.Map;
import swim.api.agent.Agent;
import swim.api.agent.AgentContext;
import swim.api.agent.AgentRoute;
import swim.api.agent.AgentRouteContext;
import swim.collections.HashTrieMap;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriPattern;

public abstract class AbstractAgentRoute<A extends Agent>
implements AgentRoute<A> {
    protected AgentRouteContext context;

    @Override
    public AgentRouteContext agentRouteContext() {
        return this.context;
    }

    @Override
    public void setAgentRouteContext(AgentRouteContext context) {
        this.context = context;
    }

    @Override
    public String routeName() {
        AgentRouteContext context = this.context;
        return context != null ? context.routeName() : null;
    }

    @Override
    public UriPattern pattern() {
        AgentRouteContext context = this.context;
        return context != null ? context.pattern() : null;
    }

    @Override
    public abstract A createAgent(AgentContext var1);

    @Override
    public Value props(Uri nodeUri) {
        Record props = Record.create();
        UriPattern pattern = this.pattern();
        if (pattern != null) {
            HashTrieMap params = pattern.unapply(nodeUri);
            for (Map.Entry param : params) {
                props.slot((String)param.getKey(), (String)param.getValue());
            }
        }
        return props;
    }
}

