/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.parquet.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.shaded.apache.parquet.Preconditions;
import org.shaded.apache.parquet.schema.ColumnOrder;
import org.shaded.apache.parquet.schema.DecimalMetadata;
import org.shaded.apache.parquet.schema.GroupType;
import org.shaded.apache.parquet.schema.MessageType;
import org.shaded.apache.parquet.schema.OriginalType;
import org.shaded.apache.parquet.schema.PrimitiveType;
import org.shaded.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Types {
    private static final int NOT_SET = 0;

    public static MessageTypeBuilder buildMessage() {
        return new MessageTypeBuilder();
    }

    public static PrimitiveBuilder<PrimitiveType> primitive(PrimitiveType.PrimitiveTypeName type, Type.Repetition repetition) {
        return (PrimitiveBuilder)new PrimitiveBuilder(PrimitiveType.class, type).repetition(repetition);
    }

    public static PrimitiveBuilder<PrimitiveType> required(PrimitiveType.PrimitiveTypeName type) {
        return (PrimitiveBuilder)new PrimitiveBuilder(PrimitiveType.class, type).repetition(Type.Repetition.REQUIRED);
    }

    public static PrimitiveBuilder<PrimitiveType> optional(PrimitiveType.PrimitiveTypeName type) {
        return (PrimitiveBuilder)new PrimitiveBuilder(PrimitiveType.class, type).repetition(Type.Repetition.OPTIONAL);
    }

    public static PrimitiveBuilder<PrimitiveType> repeated(PrimitiveType.PrimitiveTypeName type) {
        return (PrimitiveBuilder)new PrimitiveBuilder(PrimitiveType.class, type).repetition(Type.Repetition.REPEATED);
    }

    public static GroupBuilder<GroupType> buildGroup(Type.Repetition repetition) {
        return (GroupBuilder)new GroupBuilder(GroupType.class).repetition(repetition);
    }

    public static GroupBuilder<GroupType> requiredGroup() {
        return (GroupBuilder)new GroupBuilder(GroupType.class).repetition(Type.Repetition.REQUIRED);
    }

    public static GroupBuilder<GroupType> optionalGroup() {
        return (GroupBuilder)new GroupBuilder(GroupType.class).repetition(Type.Repetition.OPTIONAL);
    }

    public static GroupBuilder<GroupType> repeatedGroup() {
        return (GroupBuilder)new GroupBuilder(GroupType.class).repetition(Type.Repetition.REPEATED);
    }

    public static MapBuilder<GroupType> map(Type.Repetition repetition) {
        return (MapBuilder)new MapBuilder(GroupType.class).repetition(repetition);
    }

    public static MapBuilder<GroupType> requiredMap() {
        return Types.map(Type.Repetition.REQUIRED);
    }

    public static MapBuilder<GroupType> optionalMap() {
        return Types.map(Type.Repetition.OPTIONAL);
    }

    public static ListBuilder<GroupType> list(Type.Repetition repetition) {
        return (ListBuilder)new ListBuilder<GroupType>(GroupType.class).repetition(repetition);
    }

    public static ListBuilder<GroupType> requiredList() {
        return Types.list(Type.Repetition.REQUIRED);
    }

    public static ListBuilder<GroupType> optionalList() {
        return Types.list(Type.Repetition.OPTIONAL);
    }

    public static class MessageTypeBuilder
    extends GroupBuilder<MessageType> {
        private MessageTypeBuilder() {
            super(MessageType.class);
            this.repetition(Type.Repetition.REQUIRED);
        }

        @Override
        public MessageType named(String name) {
            Preconditions.checkNotNull(name, "Name is required");
            return new MessageType(name, this.fields);
        }
    }

    public static class ListBuilder<P>
    extends BaseListBuilder<P, ListBuilder<P>> {
        public ListBuilder(P parent) {
            super(parent);
        }

        public ListBuilder(Class<P> returnType) {
            super(returnType);
        }

        @Override
        protected ListBuilder<P> self() {
            return this;
        }
    }

    public static abstract class BaseListBuilder<P, THIS extends BaseListBuilder<P, THIS>>
    extends Builder<THIS, P> {
        private Type elementType = null;
        private P parent;

        public BaseListBuilder(P parent) {
            super(parent);
            this.parent = parent;
        }

        public BaseListBuilder(Class<P> returnType) {
            super(returnType);
        }

        public THIS setElementType(Type elementType) {
            Preconditions.checkState(this.elementType == null, "Only one element can be built with a ListBuilder");
            this.elementType = elementType;
            return (THIS)this.self();
        }

        @Override
        protected abstract THIS self();

        @Override
        protected Type build(String name) {
            Preconditions.checkState(this.originalType == null, "LIST is already the logical type and can't be changed");
            Preconditions.checkNotNull(this.elementType, "List element type");
            GroupBuilder builder = (GroupBuilder)Types.buildGroup(this.repetition).as(OriginalType.LIST);
            if (this.id != null) {
                builder.id(this.id.intValue());
            }
            return (Type)((GroupBuilder)((GroupBuilder)builder.repeatedGroup().addFields(this.elementType)).named("list")).named(name);
        }

        public ElementBuilder<P, THIS> element(PrimitiveType.PrimitiveTypeName type, Type.Repetition repetition) {
            return (ElementBuilder)new ElementBuilder(this.self(), type).repetition(repetition);
        }

        public ElementBuilder<P, THIS> requiredElement(PrimitiveType.PrimitiveTypeName type) {
            return this.element(type, Type.Repetition.REQUIRED);
        }

        public ElementBuilder<P, THIS> optionalElement(PrimitiveType.PrimitiveTypeName type) {
            return this.element(type, Type.Repetition.OPTIONAL);
        }

        public GroupElementBuilder<P, THIS> groupElement(Type.Repetition repetition) {
            return (GroupElementBuilder)new GroupElementBuilder(this.self()).repetition(repetition);
        }

        public GroupElementBuilder<P, THIS> requiredGroupElement() {
            return this.groupElement(Type.Repetition.REQUIRED);
        }

        public GroupElementBuilder<P, THIS> optionalGroupElement() {
            return this.groupElement(Type.Repetition.OPTIONAL);
        }

        public MapElementBuilder<P, THIS> mapElement(Type.Repetition repetition) {
            return (MapElementBuilder)new MapElementBuilder(this.self()).repetition(repetition);
        }

        public MapElementBuilder<P, THIS> requiredMapElement() {
            return this.mapElement(Type.Repetition.REQUIRED);
        }

        public MapElementBuilder<P, THIS> optionalMapElement() {
            return this.mapElement(Type.Repetition.OPTIONAL);
        }

        public ListElementBuilder<P, THIS> listElement(Type.Repetition repetition) {
            return (ListElementBuilder)new ListElementBuilder(this.self()).repetition(repetition);
        }

        public ListElementBuilder<P, THIS> requiredListElement() {
            return this.listElement(Type.Repetition.REQUIRED);
        }

        public ListElementBuilder<P, THIS> optionalListElement() {
            return this.listElement(Type.Repetition.OPTIONAL);
        }

        public BaseListBuilder<P, THIS> element(Type type) {
            this.setElementType(type);
            return this.self();
        }

        public static class ListElementBuilder<LP, L extends BaseListBuilder<LP, L>>
        extends BaseListBuilder<LP, ListElementBuilder<LP, L>> {
            private final L listBuilder;

            public ListElementBuilder(L listBuilder) {
                super(((BaseListBuilder)listBuilder).parent);
                this.listBuilder = listBuilder;
            }

            @Override
            protected ListElementBuilder<LP, L> self() {
                return this;
            }

            @Override
            public LP named(String name) {
                ((BaseListBuilder)this.listBuilder).setElementType(this.build("element"));
                return (LP)((Builder)this.listBuilder).named(name);
            }
        }

        public static class MapElementBuilder<LP, L extends BaseListBuilder<LP, L>>
        extends BaseMapBuilder<LP, MapElementBuilder<LP, L>> {
            private final L listBuilder;

            public MapElementBuilder(L listBuilder) {
                super(((BaseListBuilder)listBuilder).parent);
                this.listBuilder = listBuilder;
            }

            @Override
            protected MapElementBuilder<LP, L> self() {
                return this;
            }

            @Override
            public LP named(String name) {
                ((BaseListBuilder)this.listBuilder).setElementType(this.build("element"));
                return (LP)((Builder)this.listBuilder).named(name);
            }
        }

        public static class GroupElementBuilder<LP, L extends BaseListBuilder<LP, L>>
        extends BaseGroupBuilder<LP, GroupElementBuilder<LP, L>> {
            private final L listBuilder;

            public GroupElementBuilder(L listBuilder) {
                super(((BaseListBuilder)listBuilder).parent);
                this.listBuilder = listBuilder;
            }

            @Override
            public LP named(String name) {
                ((BaseListBuilder)this.listBuilder).setElementType(this.build("element"));
                return (LP)((Builder)this.listBuilder).named(name);
            }

            @Override
            protected GroupElementBuilder<LP, L> self() {
                return this;
            }
        }

        public static class ElementBuilder<LP, L extends BaseListBuilder<LP, L>>
        extends BasePrimitiveBuilder<LP, ElementBuilder<LP, L>> {
            private final BaseListBuilder<LP, L> listBuilder;

            public ElementBuilder(L listBuilder, PrimitiveType.PrimitiveTypeName type) {
                super(((BaseListBuilder)listBuilder).parent, type);
                this.listBuilder = listBuilder;
            }

            @Override
            public LP named(String name) {
                this.listBuilder.setElementType(this.build("element"));
                return (LP)this.listBuilder.named(name);
            }

            @Override
            protected ElementBuilder<LP, L> self() {
                return this;
            }
        }
    }

    public static class MapBuilder<P>
    extends BaseMapBuilder<P, MapBuilder<P>> {
        public MapBuilder(P parent) {
            super(parent);
        }

        private MapBuilder(Class<P> returnType) {
            super(returnType);
        }

        @Override
        protected MapBuilder<P> self() {
            return this;
        }
    }

    public static abstract class BaseMapBuilder<P, THIS extends BaseMapBuilder<P, THIS>>
    extends Builder<THIS, P> {
        private static final Type STRING_KEY = (Type)((PrimitiveBuilder)Types.required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("key");
        private Type keyType = null;
        private Type valueType = null;

        protected void setKeyType(Type keyType) {
            Preconditions.checkState(this.keyType == null, "Only one key type can be built with a MapBuilder");
            this.keyType = keyType;
        }

        protected void setValueType(Type valueType) {
            Preconditions.checkState(this.valueType == null, "Only one key type can be built with a ValueBuilder");
            this.valueType = valueType;
        }

        public BaseMapBuilder(P parent) {
            super(parent);
        }

        private BaseMapBuilder(Class<P> returnType) {
            super(returnType);
        }

        @Override
        protected abstract THIS self();

        public KeyBuilder<P, THIS> key(PrimitiveType.PrimitiveTypeName type) {
            return new KeyBuilder(this.self(), type);
        }

        public THIS key(Type type) {
            this.setKeyType(type);
            return (THIS)this.self();
        }

        public GroupKeyBuilder<P, THIS> groupKey() {
            return new GroupKeyBuilder(this.self());
        }

        public ValueBuilder<P, THIS> value(PrimitiveType.PrimitiveTypeName type, Type.Repetition repetition) {
            return (ValueBuilder)new ValueBuilder(this.self(), type).repetition(repetition);
        }

        public ValueBuilder<P, THIS> requiredValue(PrimitiveType.PrimitiveTypeName type) {
            return this.value(type, Type.Repetition.REQUIRED);
        }

        public ValueBuilder<P, THIS> optionalValue(PrimitiveType.PrimitiveTypeName type) {
            return this.value(type, Type.Repetition.OPTIONAL);
        }

        public GroupValueBuilder<P, THIS> groupValue(Type.Repetition repetition) {
            return (GroupValueBuilder)new GroupValueBuilder(this.self()).repetition(repetition);
        }

        public GroupValueBuilder<P, THIS> requiredGroupValue() {
            return this.groupValue(Type.Repetition.REQUIRED);
        }

        public GroupValueBuilder<P, THIS> optionalGroupValue() {
            return this.groupValue(Type.Repetition.OPTIONAL);
        }

        public MapValueBuilder<P, THIS> mapValue(Type.Repetition repetition) {
            return (MapValueBuilder)new MapValueBuilder(this.self()).repetition(repetition);
        }

        public MapValueBuilder<P, THIS> requiredMapValue() {
            return this.mapValue(Type.Repetition.REQUIRED);
        }

        public MapValueBuilder<P, THIS> optionalMapValue() {
            return this.mapValue(Type.Repetition.OPTIONAL);
        }

        public ListValueBuilder<P, THIS> listValue(Type.Repetition repetition) {
            return (ListValueBuilder)new ListValueBuilder(this.self()).repetition(repetition);
        }

        public ListValueBuilder<P, THIS> requiredListValue() {
            return this.listValue(Type.Repetition.REQUIRED);
        }

        public ListValueBuilder<P, THIS> optionalListValue() {
            return this.listValue(Type.Repetition.OPTIONAL);
        }

        public THIS value(Type type) {
            this.setValueType(type);
            return (THIS)this.self();
        }

        @Override
        protected Type build(String name) {
            Preconditions.checkState(this.originalType == null, "MAP is already a logical type and can't be changed.");
            if (this.keyType == null) {
                this.keyType = STRING_KEY;
            }
            GroupBuilder builder = (GroupBuilder)Types.buildGroup(this.repetition).as(OriginalType.MAP);
            if (this.id != null) {
                builder.id(this.id.intValue());
            }
            if (this.valueType != null) {
                return (Type)((GroupBuilder)((GroupBuilder)builder.repeatedGroup().addFields(this.keyType, this.valueType)).named("map")).named(name);
            }
            return (Type)((GroupBuilder)((GroupBuilder)builder.repeatedGroup().addFields(this.keyType)).named("map")).named(name);
        }

        public static class ListValueBuilder<MP, M extends BaseMapBuilder<MP, M>>
        extends BaseListBuilder<MP, ListValueBuilder<MP, M>> {
            private final M mapBuilder;

            public ListValueBuilder(M mapBuilder) {
                super(((BaseMapBuilder)mapBuilder).parent);
                this.mapBuilder = mapBuilder;
            }

            @Override
            public MP named(String name) {
                ((BaseMapBuilder)this.mapBuilder).setValueType(this.build("value"));
                return (MP)((Builder)this.mapBuilder).named(name);
            }

            @Override
            protected ListValueBuilder<MP, M> self() {
                return this;
            }
        }

        public static class MapValueBuilder<MP, M extends BaseMapBuilder<MP, M>>
        extends BaseMapBuilder<MP, MapValueBuilder<MP, M>> {
            private final M mapBuilder;

            public MapValueBuilder(M mapBuilder) {
                super(((BaseMapBuilder)mapBuilder).parent);
                this.mapBuilder = mapBuilder;
            }

            @Override
            public MP named(String name) {
                ((BaseMapBuilder)this.mapBuilder).setValueType(this.build("value"));
                return (MP)((Builder)this.mapBuilder).named(name);
            }

            @Override
            protected MapValueBuilder<MP, M> self() {
                return this;
            }
        }

        public static class GroupValueBuilder<MP, M extends BaseMapBuilder<MP, M>>
        extends BaseGroupBuilder<MP, GroupValueBuilder<MP, M>> {
            private final M mapBuilder;

            public GroupValueBuilder(M mapBuilder) {
                super(((BaseMapBuilder)mapBuilder).parent);
                this.mapBuilder = mapBuilder;
            }

            @Override
            public MP named(String name) {
                ((BaseMapBuilder)this.mapBuilder).setValueType(this.build("value"));
                return (MP)((Builder)this.mapBuilder).named(name);
            }

            @Override
            protected GroupValueBuilder<MP, M> self() {
                return this;
            }
        }

        public static class GroupKeyBuilder<MP, M extends BaseMapBuilder<MP, M>>
        extends BaseGroupBuilder<MP, GroupKeyBuilder<MP, M>> {
            private final M mapBuilder;

            public GroupKeyBuilder(M mapBuilder) {
                super(((BaseMapBuilder)mapBuilder).parent);
                this.mapBuilder = mapBuilder;
                this.repetition(Type.Repetition.REQUIRED);
            }

            @Override
            protected GroupKeyBuilder<MP, M> self() {
                return this;
            }

            public ValueBuilder<MP, M> value(PrimitiveType.PrimitiveTypeName type, Type.Repetition repetition) {
                ((BaseMapBuilder)this.mapBuilder).setKeyType(this.build("key"));
                return (ValueBuilder)new ValueBuilder(this.mapBuilder, type).repetition(repetition);
            }

            public ValueBuilder<MP, M> requiredValue(PrimitiveType.PrimitiveTypeName type) {
                return this.value(type, Type.Repetition.REQUIRED);
            }

            public ValueBuilder<MP, M> optionalValue(PrimitiveType.PrimitiveTypeName type) {
                return this.value(type, Type.Repetition.OPTIONAL);
            }

            public GroupValueBuilder<MP, M> groupValue(Type.Repetition repetition) {
                ((BaseMapBuilder)this.mapBuilder).setKeyType(this.build("key"));
                return (GroupValueBuilder)new GroupValueBuilder(this.mapBuilder).repetition(repetition);
            }

            public GroupValueBuilder<MP, M> requiredGroupValue() {
                return this.groupValue(Type.Repetition.REQUIRED);
            }

            public GroupValueBuilder<MP, M> optionalGroupValue() {
                return this.groupValue(Type.Repetition.OPTIONAL);
            }

            public MapValueBuilder<MP, M> mapValue(Type.Repetition repetition) {
                ((BaseMapBuilder)this.mapBuilder).setKeyType(this.build("key"));
                return (MapValueBuilder)new MapValueBuilder(this.mapBuilder).repetition(repetition);
            }

            public MapValueBuilder<MP, M> requiredMapValue() {
                return this.mapValue(Type.Repetition.REQUIRED);
            }

            public MapValueBuilder<MP, M> optionalMapValue() {
                return this.mapValue(Type.Repetition.OPTIONAL);
            }

            public ListValueBuilder<MP, M> listValue(Type.Repetition repetition) {
                ((BaseMapBuilder)this.mapBuilder).setKeyType(this.build("key"));
                return (ListValueBuilder)new ListValueBuilder(this.mapBuilder).repetition(repetition);
            }

            public ListValueBuilder<MP, M> requiredListValue() {
                return this.listValue(Type.Repetition.REQUIRED);
            }

            public ListValueBuilder<MP, M> optionalListValue() {
                return this.listValue(Type.Repetition.OPTIONAL);
            }

            public M value(Type type) {
                ((BaseMapBuilder)this.mapBuilder).setKeyType(this.build("key"));
                ((BaseMapBuilder)this.mapBuilder).setValueType(type);
                return this.mapBuilder;
            }

            @Override
            public MP named(String name) {
                ((BaseMapBuilder)this.mapBuilder).setKeyType(this.build("key"));
                return (MP)((Builder)this.mapBuilder).named(name);
            }
        }

        public static class ValueBuilder<MP, M extends BaseMapBuilder<MP, M>>
        extends BasePrimitiveBuilder<MP, ValueBuilder<MP, M>> {
            private final M mapBuilder;

            public ValueBuilder(M mapBuilder, PrimitiveType.PrimitiveTypeName type) {
                super(((BaseMapBuilder)mapBuilder).parent, type);
                this.mapBuilder = mapBuilder;
            }

            @Override
            public MP named(String name) {
                ((BaseMapBuilder)this.mapBuilder).setValueType(this.build("value"));
                return (MP)((Builder)this.mapBuilder).named(name);
            }

            @Override
            protected ValueBuilder<MP, M> self() {
                return this;
            }
        }

        public static class KeyBuilder<MP, M extends BaseMapBuilder<MP, M>>
        extends BasePrimitiveBuilder<MP, KeyBuilder<MP, M>> {
            private final M mapBuilder;

            public KeyBuilder(M mapBuilder, PrimitiveType.PrimitiveTypeName type) {
                super(((BaseMapBuilder)mapBuilder).parent, type);
                this.mapBuilder = mapBuilder;
                this.repetition(Type.Repetition.REQUIRED);
            }

            public ValueBuilder<MP, M> value(PrimitiveType.PrimitiveTypeName type, Type.Repetition repetition) {
                ((BaseMapBuilder)this.mapBuilder).setKeyType(this.build("key"));
                return (ValueBuilder)new ValueBuilder(this.mapBuilder, type).repetition(repetition);
            }

            public ValueBuilder<MP, M> requiredValue(PrimitiveType.PrimitiveTypeName type) {
                return this.value(type, Type.Repetition.REQUIRED);
            }

            public ValueBuilder<MP, M> optionalValue(PrimitiveType.PrimitiveTypeName type) {
                return this.value(type, Type.Repetition.OPTIONAL);
            }

            public GroupValueBuilder<MP, M> groupValue(Type.Repetition repetition) {
                ((BaseMapBuilder)this.mapBuilder).setKeyType(this.build("key"));
                return (GroupValueBuilder)new GroupValueBuilder(this.mapBuilder).repetition(repetition);
            }

            public GroupValueBuilder<MP, M> requiredGroupValue() {
                return this.groupValue(Type.Repetition.REQUIRED);
            }

            public GroupValueBuilder<MP, M> optionalGroupValue() {
                return this.groupValue(Type.Repetition.OPTIONAL);
            }

            public MapValueBuilder<MP, M> mapValue(Type.Repetition repetition) {
                ((BaseMapBuilder)this.mapBuilder).setKeyType(this.build("key"));
                return (MapValueBuilder)new MapValueBuilder(this.mapBuilder).repetition(repetition);
            }

            public MapValueBuilder<MP, M> requiredMapValue() {
                return this.mapValue(Type.Repetition.REQUIRED);
            }

            public MapValueBuilder<MP, M> optionalMapValue() {
                return this.mapValue(Type.Repetition.OPTIONAL);
            }

            public ListValueBuilder<MP, M> listValue(Type.Repetition repetition) {
                ((BaseMapBuilder)this.mapBuilder).setKeyType(this.build("key"));
                return (ListValueBuilder)new ListValueBuilder(this.mapBuilder).repetition(repetition);
            }

            public ListValueBuilder<MP, M> requiredListValue() {
                return this.listValue(Type.Repetition.REQUIRED);
            }

            public ListValueBuilder<MP, M> optionalListValue() {
                return this.listValue(Type.Repetition.OPTIONAL);
            }

            public M value(Type type) {
                ((BaseMapBuilder)this.mapBuilder).setKeyType(this.build("key"));
                ((BaseMapBuilder)this.mapBuilder).setValueType(type);
                return this.mapBuilder;
            }

            @Override
            public MP named(String name) {
                ((BaseMapBuilder)this.mapBuilder).setKeyType(this.build("key"));
                return (MP)((Builder)this.mapBuilder).named(name);
            }

            @Override
            protected KeyBuilder<MP, M> self() {
                return this;
            }
        }
    }

    public static class GroupBuilder<P>
    extends BaseGroupBuilder<P, GroupBuilder<P>> {
        private GroupBuilder(P parent) {
            super(parent);
        }

        private GroupBuilder(Class<P> returnType) {
            super(returnType);
        }

        @Override
        protected GroupBuilder<P> self() {
            return this;
        }
    }

    public static abstract class BaseGroupBuilder<P, THIS extends BaseGroupBuilder<P, THIS>>
    extends Builder<THIS, P> {
        protected final List<Type> fields = new ArrayList<Type>();

        private BaseGroupBuilder(P parent) {
            super(parent);
        }

        private BaseGroupBuilder(Class<P> returnType) {
            super(returnType);
        }

        @Override
        protected abstract THIS self();

        public PrimitiveBuilder<THIS> primitive(PrimitiveType.PrimitiveTypeName type, Type.Repetition repetition) {
            return (PrimitiveBuilder)new PrimitiveBuilder(this.self(), type).repetition(repetition);
        }

        public PrimitiveBuilder<THIS> required(PrimitiveType.PrimitiveTypeName type) {
            return (PrimitiveBuilder)new PrimitiveBuilder(this.self(), type).repetition(Type.Repetition.REQUIRED);
        }

        public PrimitiveBuilder<THIS> optional(PrimitiveType.PrimitiveTypeName type) {
            return (PrimitiveBuilder)new PrimitiveBuilder(this.self(), type).repetition(Type.Repetition.OPTIONAL);
        }

        public PrimitiveBuilder<THIS> repeated(PrimitiveType.PrimitiveTypeName type) {
            return (PrimitiveBuilder)new PrimitiveBuilder(this.self(), type).repetition(Type.Repetition.REPEATED);
        }

        public GroupBuilder<THIS> group(Type.Repetition repetition) {
            return (GroupBuilder)new GroupBuilder(this.self()).repetition(repetition);
        }

        public GroupBuilder<THIS> requiredGroup() {
            return (GroupBuilder)new GroupBuilder(this.self()).repetition(Type.Repetition.REQUIRED);
        }

        public GroupBuilder<THIS> optionalGroup() {
            return (GroupBuilder)new GroupBuilder(this.self()).repetition(Type.Repetition.OPTIONAL);
        }

        public GroupBuilder<THIS> repeatedGroup() {
            return (GroupBuilder)new GroupBuilder(this.self()).repetition(Type.Repetition.REPEATED);
        }

        public THIS addField(Type type) {
            this.fields.add(type);
            return (THIS)this.self();
        }

        public THIS addFields(Type ... types) {
            Collections.addAll(this.fields, types);
            return (THIS)this.self();
        }

        @Override
        protected GroupType build(String name) {
            return new GroupType(this.repetition, name, this.originalType, this.fields, this.id);
        }

        public MapBuilder<THIS> map(Type.Repetition repetition) {
            return (MapBuilder)new MapBuilder<Builder>(this.self()).repetition(repetition);
        }

        public MapBuilder<THIS> requiredMap() {
            return (MapBuilder)new MapBuilder<Builder>(this.self()).repetition(Type.Repetition.REQUIRED);
        }

        public MapBuilder<THIS> optionalMap() {
            return (MapBuilder)new MapBuilder<Builder>(this.self()).repetition(Type.Repetition.OPTIONAL);
        }

        public ListBuilder<THIS> list(Type.Repetition repetition) {
            return (ListBuilder)new ListBuilder<Builder>(this.self()).repetition(repetition);
        }

        public ListBuilder<THIS> requiredList() {
            return this.list(Type.Repetition.REQUIRED);
        }

        public ListBuilder<THIS> optionalList() {
            return this.list(Type.Repetition.OPTIONAL);
        }
    }

    public static class PrimitiveBuilder<P>
    extends BasePrimitiveBuilder<P, PrimitiveBuilder<P>> {
        private PrimitiveBuilder(P parent, PrimitiveType.PrimitiveTypeName type) {
            super(parent, type);
        }

        private PrimitiveBuilder(Class<P> returnType, PrimitiveType.PrimitiveTypeName type) {
            super(returnType, type);
        }

        @Override
        protected PrimitiveBuilder<P> self() {
            return this;
        }
    }

    public static abstract class BasePrimitiveBuilder<P, THIS extends BasePrimitiveBuilder<P, THIS>>
    extends Builder<THIS, P> {
        private static final Logger LOGGER = LoggerFactory.getLogger(BasePrimitiveBuilder.class);
        private static final long MAX_PRECISION_INT32 = BasePrimitiveBuilder.maxPrecision(4);
        private static final long MAX_PRECISION_INT64 = BasePrimitiveBuilder.maxPrecision(8);
        private static final String LOGICAL_TYPES_DOC_URL = "https://github.com/apache/parquet-format/blob/master/LogicalTypes.md";
        private final PrimitiveType.PrimitiveTypeName primitiveType;
        private int length = 0;
        private int precision = 0;
        private int scale = 0;
        private ColumnOrder columnOrder;

        private BasePrimitiveBuilder(P parent, PrimitiveType.PrimitiveTypeName type) {
            super(parent);
            this.primitiveType = type;
        }

        private BasePrimitiveBuilder(Class<P> returnType, PrimitiveType.PrimitiveTypeName type) {
            super(returnType);
            this.primitiveType = type;
        }

        @Override
        protected abstract THIS self();

        public THIS length(int length) {
            this.length = length;
            return (THIS)this.self();
        }

        public THIS precision(int precision) {
            this.precision = precision;
            return (THIS)this.self();
        }

        public THIS scale(int scale) {
            this.scale = scale;
            return (THIS)this.self();
        }

        public THIS columnOrder(ColumnOrder columnOrder) {
            this.columnOrder = columnOrder;
            return (THIS)this.self();
        }

        @Override
        protected PrimitiveType build(String name) {
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY == this.primitiveType) {
                Preconditions.checkArgument(this.length > 0, "Invalid FIXED_LEN_BYTE_ARRAY length: " + this.length);
            }
            DecimalMetadata meta = this.decimalMetadata();
            if (this.originalType != null) {
                switch (this.originalType) {
                    case UTF8: 
                    case JSON: 
                    case BSON: {
                        Preconditions.checkState(this.primitiveType == PrimitiveType.PrimitiveTypeName.BINARY, this.originalType.toString() + " can only annotate binary fields");
                        break;
                    }
                    case DECIMAL: {
                        Preconditions.checkState(this.primitiveType == PrimitiveType.PrimitiveTypeName.INT32 || this.primitiveType == PrimitiveType.PrimitiveTypeName.INT64 || this.primitiveType == PrimitiveType.PrimitiveTypeName.BINARY || this.primitiveType == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, "DECIMAL can only annotate INT32, INT64, BINARY, and FIXED");
                        if (this.primitiveType == PrimitiveType.PrimitiveTypeName.INT32) {
                            Preconditions.checkState((long)meta.getPrecision() <= MAX_PRECISION_INT32, "INT32 cannot store " + meta.getPrecision() + " digits (max " + MAX_PRECISION_INT32 + ")");
                            break;
                        }
                        if (this.primitiveType == PrimitiveType.PrimitiveTypeName.INT64) {
                            Preconditions.checkState((long)meta.getPrecision() <= MAX_PRECISION_INT64, "INT64 cannot store " + meta.getPrecision() + " digits (max " + MAX_PRECISION_INT64 + ")");
                            if ((long)meta.getPrecision() > MAX_PRECISION_INT32) break;
                            LOGGER.warn("Decimal with {} digits is stored in an INT64, but fits in an INT32. See {}.", (Object)this.precision, (Object)LOGICAL_TYPES_DOC_URL);
                            break;
                        }
                        if (this.primitiveType != PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) break;
                        Preconditions.checkState((long)meta.getPrecision() <= BasePrimitiveBuilder.maxPrecision(this.length), "FIXED(" + this.length + ") cannot store " + meta.getPrecision() + " digits (max " + BasePrimitiveBuilder.maxPrecision(this.length) + ")");
                        break;
                    }
                    case DATE: 
                    case TIME_MILLIS: 
                    case UINT_8: 
                    case UINT_16: 
                    case UINT_32: 
                    case INT_8: 
                    case INT_16: 
                    case INT_32: {
                        Preconditions.checkState(this.primitiveType == PrimitiveType.PrimitiveTypeName.INT32, this.originalType.toString() + " can only annotate INT32");
                        break;
                    }
                    case TIME_MICROS: 
                    case TIMESTAMP_MILLIS: 
                    case TIMESTAMP_MICROS: 
                    case UINT_64: 
                    case INT_64: {
                        Preconditions.checkState(this.primitiveType == PrimitiveType.PrimitiveTypeName.INT64, this.originalType.toString() + " can only annotate INT64");
                        break;
                    }
                    case INTERVAL: {
                        Preconditions.checkState(this.primitiveType == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY && this.length == 12, "INTERVAL can only annotate FIXED_LEN_BYTE_ARRAY(12)");
                        break;
                    }
                    case ENUM: {
                        Preconditions.checkState(this.primitiveType == PrimitiveType.PrimitiveTypeName.BINARY, "ENUM can only annotate binary fields");
                        break;
                    }
                    default: {
                        throw new IllegalStateException((Object)((Object)this.originalType) + " can not be applied to a primitive type");
                    }
                }
            }
            return new PrimitiveType(this.repetition, this.primitiveType, this.length, name, this.originalType, meta, this.id, this.columnOrder);
        }

        private static long maxPrecision(int numBytes) {
            return Math.round(Math.floor(Math.log10(Math.pow(2.0, 8 * numBytes - 1) - 1.0)));
        }

        protected DecimalMetadata decimalMetadata() {
            DecimalMetadata meta = null;
            if (OriginalType.DECIMAL == this.originalType) {
                Preconditions.checkArgument(this.precision > 0, "Invalid DECIMAL precision: " + this.precision);
                Preconditions.checkArgument(this.scale >= 0, "Invalid DECIMAL scale: " + this.scale);
                Preconditions.checkArgument(this.scale <= this.precision, "Invalid DECIMAL scale: cannot be greater than precision");
                meta = new DecimalMetadata(this.precision, this.scale);
            }
            return meta;
        }
    }

    public static abstract class Builder<THIS extends Builder, P> {
        protected final P parent;
        protected final Class<? extends P> returnClass;
        protected Type.Repetition repetition = null;
        protected OriginalType originalType = null;
        protected Type.ID id = null;
        private boolean repetitionAlreadySet = false;

        protected Builder(P parent) {
            this.parent = parent;
            this.returnClass = null;
        }

        protected Builder(Class<P> returnClass) {
            Preconditions.checkArgument(Type.class.isAssignableFrom(returnClass), "The requested return class must extend Type");
            this.returnClass = returnClass;
            this.parent = null;
        }

        protected abstract THIS self();

        protected final THIS repetition(Type.Repetition repetition) {
            Preconditions.checkArgument(!this.repetitionAlreadySet, "Repetition has already been set");
            Preconditions.checkNotNull(repetition, "Repetition cannot be null");
            this.repetition = repetition;
            this.repetitionAlreadySet = true;
            return this.self();
        }

        public THIS as(OriginalType type) {
            this.originalType = type;
            return this.self();
        }

        public THIS id(int id) {
            this.id = new Type.ID(id);
            return this.self();
        }

        protected abstract Type build(String var1);

        public P named(String name) {
            Preconditions.checkNotNull(name, "Name is required");
            Preconditions.checkNotNull(this.repetition, "Repetition is required");
            Type type = this.build(name);
            if (this.parent != null) {
                if (BaseGroupBuilder.class.isAssignableFrom(this.parent.getClass())) {
                    ((BaseGroupBuilder)BaseGroupBuilder.class.cast(this.parent)).addField(type);
                }
                return this.parent;
            }
            if (this.returnClass != null) {
                return this.returnClass.cast(type);
            }
            throw new IllegalStateException("[BUG] Parent and return type are null: must override named");
        }
    }
}

