/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.parquet.filter2.recordlevel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.shaded.apache.parquet.Preconditions;
import org.shaded.apache.parquet.filter2.recordlevel.FilteringPrimitiveConverter;
import org.shaded.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate;
import org.shaded.apache.parquet.hadoop.metadata.ColumnPath;
import org.shaded.apache.parquet.io.PrimitiveColumnIO;
import org.shaded.apache.parquet.io.api.Converter;
import org.shaded.apache.parquet.io.api.GroupConverter;

public class FilteringGroupConverter
extends GroupConverter {
    private final GroupConverter delegate;
    private final List<Integer> indexFieldPath;
    private final Map<ColumnPath, List<IncrementallyUpdatedFilterPredicate.ValueInspector>> valueInspectorsByColumn;
    private final Map<List<Integer>, PrimitiveColumnIO> columnIOsByIndexFieldPath;

    public FilteringGroupConverter(GroupConverter delegate, List<Integer> indexFieldPath, Map<ColumnPath, List<IncrementallyUpdatedFilterPredicate.ValueInspector>> valueInspectorsByColumn, Map<List<Integer>, PrimitiveColumnIO> columnIOsByIndexFieldPath) {
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        this.indexFieldPath = Preconditions.checkNotNull(indexFieldPath, "indexFieldPath");
        this.columnIOsByIndexFieldPath = Preconditions.checkNotNull(columnIOsByIndexFieldPath, "columnIOsByIndexFieldPath");
        this.valueInspectorsByColumn = Preconditions.checkNotNull(valueInspectorsByColumn, "valueInspectorsByColumn");
    }

    @Override
    public Converter getConverter(int fieldIndex) {
        Converter delegateConverter = Preconditions.checkNotNull(this.delegate.getConverter(fieldIndex), "delegate converter");
        ArrayList<Integer> newIndexFieldPath = new ArrayList<Integer>(this.indexFieldPath.size() + 1);
        newIndexFieldPath.addAll(this.indexFieldPath);
        newIndexFieldPath.add(fieldIndex);
        if (delegateConverter.isPrimitive()) {
            PrimitiveColumnIO columnIO = this.getColumnIO(newIndexFieldPath);
            ColumnPath columnPath = ColumnPath.get(columnIO.getColumnDescriptor().getPath());
            IncrementallyUpdatedFilterPredicate.ValueInspector[] valueInspectors = this.getValueInspectors(columnPath);
            return new FilteringPrimitiveConverter(delegateConverter.asPrimitiveConverter(), valueInspectors);
        }
        return new FilteringGroupConverter(delegateConverter.asGroupConverter(), newIndexFieldPath, this.valueInspectorsByColumn, this.columnIOsByIndexFieldPath);
    }

    private PrimitiveColumnIO getColumnIO(List<Integer> indexFieldPath) {
        PrimitiveColumnIO found = this.columnIOsByIndexFieldPath.get(indexFieldPath);
        Preconditions.checkArgument(found != null, "Did not find PrimitiveColumnIO for index field path" + indexFieldPath);
        return found;
    }

    private IncrementallyUpdatedFilterPredicate.ValueInspector[] getValueInspectors(ColumnPath columnPath) {
        List<IncrementallyUpdatedFilterPredicate.ValueInspector> inspectorsList = this.valueInspectorsByColumn.get(columnPath);
        if (inspectorsList == null) {
            return new IncrementallyUpdatedFilterPredicate.ValueInspector[0];
        }
        return inspectorsList.toArray(new IncrementallyUpdatedFilterPredicate.ValueInspector[inspectorsList.size()]);
    }

    @Override
    public void start() {
        this.delegate.start();
    }

    @Override
    public void end() {
        this.delegate.end();
    }
}

