/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.orc.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.shaded.apache.orc.EncryptionAlgorithm;

public interface HadoopShims {
    public DirectDecompressor getDirectDecompressor(DirectCompressionType var1);

    public ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream var1, ByteBufferPoolShim var2) throws IOException;

    public boolean endVariableLengthBlock(OutputStream var1) throws IOException;

    public KeyProvider getKeyProvider(Configuration var1, Random var2) throws IOException;

    public static class KeyMetadata {
        private final String keyName;
        private final int version;
        private final EncryptionAlgorithm algorithm;

        public KeyMetadata(String key, int version, EncryptionAlgorithm algorithm) {
            this.keyName = key;
            this.version = version;
            this.algorithm = algorithm;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public EncryptionAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        public int getVersion() {
            return this.version;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.keyName);
            buffer.append('@');
            buffer.append(this.version);
            buffer.append('-');
            buffer.append((Object)this.algorithm);
            return buffer.toString();
        }
    }

    public static class LocalKey {
        public final Key decryptedKey;
        public final byte[] encryptedKey;

        public LocalKey(Key decryptedKey, byte[] encryptedKey) {
            this.decryptedKey = decryptedKey;
            this.encryptedKey = encryptedKey;
        }
    }

    public static interface KeyProvider {
        public List<String> getKeyNames() throws IOException;

        public KeyMetadata getCurrentKeyVersion(String var1) throws IOException;

        public LocalKey createLocalKey(KeyMetadata var1) throws IOException;

        public Key decryptLocalKey(KeyMetadata var1, byte[] var2) throws IOException;
    }

    public static interface ZeroCopyReaderShim
    extends Closeable {
        public ByteBuffer readBuffer(int var1, boolean var2) throws IOException;

        public void releaseBuffer(ByteBuffer var1);

        @Override
        public void close() throws IOException;
    }

    public static interface ByteBufferPoolShim {
        public ByteBuffer getBuffer(boolean var1, int var2);

        public void putBuffer(ByteBuffer var1);
    }

    public static interface DirectDecompressor {
        public void decompress(ByteBuffer var1, ByteBuffer var2) throws IOException;

        public void reset();

        public void end();
    }

    public static enum DirectCompressionType {
        NONE,
        ZLIB_NOHEADER,
        ZLIB,
        SNAPPY;

    }
}

