/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.net.URL;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskFailedListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001%\u0011qc\u00159be.\u0004\u0016M]1mY\u0016d\u0017n]7Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011!B:qCJ\\'BA\u0003\u0007\u0003\u0019\t\u0007/Y2iK*\tq!A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aD\u0001\"\u0005\u0001\u0003\u0006\u0004%\tAE\u0001\u0003g\u000e,\u0012a\u0005\t\u0003)Ui\u0011AA\u0005\u0003-\t\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IaE\u0001\u0004g\u000e\u0004\u0003\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u000fQLW.Z8viB\u00111\u0002H\u0005\u0003;1\u0011A\u0001T8oO\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0006ok6<vN]6feN\u0004\"aC\u0011\n\u0005\tb!aA%oi\")A\u0005\u0001C\u0001K\u00051A(\u001b8jiz\"BAJ\u0014)SA\u0011A\u0003\u0001\u0005\u0006#\r\u0002\ra\u0005\u0005\u00065\r\u0002\ra\u0007\u0005\u0006?\r\u0002\r\u0001\t\u0005\u0007W\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u001dI,\u0017/^3ti\u0016$7i\u001c:fg\"1Q\u0006\u0001Q\u0001\n9\na!\\1qa\u0016\u0014\bCA\u00187\u001b\u0005\u0001$BA\u00193\u0003\ri\u0017\r\u001d\u0006\u0003gQ\nqA[1dWN|gN\u0003\u00026\r\u0005A1m\u001c3fQ\u0006,8/\u0003\u00028a\taqJ\u00196fGRl\u0015\r\u001d9fe\"1\u0011\b\u0001Q\u0001\ni\na\u0001\\8hO\u0016\u0014\bCA\u001eA\u001b\u0005a$BA\u001f?\u0003\u001dawnZ4j]\u001eT!a\u0010\u0003\u0002\u000f\r|W.\\8og&\u0011\u0011\t\u0010\u0002\u0004\u0019><\u0007BB\"\u0001A\u0003%A)A\u0002ve2\u0004\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\u00079,GOC\u0001J\u0003\u0011Q\u0017M^1\n\u0005-3%aA+S\u0019\"1Q\n\u0001Q\u0005\n9\u000bQB\\;n\u00032Lg/Z\"pe\u0016\u001cX#\u0001\u0011\t\rA\u0003\u0001\u0015\"\u0003O\u0003=qW/\\!mSZ,wk\u001c:lKJ\u001c\bB\u0002*\u0001A\u0013%1+\u0001\txC&$hi\u001c:D_:$\u0017\u000e^5p]R!A+X3g!\r)\u0006LW\u0007\u0002-*\u0011q\u000bD\u0001\u000bG>t7-\u001e:sK:$\u0018BA-W\u0005\u00191U\u000f^;sKB\u00111bW\u0005\u000392\u0011A!\u00168ji\"1a,\u0015CA\u0002}\u000b\u0011bY8oI&$\u0018n\u001c8\u0011\u0007-\u0001'-\u0003\u0002b\u0019\tAAHY=oC6,g\b\u0005\u0002\fG&\u0011A\r\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015Q\u0012\u000b1\u0001\u001c\u0011\u001d9\u0017\u000b%AA\u0002m\tQb\u00195fG.Le\u000e^3sm\u0006d\u0007BB5\u0001A\u0013%!.A\u0006tC\u001a,W\t_3dkR,WCA6o)\taw\u000f\u0005\u0002n]2\u0001A!B8i\u0005\u0004\u0001(!\u0001+\u0012\u0005E$\bCA\u0006s\u0013\t\u0019HBA\u0004O_RD\u0017N\\4\u0011\u0005-)\u0018B\u0001<\r\u0005\r\te.\u001f\u0005\u0007q\"$\t\u0019A=\u0002\t\t|G-\u001f\t\u0004\u0017\u0001d\u0007\"B>\u0001\t\u0003a\u0018aB3yK\u000e,H/Z\u000b\u0003{~$2A`A\u0001!\tiw\u0010B\u0003pu\n\u0007\u0001\u000fC\u0004yu\u0012\u0005\r!a\u0001\u0011\u0007-\u0001g\u0010C\u0004\u0002\b\u0001!\t!!\u0003\u0002%\u0015DXmY;uK\"{gn\u001c:G_J<\u0005/^\u000b\u0005\u0003\u0017\ty\u0001\u0006\u0003\u0002\u000e\u0005E\u0001cA7\u0002\u0010\u00111q.!\u0002C\u0002AD\u0001\u0002_A\u0003\t\u0003\u0007\u00111\u0003\t\u0005\u0017\u0001\fi\u0001C\u0005\u0002\u0018\u0001\t\n\u0011\"\u0003\u0002\u001a\u0005Qr/Y5u\r>\u00148i\u001c8eSRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0004\u0016\u00047\u0005u1FAA\u0010!\u0011\t\t#a\u000b\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%B\"\u0001\u0006b]:|G/\u0019;j_:LA!!\f\u0002$\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class SparkParallelismTracker {
    private final SparkContext sc;
    private final long timeout;
    public final int org$apache$spark$SparkParallelismTracker$$numWorkers;
    public final int org$apache$spark$SparkParallelismTracker$$requestedCores;
    private final ObjectMapper mapper;
    private final Log logger;
    private final URL url;

    public SparkContext sc() {
        return this.sc;
    }

    public int org$apache$spark$SparkParallelismTracker$$numAliveCores() {
        int n;
        try {
            n = this.url == null ? Integer.MAX_VALUE : BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.mapper.readTree(this.url).findValues("totalCores")).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(JsonNode x$1) {
                    return x$1.asInt();
                }
            }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        catch (Throwable throwable) {
            this.logger.warn((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to read total number of alive cores from REST API."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Health Check will be ignored."})).s((Seq)Nil$.MODULE$)).toString());
            throwable.printStackTrace();
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    public int org$apache$spark$SparkParallelismTracker$$numAliveWorkers() {
        int n;
        try {
            if (this.url == null) {
                n = Integer.MAX_VALUE;
            } else {
                Option option;
                Option option2;
                Regex LOCAL_N_REGEX = new StringOps(Predef$.MODULE$.augmentString("local\\[([0-9]+|\\*)\\]")).r();
                Regex LOCAL_N_FAILURES_REGEX = new StringOps(Predef$.MODULE$.augmentString("local\\[([0-9]+|\\*)\\s*,\\s*([0-9]+)\\]")).r();
                String string = this.sc().master();
                boolean bl = "local".equals(string) ? true : (!(option2 = LOCAL_N_REGEX.unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0 ? true : !(option = LOCAL_N_FAILURES_REGEX.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0);
                int n2 = bl ? ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.mapper.readTree(this.url).findValues("id")).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(JsonNode x$2) {
                        return x$2.asText();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).size() : ((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.mapper.readTree(this.url).findValues("id")).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(JsonNode x$3) {
                        return x$3.asText();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$4) {
                        String string = x$4;
                        String string2 = "driver";
                        return string != null ? !string.equals(string2) : string2 != null;
                    }
                })).size();
                n = n2;
            }
        }
        catch (Throwable throwable) {
            this.logger.warn((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to read total number of alive worker from REST API."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Health Check will be ignored."})).s((Seq)Nil$.MODULE$)).toString());
            throwable.printStackTrace();
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    private Future<BoxedUnit> waitForCondition(Function0<Object> condition, long timeout, long checkInterval) {
        Future monitor = Future$.MODULE$.apply((Function0)new Serializable(this, condition, checkInterval){
            public static final long serialVersionUID = 0L;
            private final Function0 condition$1;
            private final long checkInterval$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (!this.condition$1.apply$mcZ$sp()) {
                    Thread.sleep(this.checkInterval$1);
                }
                return;
            }
            {
                this.condition$1 = condition$1;
                this.checkInterval$1 = checkInterval$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        return (Future)Await$.MODULE$.ready((Awaitable)monitor, (Duration)new package.DurationLong(package$.MODULE$.DurationLong(timeout)).millis());
    }

    private long waitForCondition$default$3() {
        return 100L;
    }

    /*
     * WARNING - void declaration
     */
    private <T> T safeExecute(Function0<T> body) {
        Object object;
        TaskFailedListener listener = new TaskFailedListener();
        this.sc().addSparkListener((SparkListenerInterface)listener);
        try {
            object = body.apply();
        }
        catch (Throwable throwable) {
            void var2_2;
            this.sc().removeSparkListener((SparkListenerInterface)var2_2);
            throw throwable;
        }
        this.sc().removeSparkListener((SparkListenerInterface)listener);
        return (T)object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(Function0<T> body) {
        Object object;
        if (this.timeout <= 0L) {
            this.logger.info((Object)"starting training without setting timeout for waiting for resources");
            object = body.apply();
            return (T)object;
        }
        try {
            this.logger.info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"starting training with timeout set as ", " ms for waiting for resources"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeout)})));
            this.waitForCondition((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkParallelismTracker $outer;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.org$apache$spark$SparkParallelismTracker$$numAliveCores() >= this.$outer.org$apache$spark$SparkParallelismTracker$$requestedCores;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.timeout, this.waitForCondition$default$3());
        }
        catch (TimeoutException timeoutException) {
            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to get ", " workers for"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.org$apache$spark$SparkParallelismTracker$$requestedCores)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" XGBoost training"})).s((Seq)Nil$.MODULE$)).toString());
        }
        object = this.safeExecute(body);
        return (T)object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T executeHonorForGpu(Function0<T> body) {
        Object object;
        if (this.timeout <= 0L) {
            this.logger.info((Object)"starting GPU training without setting timeout for waiting for resources");
            object = body.apply();
            return (T)object;
        }
        try {
            this.logger.info((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"starting GPU training with timeout set as ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeout)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for waiting for resources"})).s((Seq)Nil$.MODULE$)).toString());
            this.waitForCondition((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkParallelismTracker $outer;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.org$apache$spark$SparkParallelismTracker$$numAliveCores() >= this.$outer.org$apache$spark$SparkParallelismTracker$$requestedCores && this.$outer.org$apache$spark$SparkParallelismTracker$$numAliveWorkers() >= this.$outer.org$apache$spark$SparkParallelismTracker$$numWorkers;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.timeout, this.waitForCondition$default$3());
        }
        catch (TimeoutException timeoutException) {
            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to get ", " workers for"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.org$apache$spark$SparkParallelismTracker$$numWorkers)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" XGBoost GPU training"})).s((Seq)Nil$.MODULE$)).toString());
        }
        object = this.safeExecute(body);
        return (T)object;
    }

    public SparkParallelismTracker(SparkContext sc, long timeout, int numWorkers) {
        URL uRL;
        this.sc = sc;
        this.timeout = timeout;
        this.org$apache$spark$SparkParallelismTracker$$numWorkers = numWorkers;
        this.org$apache$spark$SparkParallelismTracker$$requestedCores = numWorkers * sc.conf().getInt("spark.task.cpus", 1);
        this.mapper = new ObjectMapper();
        this.logger = LogFactory.getLog((String)"XGBoostSpark");
        Option option = sc.uiWebUrl();
        if (option instanceof Some) {
            Some some = (Some)option;
            String baseUrl = (String)some.x();
            uRL = new URL(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/api/v1/applications/", "/executors"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl, sc.applicationId()})));
        } else {
            uRL = null;
        }
        this.url = uRL;
    }
}

