/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.thrift.transport;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.shaded.apache.thrift.transport.TSaslTransport;
import org.shaded.apache.thrift.transport.TTransport;
import org.shaded.apache.thrift.transport.TTransportException;
import org.shaded.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TSaslServerTransport
extends TSaslTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSaslServerTransport.class);
    private Map<String, TSaslServerDefinition> serverDefinitionMap = new HashMap<String, TSaslServerDefinition>();

    public TSaslServerTransport(TTransport transport) {
        super(transport);
    }

    public TSaslServerTransport(String mechanism, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh, TTransport transport) {
        super(transport);
        this.addServerDefinition(mechanism, protocol, serverName, props, cbh);
    }

    private TSaslServerTransport(Map<String, TSaslServerDefinition> serverDefinitionMap, TTransport transport) {
        super(transport);
        this.serverDefinitionMap.putAll(serverDefinitionMap);
    }

    public void addServerDefinition(String mechanism, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh) {
        this.serverDefinitionMap.put(mechanism, new TSaslServerDefinition(mechanism, protocol, serverName, props, cbh));
    }

    @Override
    protected TSaslTransport.SaslRole getRole() {
        return TSaslTransport.SaslRole.SERVER;
    }

    @Override
    protected void handleSaslStartMessage() throws TTransportException, SaslException {
        TSaslTransport.SaslResponse message = this.receiveSaslMessage();
        LOGGER.debug("Received start message with status {}", (Object)message.status);
        if (message.status != TSaslTransport.NegotiationStatus.START) {
            throw this.sendAndThrowMessage(TSaslTransport.NegotiationStatus.ERROR, "Expecting START status, received " + (Object)((Object)message.status));
        }
        String mechanismName = new String(message.payload);
        TSaslServerDefinition serverDefinition = this.serverDefinitionMap.get(mechanismName);
        LOGGER.debug("Received mechanism name '{}'", (Object)mechanismName);
        if (serverDefinition == null) {
            throw this.sendAndThrowMessage(TSaslTransport.NegotiationStatus.BAD, "Unsupported mechanism type " + mechanismName);
        }
        SaslServer saslServer = Sasl.createSaslServer(serverDefinition.mechanism, serverDefinition.protocol, serverDefinition.serverName, serverDefinition.props, serverDefinition.cbh);
        this.setSaslServer(saslServer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends TTransportFactory {
        private static Map<TTransport, WeakReference<TSaslServerTransport>> transportMap = Collections.synchronizedMap(new WeakHashMap());
        private Map<String, TSaslServerDefinition> serverDefinitionMap = new HashMap<String, TSaslServerDefinition>();

        public Factory() {
        }

        public Factory(String mechanism, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh) {
            this.addServerDefinition(mechanism, protocol, serverName, props, cbh);
        }

        public void addServerDefinition(String mechanism, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh) {
            this.serverDefinitionMap.put(mechanism, new TSaslServerDefinition(mechanism, protocol, serverName, props, cbh));
        }

        @Override
        public TTransport getTransport(TTransport base) {
            WeakReference<TSaslServerTransport> ret = transportMap.get(base);
            if (ret == null || ret.get() == null) {
                LOGGER.debug("transport map does not contain key", (Object)base);
                ret = new WeakReference<TSaslServerTransport>(new TSaslServerTransport(this.serverDefinitionMap, base));
                try {
                    ((TSaslServerTransport)ret.get()).open();
                }
                catch (TTransportException e) {
                    LOGGER.debug("failed to open server transport", (Throwable)e);
                    throw new RuntimeException(e);
                }
                transportMap.put(base, ret);
            } else {
                LOGGER.debug("transport map does contain key {}", (Object)base);
            }
            return (TTransport)ret.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TSaslServerDefinition {
        public String mechanism;
        public String protocol;
        public String serverName;
        public Map<String, String> props;
        public CallbackHandler cbh;

        public TSaslServerDefinition(String mechanism, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh) {
            this.mechanism = mechanism;
            this.protocol = protocol;
            this.serverName = serverName;
            this.props = props;
            this.cbh = cbh;
        }
    }
}

