/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.thrift;

import java.util.HashMap;
import java.util.Map;
import org.shaded.apache.thrift.TException;
import org.shaded.apache.thrift.TProcessor;
import org.shaded.apache.thrift.protocol.TMessage;
import org.shaded.apache.thrift.protocol.TProtocol;
import org.shaded.apache.thrift.protocol.TProtocolDecorator;

public class TMultiplexedProcessor
implements TProcessor {
    private final Map<String, TProcessor> SERVICE_PROCESSOR_MAP = new HashMap<String, TProcessor>();

    public void registerProcessor(String serviceName, TProcessor processor) {
        this.SERVICE_PROCESSOR_MAP.put(serviceName, processor);
    }

    public boolean process(TProtocol iprot, TProtocol oprot) throws TException {
        TMessage message = iprot.readMessageBegin();
        if (message.type != 1 && message.type != 4) {
            throw new TException("This should not have happened!?");
        }
        int index = message.name.indexOf(":");
        if (index < 0) {
            throw new TException("Service name not found in message name: " + message.name + ".  Did you " + "forget to use a TMultiplexProtocol in your client?");
        }
        String serviceName = message.name.substring(0, index);
        TProcessor actualProcessor = this.SERVICE_PROCESSOR_MAP.get(serviceName);
        if (actualProcessor == null) {
            throw new TException("Service name not found: " + serviceName + ".  Did you forget " + "to call registerProcessor()?");
        }
        TMessage standardMessage = new TMessage(message.name.substring(serviceName.length() + ":".length()), message.type, message.seqid);
        return actualProcessor.process(new StoredMessageProtocol(iprot, standardMessage), oprot);
    }

    private static class StoredMessageProtocol
    extends TProtocolDecorator {
        TMessage messageBegin;

        public StoredMessageProtocol(TProtocol protocol, TMessage messageBegin) {
            super(protocol);
            this.messageBegin = messageBegin;
        }

        public TMessage readMessageBegin() throws TException {
            return this.messageBegin;
        }
    }
}

