/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.parquet.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.shaded.apache.parquet.Exceptions;
import org.shaded.apache.parquet.Preconditions;
import org.shaded.apache.parquet.util.DynMethods;

public class DynConstructors {
    private static String formatProblems(Map<String, Throwable> problems) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, Throwable> problem : problems.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append("\n");
            }
            sb.append("\tMissing ").append(problem.getKey()).append(" [").append(problem.getValue().getClass().getName()).append(": ").append(problem.getValue().getMessage()).append("]");
        }
        return sb.toString();
    }

    private static String methodName(Class<?> targetClass, Class<?> ... types) {
        StringBuilder sb = new StringBuilder();
        sb.append(targetClass.getName()).append("(");
        boolean first = true;
        for (Class<?> type : types) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(type.getName());
        }
        sb.append(")");
        return sb.toString();
    }

    private static class MakeAccessible
    implements PrivilegedAction<Void> {
        private Constructor<?> hidden;

        public MakeAccessible(Constructor<?> hidden) {
            this.hidden = hidden;
        }

        @Override
        public Void run() {
            this.hidden.setAccessible(true);
            return null;
        }
    }

    public static class Builder {
        private final Class<?> baseClass;
        private ClassLoader loader = Thread.currentThread().getContextClassLoader();
        private Ctor ctor = null;
        private Map<String, Throwable> problems = new HashMap<String, Throwable>();

        public Builder(Class<?> baseClass) {
            this.baseClass = baseClass;
        }

        public Builder() {
            this.baseClass = null;
        }

        public Builder loader(ClassLoader loader) {
            this.loader = loader;
            return this;
        }

        public Builder impl(String className, Class<?> ... types) {
            if (this.ctor != null) {
                return this;
            }
            try {
                Class<?> targetClass = Class.forName(className, true, this.loader);
                this.impl(targetClass, types);
            }
            catch (NoClassDefFoundError e) {
                this.problems.put(className, e);
            }
            catch (ClassNotFoundException e) {
                this.problems.put(className, e);
            }
            return this;
        }

        public <T> Builder impl(Class<T> targetClass, Class<?> ... types) {
            if (this.ctor != null) {
                return this;
            }
            try {
                this.ctor = new Ctor(targetClass.getConstructor(types), targetClass);
            }
            catch (NoSuchMethodException e) {
                this.problems.put(DynConstructors.methodName(targetClass, types), e);
            }
            return this;
        }

        public Builder hiddenImpl(Class<?> ... types) {
            this.hiddenImpl((Class<T>)this.baseClass, types);
            return this;
        }

        public Builder hiddenImpl(String className, Class<?> ... types) {
            if (this.ctor != null) {
                return this;
            }
            try {
                Class<?> targetClass = Class.forName(className, true, this.loader);
                this.hiddenImpl((Class<T>)targetClass, types);
            }
            catch (NoClassDefFoundError e) {
                this.problems.put(className, e);
            }
            catch (ClassNotFoundException e) {
                this.problems.put(className, e);
            }
            return this;
        }

        public <T> Builder hiddenImpl(Class<T> targetClass, Class<?> ... types) {
            if (this.ctor != null) {
                return this;
            }
            try {
                Constructor<T> hidden = targetClass.getDeclaredConstructor(types);
                AccessController.doPrivileged(new MakeAccessible(hidden));
                this.ctor = new Ctor(hidden, targetClass);
            }
            catch (SecurityException e) {
                this.problems.put(DynConstructors.methodName(targetClass, types), e);
            }
            catch (NoSuchMethodException e) {
                this.problems.put(DynConstructors.methodName(targetClass, types), e);
            }
            return this;
        }

        public <C> Ctor<C> buildChecked() throws NoSuchMethodException {
            if (this.ctor != null) {
                return this.ctor;
            }
            throw new NoSuchMethodException("Cannot find constructor for " + this.baseClass + "\n" + DynConstructors.formatProblems(this.problems));
        }

        public <C> Ctor<C> build() {
            if (this.ctor != null) {
                return this.ctor;
            }
            throw new RuntimeException("Cannot find constructor for " + this.baseClass + "\n" + DynConstructors.formatProblems(this.problems));
        }
    }

    public static class Ctor<C>
    extends DynMethods.UnboundMethod {
        private final Constructor<C> ctor;
        private final Class<? extends C> constructed;

        private Ctor(Constructor<C> constructor, Class<? extends C> constructed) {
            super(null, "newInstance");
            this.ctor = constructor;
            this.constructed = constructed;
        }

        public Class<? extends C> getConstructedClass() {
            return this.constructed;
        }

        public C newInstanceChecked(Object ... args) throws Exception {
            try {
                return this.ctor.newInstance(args);
            }
            catch (InstantiationException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Exceptions.throwIfInstance(e.getCause(), Exception.class);
                Exceptions.throwIfInstance(e.getCause(), RuntimeException.class);
                throw new RuntimeException(e.getCause());
            }
        }

        public C newInstance(Object ... args) {
            try {
                return this.newInstanceChecked(args);
            }
            catch (Exception e) {
                Exceptions.throwIfInstance(e, RuntimeException.class);
                throw new RuntimeException(e);
            }
        }

        @Override
        public <R> R invoke(Object target, Object ... args) {
            Preconditions.checkArgument(target == null, "Invalid call to constructor: target must be null");
            return (R)this.newInstance(args);
        }

        @Override
        public <R> R invokeChecked(Object target, Object ... args) throws Exception {
            Preconditions.checkArgument(target == null, "Invalid call to constructor: target must be null");
            return (R)this.newInstanceChecked(args);
        }

        @Override
        public DynMethods.BoundMethod bind(Object receiver) {
            throw new IllegalStateException("Cannot bind constructors");
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "(constructor=" + this.ctor + ", class=" + this.constructed + ")";
        }
    }
}

