/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.parquet.hadoop.example;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.shaded.apache.parquet.example.data.Group;
import org.shaded.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.shaded.apache.parquet.hadoop.api.ReadSupport;
import org.shaded.apache.parquet.io.api.RecordMaterializer;
import org.shaded.apache.parquet.schema.MessageType;

public class GroupReadSupport
extends ReadSupport<Group> {
    @Override
    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        String partialSchemaString = configuration.get("parquet.read.schema");
        MessageType requestedProjection = GroupReadSupport.getSchemaForRead(fileSchema, partialSchemaString);
        return new ReadSupport.ReadContext(requestedProjection);
    }

    @Override
    public RecordMaterializer<Group> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new GroupRecordConverter(readContext.getRequestedSchema());
    }
}

