/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.parquet.column.values.bitpacking;

import java.io.IOException;
import java.io.InputStream;
import org.shaded.apache.parquet.bytes.ByteBufferInputStream;
import org.shaded.apache.parquet.bytes.BytesUtils;
import org.shaded.apache.parquet.column.values.ValuesReader;
import org.shaded.apache.parquet.column.values.bitpacking.BitPacking;
import org.shaded.apache.parquet.io.ParquetDecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitPackingValuesReader
extends ValuesReader {
    private static final Logger LOG = LoggerFactory.getLogger(BitPackingValuesReader.class);
    private ByteBufferInputStream in;
    private BitPacking.BitPackingReader bitPackingReader;
    private final int bitsPerValue;

    public BitPackingValuesReader(int bound) {
        this.bitsPerValue = BytesUtils.getWidthFromMaxInt(bound);
    }

    @Override
    public int readInteger() {
        try {
            return this.bitPackingReader.read();
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public void initFromPage(int valueCount, ByteBufferInputStream stream) throws IOException {
        int effectiveBitLength = valueCount * this.bitsPerValue;
        int length = BytesUtils.paddedByteCountFromBits(effectiveBitLength);
        LOG.debug("reading {} bytes for {} values of size {} bits.", new Object[]{length, valueCount, this.bitsPerValue});
        this.in = stream.sliceStream(length);
        this.bitPackingReader = BitPacking.createBitPackingReader((int)this.bitsPerValue, (InputStream)this.in, (long)valueCount);
    }

    @Override
    public void skip() {
        this.readInteger();
    }
}

