/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.orc.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.shaded.apache.orc.OrcConf;
import org.shaded.apache.orc.OrcFile;
import org.shaded.apache.orc.Reader;
import org.shaded.apache.orc.mapreduce.OrcMapreduceRecordReader;
import org.shaded.apache.orc.storage.ql.io.sarg.SearchArgument;

public class OrcInputFormat<V extends WritableComparable>
extends FileInputFormat<NullWritable, V> {
    public static void setSearchArgument(Configuration conf, SearchArgument sarg, String[] columnNames) {
        org.shaded.apache.orc.mapred.OrcInputFormat.setSearchArgument(conf, sarg, columnNames);
    }

    public RecordReader<NullWritable, V> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        FileSplit split = (FileSplit)inputSplit;
        Configuration conf = taskAttemptContext.getConfiguration();
        Reader file = OrcFile.createReader(split.getPath(), OrcFile.readerOptions(conf).maxLength(OrcConf.MAX_FILE_LENGTH.getLong(conf)));
        return new OrcMapreduceRecordReader(file, org.shaded.apache.orc.mapred.OrcInputFormat.buildOptions(conf, file, split.getStart(), split.getLength()));
    }

    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        List complete = super.listStatus(job);
        ArrayList<FileStatus> result = new ArrayList<FileStatus>(complete.size());
        for (FileStatus stat : complete) {
            if (stat.getLen() == 0L) continue;
            result.add(stat);
        }
        return result;
    }
}

