/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.orc.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.shaded.apache.orc.OrcConf;
import org.shaded.apache.orc.TypeDescription;
import org.shaded.apache.orc.mapred.OrcStruct;

public final class OrcKey
implements WritableComparable<OrcKey>,
JobConfigurable {
    public WritableComparable key;

    public OrcKey(WritableComparable key) {
        this.key = key;
    }

    public OrcKey() {
        this.key = null;
    }

    public void write(DataOutput dataOutput) throws IOException {
        this.key.write(dataOutput);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.key.readFields(dataInput);
    }

    public void configure(JobConf conf) {
        if (this.key == null) {
            TypeDescription schema = TypeDescription.fromString(OrcConf.MAPRED_SHUFFLE_KEY_SCHEMA.getString((Configuration)conf));
            this.key = OrcStruct.createValue(schema);
        }
    }

    public int compareTo(OrcKey o) {
        return this.key.compareTo((Object)o.key);
    }

    public boolean equals(Object o) {
        if (o == null || this.key == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return this.key.equals(((OrcKey)o).key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

