/*
 * Decompiled with CFR 0.152.
 */
package ai.quantnet;

import ai.quantnet.bz.DataFrame;
import ai.quantnet.bz.DataIndexVector;
import ai.quantnet.bz.DataIndexVector$;
import ai.quantnet.data;
import ai.quantnet.data$fields$;
import ai.quantnet.data$foreverPeriod$;
import ai.quantnet.gzip$;
import ai.quantnet.intern$;
import ai.quantnet.net$;
import ai.quantnet.netcdf$;
import com.fasterxml.jackson.module.scala.ScalaObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class data$ {
    public static final data$ MODULE$ = new data$();
    private static final Logger LOG = LoggerFactory.getLogger(MODULE$.getClass());
    private static final int BATCH_LIMIT = 300000;
    private static final HashMap<String, String> clientToServerIdMapping = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    private static final HashMap<String, String> serverToClientIdMapping = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    private static final File idMappingFile = new File("id-translation.csv");
    private static final Ordering<LocalDate> localDateOrdering;

    static {
        if (MODULE$.idMappingFile().exists()) {
            Scanner scanner = new Scanner(MODULE$.idMappingFile());
            boolean first = true;
            while (scanner.hasNext()) {
                String line = scanner.nextLine();
                if (first) {
                    first = false;
                    continue;
                }
                if ((line = line.replaceAll("^\"+", "").replaceAll("\"+$", "")).length() <= 2) continue;
                String[] parts = line.split(",");
                String serverId = parts[0];
                String clientId = parts[1];
                MODULE$.clientToServerIdMapping().update((Object)clientId, (Object)serverId);
                MODULE$.serverToClientIdMapping().update((Object)serverId, (Object)clientId);
            }
            scanner.close();
        } else {
            FileWriter writer = new FileWriter(MODULE$.idMappingFile());
            writer.write("server_id,client_id\n");
            writer.close();
        }
        localDateOrdering = package$.MODULE$.Ordering().by((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.toEpochDay()), (Ordering)Ordering.Long$.MODULE$);
    }

    public DataFrame<LocalDate, String, Object> normalizeOutput(DataFrame<LocalDate, String, Object> output) {
        IndexedSeq assets = (IndexedSeq)output.colIdx().toIndexedSeq().sortBy((Function1 & Serializable)i -> i, (Ordering)Ordering.String$.MODULE$);
        DataIndexVector assetIdx = DataIndexVector$.MODULE$.apply(assets, true, true, false, Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        IndexedSeq time = (IndexedSeq)output.rowIdx().toIndexedSeq().sortBy((Function1 & Serializable)i -> i, this.localDateOrdering());
        DataIndexVector<LocalDate> timeIdx = DataIndexVector$.MODULE$.apply(time, true, true, false, this.localDateOrdering(), ClassTag$.MODULE$.apply(LocalDate.class));
        DataFrame<LocalDate, String, Object> result = output.align$mcD$sp(timeIdx, assetIdx, Double.NaN);
        result.rowIdx().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ti -> {
            block0: {
                DoubleRef sum = DoubleRef.create((double)0.0);
                result.colIdx().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ai -> {
                    if (Predef$.MODULE$.double2Double(result.data$mcD$sp().apply$mcD$sp(ti, ai)).isNaN()) {
                        result.data$mcD$sp().update$mcD$sp(ti, ai, 0.0);
                    }
                    sum$1.elem += scala.math.package$.MODULE$.abs(result.data$mcD$sp().apply$mcD$sp(ti, ai));
                });
                if (!(sum.elem > 1.0)) break block0;
                result.colIdx().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ai -> result.data$mcD$sp().update$mcD$sp(ti, ai, result.data$mcD$sp().apply$mcD$sp(ti, ai) / sum$1.elem));
            }
        });
        return result;
    }

    public List<data.StockInfo> loadStockList(LocalDate minDate, LocalDate maxDate) {
        String uri = new StringBuilder(26).append("assets?min_date=").append(minDate).append("&max_date=").append(maxDate).toString();
        byte[] dataBytes = net$.MODULE$.httpRequestWithRetry(new StringBuilder(0).append(this.baseUrl()).append(uri).toString(), net$.MODULE$.httpRequestWithRetry$default$2());
        if (dataBytes == null) {
            return List$.MODULE$.empty();
        }
        List lst = (List)((ScalaObjectMapper)net$.MODULE$.OBJECT_MAPPER()).readValue(dataBytes, ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        return (List)((List)lst.sortBy((Function1 & Serializable)i -> (String)i.getOrElse((Object)"last_point_id", (Function0 & Serializable)() -> "1900-01-01"), (Ordering)Ordering.String$.MODULE$)).reverse().map((Function1 & Serializable)p -> new data.StockInfo((Map<String, Object>)p)).sortBy((Function1 & Serializable)i -> i.id(), (Ordering)Ordering.String$.MODULE$);
    }

    public LocalDate loadStockList$default$1() {
        return LocalDate.of(2007, 1, 1);
    }

    public LocalDate loadStockList$default$2() {
        return LocalDate.now();
    }

    public Map<String, DataFrame<LocalDate, String, Object>> loadStockDailySeries(Seq<String> ids, LocalDate minDate, LocalDate maxDate) {
        List realIds = ids != null ? ids : this.loadStockList(minDate, maxDate).map((Function1 & Serializable)i -> i.id());
        Map<String, DataFrame<LocalDate, String, Object>> series = this.loadStockDailyOriginSeries((Seq<String>)realIds, minDate, maxDate);
        ObjectRef splitCumprod = ObjectRef.create((Object)((DataFrame)series.apply((Object)data$fields$.MODULE$.split_cumprod())));
        series.foreach((Function1 & Serializable)e -> {
            BoxedUnit boxedUnit;
            String string = (String)e._1();
            String string2 = data$fields$.MODULE$.vol();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                ((DataFrame)e._2()).data$mcD$sp().foreachKey((Function1 & Serializable)k -> {
                    data$.$anonfun$loadStockDailySeries$3(e, splitCumprod, k);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl;
                String string4 = data$fields$.MODULE$.open();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    bl = true;
                } else {
                    String string6 = data$fields$.MODULE$.low();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        bl = true;
                    } else {
                        String string8 = data$fields$.MODULE$.high();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            bl = true;
                        } else {
                            String string10 = data$fields$.MODULE$.close();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                bl = true;
                            } else {
                                String string12 = data$fields$.MODULE$.divs();
                                String string13 = string;
                                bl = !(string12 != null ? !string12.equals(string13) : string13 != null);
                            }
                        }
                    }
                }
                if (bl) {
                    ((DataFrame)e._2()).data$mcD$sp().foreachKey((Function1 & Serializable)k -> {
                        data$.$anonfun$loadStockDailySeries$4(e, splitCumprod, k);
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = new Tuple2(e._1(), e._2());
                }
            }
            return boxedUnit;
        });
        return series;
    }

    public Seq<String> loadStockDailySeries$default$1() {
        return null;
    }

    public LocalDate loadStockDailySeries$default$2() {
        return LocalDate.of(2007, 1, 1);
    }

    public LocalDate loadStockDailySeries$default$3() {
        return LocalDate.now();
    }

    public Map<String, DataFrame<LocalDate, String, Object>> loadStockDailyOriginSeries(Seq<String> ids, LocalDate minDate, LocalDate maxDate) {
        return (Map)intern$.MODULE$.ctx((Function0 & Serializable)() -> {
            Seq serverIds = (Seq)((SeqOps)ids.map((Function1 & Serializable)clientId -> MODULE$.getServerId((String)clientId))).sorted((Ordering)Ordering.String$.MODULE$);
            Map result = MODULE$.loadStockDailyRawSeries((Seq<String>)serverIds, minDate, maxDate);
            String[] clientIds = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((DataFrame)result.apply((Object)data$fields$.MODULE$.close())).colIdx().toArray(ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)i -> MODULE$.ai$quantnet$data$$getClientId((String)i, MODULE$.getClientId$default$2(), MODULE$.getClientId$default$3()), ClassTag$.MODULE$.apply(String.class));
            String[] sortedClientList = (String[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])clientIds), (Ordering)Ordering.String$.MODULE$);
            LocalDate[] timeList = (LocalDate[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])((DataFrame)result.apply((Object)data$fields$.MODULE$.close())).rowIdx().toArray(ClassTag$.MODULE$.apply(LocalDate.class))), MODULE$.localDateOrdering());
            result = (Map)result.map((Function1 & Serializable)e -> new Tuple2(e._1(), ((DataFrame)e._2()).withIdx$mcD$sp(((DataFrame)e._2()).rowIdx(), DataIndexVector$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])clientIds), Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class))).loc$mcD$sp(Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)timeList), Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)sortedClientList)).withIdx$mcD$sp(DataIndexVector$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])timeList), MODULE$.localDateOrdering(), ClassTag$.MODULE$.apply(LocalDate.class)), DataIndexVector$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])sortedClientList), Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class)))));
            return result;
        });
    }

    public LocalDate loadStockDailyOriginSeries$default$2() {
        return LocalDate.of(2007, 1, 1);
    }

    public LocalDate loadStockDailyOriginSeries$default$3() {
        return LocalDate.now();
    }

    public List<data.IndexInfo> loadIndexList(LocalDate minDate, LocalDate maxDate) {
        String uri = new StringBuilder(28).append("idx/list?min_date=").append(minDate).append("&max_date=").append(maxDate).toString();
        byte[] dataBytes = net$.MODULE$.httpRequestWithRetry(new StringBuilder(0).append(this.baseUrl()).append(uri).toString(), net$.MODULE$.httpRequestWithRetry$default$2());
        return (List)((ScalaObjectMapper)net$.MODULE$.OBJECT_MAPPER()).readValue(dataBytes, ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(data.IndexInfo.class), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
    }

    public LocalDate loadIndexList$default$1() {
        return LocalDate.of(2007, 1, 1);
    }

    public LocalDate loadIndexList$default$2() {
        return LocalDate.now();
    }

    public DataFrame<LocalDate, String, Object> loadIndexDailySeries(Seq<String> ids, LocalDate minDate, LocalDate maxDate) {
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ids"), ids), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min_date"), (Object)minDate.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_date"), (Object)maxDate.toString())}));
        byte[] resBytes = net$.MODULE$.httpRequestWithRetry(new StringBuilder(8).append(this.baseUrl()).append("idx/data").toString(), params);
        DataFrame<LocalDate, String, Object> resFrame = netcdf$.MODULE$.netcdf2DToFrames(resBytes);
        IndexedSeq sortedTime = (IndexedSeq)resFrame.rowIdx().toIndexedSeq().sorted(this.localDateOrdering());
        IndexedSeq sortedAsset = (IndexedSeq)resFrame.colIdx().toIndexedSeq().sorted((Ordering)Ordering.String$.MODULE$);
        resFrame = resFrame.loc$mcD$sp((IndexedSeq<LocalDate>)sortedTime, (IndexedSeq<String>)sortedAsset);
        resFrame = resFrame.withIdx$mcD$sp(DataIndexVector$.MODULE$.apply(sortedTime, this.localDateOrdering(), ClassTag$.MODULE$.apply(LocalDate.class)), DataIndexVector$.MODULE$.apply(sortedAsset, Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        resFrame = resFrame.copy$mcD$sp();
        return resFrame;
    }

    public LocalDate loadIndexDailySeries$default$2() {
        return LocalDate.of(2007, 1, 1);
    }

    public LocalDate loadIndexDailySeries$default$3() {
        return LocalDate.now();
    }

    public List<data.SecForm> loadSecgovForms(Seq<String> ciks, Seq<String> types, Seq<String> facts, boolean skipSegment, LocalDate minDate, LocalDate maxDate) {
        return (List)intern$.MODULE$.ctx((Function0 & Serializable)() -> {
            ListBuffer lst = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            boolean go = true;
            int offset = 0;
            HashMap params = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ciks"), (Object)ciks), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offset"), (Object)BoxesRunTime.boxToInteger((int)offset)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"facts"), (Object)facts), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"skip_segment"), (Object)BoxesRunTime.boxToBoolean((boolean)skipSegment)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min_date"), (Object)minDate.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_date"), (Object)maxDate.toString())}));
            while (go) {
                byte[] bytes = net$.MODULE$.httpRequestWithRetry(new StringBuilder(13).append(MODULE$.baseUrl()).append("sec.gov/forms").toString(), params);
                List p = (List)((ScalaObjectMapper)net$.MODULE$.OBJECT_MAPPER()).readValue(bytes, ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                p.foreach((Function1 & Serializable)r -> lst.addOne((Object)new data.SecForm((Map<String, Object>)r)));
                params.update((Object)"offset", (Object)BoxesRunTime.boxToInteger((int)(offset += p.length())));
                MODULE$.LOG().info(new StringBuilder(20).append("fetched reports ").append(lst.length()).append(" (+").append(p.length()).append(")").toString());
                go = p.nonEmpty();
            }
            return lst.toList();
        });
    }

    public Seq<String> loadSecgovForms$default$2() {
        return null;
    }

    public Seq<String> loadSecgovForms$default$3() {
        return null;
    }

    public boolean loadSecgovForms$default$4() {
        return true;
    }

    public LocalDate loadSecgovForms$default$5() {
        return LocalDate.of(2007, 1, 1);
    }

    public LocalDate loadSecgovForms$default$6() {
        return LocalDate.now();
    }

    public Object ai$quantnet$data$$convertPeriod(Object v) {
        LocalDate localDate;
        if (v instanceof Map) {
            Object object;
            Map m = (Map)v;
            Object object2 = m.apply((Object)"type");
            if ("instant".equals(object2)) {
                object = intern$.MODULE$.apply(LocalDate.parse((String)m.apply((Object)"value")));
            } else if ("range".equals(object2)) {
                List r = ((List)m.apply((Object)"value")).map((Function1 & Serializable)i -> intern$.MODULE$.apply(LocalDate.parse(i)));
                object = intern$.MODULE$.apply(new data.RangePeriod((LocalDate)r.apply(0), (LocalDate)r.apply(1)));
            } else {
                object = "forever".equals(object2) ? data$foreverPeriod$.MODULE$ : null;
            }
            localDate = object;
        } else {
            localDate = null;
        }
        return localDate;
    }

    public Object ai$quantnet$data$$convertUnit(Object v) {
        data.MeasureUnit measureUnit;
        if (v instanceof Map) {
            Product product;
            Map m = (Map)v;
            Object object = m.apply((Object)"type");
            if ("measure".equals(object)) {
                product = intern$.MODULE$.apply(new data.MeasureUnit(intern$.MODULE$.apply((String)m.apply((Object)"value"))));
            } else if ("divide".equals(object)) {
                List r = ((List)m.apply((Object)"value")).map((Function1 & Serializable)x$1 -> intern$.MODULE$.apply(x$1));
                product = intern$.MODULE$.apply(new data.DivideUnit((String)r.apply(0), (String)r.apply(1)));
            } else {
                product = null;
            }
            measureUnit = product;
        } else {
            measureUnit = null;
        }
        return measureUnit;
    }

    private Logger LOG() {
        return LOG;
    }

    private int BATCH_LIMIT() {
        return BATCH_LIMIT;
    }

    public Map<String, DataFrame<LocalDate, String, Object>> loadStockDailyRawSeries(Seq<String> ids, LocalDate minDate, LocalDate maxDate) {
        int size;
        int days = scala.math.package$.MODULE$.max(1, (int)ChronoUnit.DAYS.between(minDate, maxDate));
        int maxChunkSize = this.BATCH_LIMIT() / days;
        IndexedSeq chunks = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$);
        for (int offset = 0; offset < ids.length(); offset += size) {
            size = scala.math.package$.MODULE$.min(maxChunkSize, ids.length() - offset);
            this.LOG().info(new StringBuilder(54).append("Load chunk offset: offset=").append(offset).append(" size=").append(size).append(" length=").append(ids.length()).append(" maxChunkSize=").append(maxChunkSize).toString());
            Seq chunkIds = (Seq)ids.slice(offset, offset + size);
            Map<String, DataFrame<LocalDate, String, Object>> chunk = this.loadStockDailyRawChunk((Seq<String>)chunkIds, minDate, maxDate);
            chunks = (IndexedSeq)chunks.$colon$plus(chunk);
        }
        return this.mergeStockDailyRawChunks((IndexedSeq<Map<String, DataFrame<LocalDate, String, Object>>>)chunks);
    }

    public LocalDate loadStockDailyRawSeries$default$2() {
        return LocalDate.of(2007, 1, 1);
    }

    public LocalDate loadStockDailyRawSeries$default$3() {
        return LocalDate.now();
    }

    private Map<String, DataFrame<LocalDate, String, Object>> mergeStockDailyRawChunks(IndexedSeq<Map<String, DataFrame<LocalDate, String, Object>>> chunks) {
        ObjectRef result = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        data$fields$.MODULE$.values().foreach((Function1 & Serializable)field -> {
            data$.$anonfun$mergeStockDailyRawChunks$1(chunks, result, field);
            return BoxedUnit.UNIT;
        });
        return (Map)result.elem;
    }

    private Map<String, DataFrame<LocalDate, String, Object>> loadStockDailyRawChunk(Seq<String> ids, LocalDate minDate, LocalDate maxDate) {
        String uri = "data";
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"assets"), ids), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min_date"), (Object)minDate.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_date"), (Object)maxDate.toString())}));
        byte[] dataBytes = net$.MODULE$.httpRequestWithRetry(new StringBuilder(0).append(this.baseUrl()).append(uri).toString(), params);
        return netcdf$.MODULE$.netcdf3DToFrames(dataBytes);
    }

    private LocalDate loadStockDailyRawChunk$default$2() {
        return LocalDate.of(2007, 1, 1);
    }

    private LocalDate loadStockDailyRawChunk$default$3() {
        return LocalDate.now();
    }

    public void writeOutput(DataFrame<LocalDate, String, Object> df) {
        DataFrame<LocalDate, String, Object> normalized = this.normalizeOutput(df);
        byte[] bytes = netcdf$.MODULE$.dataFrameToNetcdf(normalized);
        byte[] gz = gzip$.MODULE$.gzipCompress(bytes);
        String path = System.getenv().getOrDefault("OUTPUT_PATH", "fractions.nc.gz");
        try (FileOutputStream w = new FileOutputStream(path);){
            w.write(gz);
        }
    }

    private String baseUrl() {
        return System.getenv().getOrDefault("DATA_BASE_URL", "http://127.0.0.1:8000/");
    }

    private HashMap<String, String> clientToServerIdMapping() {
        return clientToServerIdMapping;
    }

    private HashMap<String, String> serverToClientIdMapping() {
        return serverToClientIdMapping;
    }

    private File idMappingFile() {
        return idMappingFile;
    }

    public String ai$quantnet$data$$getClientId(String serverId, String exchange, String symbol) {
        String string;
        if (this.serverToClientIdMapping().contains((Object)serverId)) {
            string = (String)this.serverToClientIdMapping().apply((Object)serverId);
        } else if (exchange == null || symbol == null) {
            string = serverId;
        } else {
            String preferedId;
            String clientId = preferedId = new StringBuilder(1).append(exchange).append(":").append(symbol).toString();
            int num = 0;
            while (this.clientToServerIdMapping().contains((Object)clientId)) {
                clientId = new StringBuilder(1).append(preferedId).append("~").append(++num).toString();
            }
            this.clientToServerIdMapping().update((Object)clientId, (Object)serverId);
            this.serverToClientIdMapping().update((Object)serverId, (Object)clientId);
            FileWriter writer = new FileWriter(this.idMappingFile(), true);
            writer.write(new StringBuilder(2).append(serverId).append(",").append(clientId).append("\n").toString());
            writer.close();
            string = clientId;
        }
        return string;
    }

    private String getClientId$default$2() {
        return null;
    }

    private String getClientId$default$3() {
        return null;
    }

    private String getServerId(String clientId) {
        return this.clientToServerIdMapping().contains((Object)clientId) ? (String)this.clientToServerIdMapping().apply((Object)clientId) : clientId;
    }

    private Ordering<LocalDate> localDateOrdering() {
        return localDateOrdering;
    }

    public static final /* synthetic */ void $anonfun$loadStockDailySeries$3(Tuple2 e$1, ObjectRef splitCumprod$1, Tuple2 k) {
        ((DataFrame)e$1._2()).data$mcD$sp().update$mcD$sp(k, ((DataFrame)e$1._2()).data$mcD$sp().apply$mcD$sp(k) / ((DataFrame)splitCumprod$1.elem).data$mcD$sp().apply$mcD$sp(k));
    }

    public static final /* synthetic */ void $anonfun$loadStockDailySeries$4(Tuple2 e$1, ObjectRef splitCumprod$1, Tuple2 k) {
        ((DataFrame)e$1._2()).data$mcD$sp().update$mcD$sp(k, ((DataFrame)e$1._2()).data$mcD$sp().apply$mcD$sp(k) * ((DataFrame)splitCumprod$1.elem).data$mcD$sp().apply$mcD$sp(k));
    }

    public static final /* synthetic */ void $anonfun$mergeStockDailyRawChunks$1(IndexedSeq chunks$1, ObjectRef result$2, String field) {
        IndexedSeq frames = (IndexedSeq)chunks$1.map((Function1 & Serializable)c -> (DataFrame)c.apply((Object)field));
        result$2.elem = (Map)((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), ((DataFrame)frames.apply(0)).combine$mcD$sp(frames, Double.NaN)));
    }

    private data$() {
    }
}

