package ai.minxiao.ds4s.core.h2o

import annotation.Annotation

/**
  * H2O Versions
  *
  * @constructor
  * @param h2o: h2o core version
  * @param water: sparkling water version
  * @param spark: spark version
  *
  * @author mx
  */
class H2OVersion(
  h2o: String   = "3.16.0.2",
  water: String = "2.2.5",
  spark: String = "2.2.0")
    extends Annotation {

  // sparkling water version compatible with spark version
  require(water.split(".").init == spark.split(".").init)
}
