package ai.minxiao.ds4s.core.dl4j.math

import org.nd4j.linalg.api.ndarray.INDArray
import org.nd4j.linalg.api.ops.impl.transforms.{Sign, Sin}
import org.nd4j.linalg.factory.Nd4j

/**
  * Square Wave Function
  *
  * @author mx 
  */
class SquareWaveMathFunction extends MathFunction {
  def getFunctionValues(x: INDArray): INDArray = {
    val sin = Nd4j.getExecutioner.execAndReturn(new Sin(x.dup))
    Nd4j.getExecutioner.execAndReturn(new Sign(sin))
  }

  def getName: String = "SquareWave"
}
