/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.activations;

import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationCube;
import org.nd4j.linalg.activations.impl.ActivationELU;
import org.nd4j.linalg.activations.impl.ActivationHardSigmoid;
import org.nd4j.linalg.activations.impl.ActivationHardTanH;
import org.nd4j.linalg.activations.impl.ActivationIdentity;
import org.nd4j.linalg.activations.impl.ActivationLReLU;
import org.nd4j.linalg.activations.impl.ActivationRATanh;
import org.nd4j.linalg.activations.impl.ActivationRReLU;
import org.nd4j.linalg.activations.impl.ActivationRationalTanh;
import org.nd4j.linalg.activations.impl.ActivationReLU;
import org.nd4j.linalg.activations.impl.ActivationRectifiedTanh;
import org.nd4j.linalg.activations.impl.ActivationSELU;
import org.nd4j.linalg.activations.impl.ActivationSigmoid;
import org.nd4j.linalg.activations.impl.ActivationSoftPlus;
import org.nd4j.linalg.activations.impl.ActivationSoftSign;
import org.nd4j.linalg.activations.impl.ActivationSoftmax;
import org.nd4j.linalg.activations.impl.ActivationSwish;
import org.nd4j.linalg.activations.impl.ActivationTanH;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarSet;
import org.nd4j.linalg.api.ops.impl.transforms.Cube;
import org.nd4j.linalg.api.ops.impl.transforms.ELU;
import org.nd4j.linalg.api.ops.impl.transforms.HardSigmoid;
import org.nd4j.linalg.api.ops.impl.transforms.HardTanh;
import org.nd4j.linalg.api.ops.impl.transforms.LeakyReLU;
import org.nd4j.linalg.api.ops.impl.transforms.OldIdentity;
import org.nd4j.linalg.api.ops.impl.transforms.OldSoftMax;
import org.nd4j.linalg.api.ops.impl.transforms.RationalTanh;
import org.nd4j.linalg.api.ops.impl.transforms.RectifedLinear;
import org.nd4j.linalg.api.ops.impl.transforms.RectifiedTanh;
import org.nd4j.linalg.api.ops.impl.transforms.SELU;
import org.nd4j.linalg.api.ops.impl.transforms.Sigmoid;
import org.nd4j.linalg.api.ops.impl.transforms.SigmoidDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.SoftMaxDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.SoftPlus;
import org.nd4j.linalg.api.ops.impl.transforms.SoftSign;
import org.nd4j.linalg.api.ops.impl.transforms.Step;
import org.nd4j.linalg.api.ops.impl.transforms.Swish;
import org.nd4j.linalg.api.ops.impl.transforms.SwishDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.Tanh;
import org.nd4j.linalg.api.ops.impl.transforms.TanhDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.CubeDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.ELUDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.HardSigmoidDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.HardTanhDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.LeakyReLUDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.RationalTanhDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.RectifiedTanhDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.SELUDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.SoftSignDerivative;

public enum Activation {
    CUBE,
    ELU,
    HARDSIGMOID,
    HARDTANH,
    IDENTITY,
    LEAKYRELU,
    RATIONALTANH,
    RELU,
    RRELU,
    SIGMOID,
    SOFTMAX,
    SOFTPLUS,
    SOFTSIGN,
    TANH,
    RECTIFIEDTANH,
    SELU,
    SWISH,
    RATANH;


    public IActivation getActivationFunction() {
        switch (this) {
            case CUBE: {
                return new ActivationCube();
            }
            case ELU: {
                return new ActivationELU();
            }
            case HARDSIGMOID: {
                return new ActivationHardSigmoid();
            }
            case HARDTANH: {
                return new ActivationHardTanH();
            }
            case IDENTITY: {
                return new ActivationIdentity();
            }
            case LEAKYRELU: {
                return new ActivationLReLU();
            }
            case RATIONALTANH: {
                return new ActivationRationalTanh();
            }
            case RECTIFIEDTANH: {
                return new ActivationRectifiedTanh();
            }
            case RELU: {
                return new ActivationReLU();
            }
            case SELU: {
                return new ActivationSELU();
            }
            case SWISH: {
                return new ActivationSwish();
            }
            case RRELU: {
                return new ActivationRReLU();
            }
            case SIGMOID: {
                return new ActivationSigmoid();
            }
            case SOFTMAX: {
                return new ActivationSoftmax();
            }
            case SOFTPLUS: {
                return new ActivationSoftPlus();
            }
            case SOFTSIGN: {
                return new ActivationSoftSign();
            }
            case TANH: {
                return new ActivationTanH();
            }
            case RATANH: {
                return new ActivationRATanh();
            }
        }
        throw new UnsupportedOperationException("Unknown or not supported activation function: " + (Object)((Object)this));
    }

    public static Activation fromString(String string) {
        return Activation.valueOf(string.toUpperCase());
    }

    public SDVariable asSameDiff(SameDiff sameDiff, SDVariable sDVariable) {
        return this.asSameDiff(null, sameDiff, sDVariable);
    }

    public SDVariable asSameDiff(String string, SameDiff sameDiff, SDVariable sDVariable) {
        switch (this) {
            case CUBE: {
                return sameDiff.pow(string, sDVariable, 3.0);
            }
            case ELU: {
                return sameDiff.elu(string, sDVariable);
            }
            case HARDTANH: {
                return sameDiff.hardTanh(string, sDVariable);
            }
            case IDENTITY: {
                return sDVariable;
            }
            case LEAKYRELU: {
                return sameDiff.leakyRelu(string, sDVariable, 0.0);
            }
            case RELU: {
                return sameDiff.relu(string, sDVariable, 0.0);
            }
            case SIGMOID: {
                return sameDiff.sigmoid(string, sDVariable);
            }
            case SOFTMAX: {
                return sameDiff.softmax(string, sDVariable);
            }
            case SOFTPLUS: {
                return sameDiff.softplus(string, sDVariable);
            }
            case SOFTSIGN: {
                return sameDiff.softsign(string, sDVariable);
            }
            case TANH: {
                return sameDiff.tanh(string, sDVariable);
            }
        }
        throw new UnsupportedOperationException("Activation function not yet supported: " + (Object)((Object)this));
    }

    public TransformOp asTransform(INDArray iNDArray, boolean bl) {
        if (bl) {
            iNDArray = iNDArray.dup();
        }
        switch (this) {
            case CUBE: {
                return new Cube(iNDArray);
            }
            case ELU: {
                return new ELU(iNDArray);
            }
            case HARDSIGMOID: {
                return new HardSigmoid(iNDArray);
            }
            case HARDTANH: {
                return new HardTanh(iNDArray);
            }
            case IDENTITY: {
                return new OldIdentity(iNDArray);
            }
            case LEAKYRELU: {
                return new LeakyReLU(iNDArray);
            }
            case RATIONALTANH: {
                return new RationalTanh(iNDArray);
            }
            case RELU: {
                return new RectifedLinear(iNDArray);
            }
            case SIGMOID: {
                return new Sigmoid(iNDArray);
            }
            case SOFTMAX: {
                return new OldSoftMax(iNDArray);
            }
            case SOFTPLUS: {
                return new SoftPlus(iNDArray);
            }
            case SOFTSIGN: {
                return new SoftSign(iNDArray);
            }
            case TANH: {
                return new Tanh(iNDArray);
            }
            case RECTIFIEDTANH: {
                return new RectifiedTanh(iNDArray);
            }
            case SELU: {
                return new SELU(iNDArray);
            }
            case SWISH: {
                return new Swish(iNDArray);
            }
        }
        throw new UnsupportedOperationException("Not supported via this method: " + (Object)((Object)this));
    }

    public Op asTransformDerivative(INDArray iNDArray, boolean bl) {
        if (bl) {
            iNDArray = iNDArray.dup();
        }
        switch (this) {
            case CUBE: {
                return new CubeDerivative(iNDArray);
            }
            case ELU: {
                return new ELUDerivative(iNDArray);
            }
            case HARDSIGMOID: {
                return new HardSigmoidDerivative(iNDArray);
            }
            case HARDTANH: {
                return new HardTanhDerivative(iNDArray);
            }
            case LEAKYRELU: {
                return new LeakyReLUDerivative(iNDArray);
            }
            case RATIONALTANH: {
                return new RationalTanhDerivative(iNDArray);
            }
            case SIGMOID: {
                return new SigmoidDerivative(iNDArray);
            }
            case SOFTPLUS: {
                return new Sigmoid(iNDArray);
            }
            case SOFTSIGN: {
                return new SoftSignDerivative(iNDArray);
            }
            case TANH: {
                return new TanhDerivative(iNDArray);
            }
            case RECTIFIEDTANH: {
                return new RectifiedTanhDerivative(iNDArray);
            }
            case SELU: {
                return new SELUDerivative(iNDArray);
            }
            case SWISH: {
                return new SwishDerivative(iNDArray);
            }
            case SOFTMAX: {
                return new SoftMaxDerivative(iNDArray);
            }
            case IDENTITY: {
                return new ScalarSet(iNDArray, (Number)1.0);
            }
            case RELU: {
                return new Step(iNDArray);
            }
        }
        throw new UnsupportedOperationException("Not supported via this method: " + (Object)((Object)this));
    }
}

