/*
 * Decompiled with CFR 0.152.
 */
package ai.lum.odinson.extra;

import ai.lum.common.ConfigFactory$;
import ai.lum.common.ConfigUtils;
import ai.lum.common.ConfigUtils$;
import ai.lum.odinson.Document;
import ai.lum.odinson.Field;
import ai.lum.odinson.GraphField;
import ai.lum.odinson.GraphField$;
import ai.lum.odinson.Sentence;
import ai.lum.odinson.TokensField;
import ai.lum.odinson.TokensField$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.UUID;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;

public final class ProcessorsUtils$ {
    public static ProcessorsUtils$ MODULE$;
    private final Config config;
    private final String documentIdField;
    private final String rawTokenField;
    private final String wordTokenField;
    private final String lemmaTokenField;
    private final String posTagTokenField;
    private final String chunkTokenField;
    private final String entityTokenField;
    private final String dependenciesField;

    static {
        new ProcessorsUtils$();
    }

    public Config config() {
        return this.config;
    }

    public String documentIdField() {
        return this.documentIdField;
    }

    public String rawTokenField() {
        return this.rawTokenField;
    }

    public String wordTokenField() {
        return this.wordTokenField;
    }

    public String lemmaTokenField() {
        return this.lemmaTokenField;
    }

    public String posTagTokenField() {
        return this.posTagTokenField;
    }

    public String chunkTokenField() {
        return this.chunkTokenField;
    }

    public String entityTokenField() {
        return this.entityTokenField;
    }

    public String dependenciesField() {
        return this.dependenciesField;
    }

    public Document convertDocument(org.clulab.processors.Document d) {
        String id = (String)d.id().getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString());
        Seq<Field> metadata = this.mkMetadata(d);
        Seq<Sentence> sentences = this.mkSentences(d);
        return new Document(id, metadata, sentences);
    }

    public Seq<Field> mkMetadata(org.clulab.processors.Document d) {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Seq<Sentence> mkSentences(org.clulab.processors.Document d) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])d.sentences())).map((Function1 & Serializable & scala.Serializable)s -> MODULE$.convertSentence((org.clulab.processors.Sentence)s), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Sentence convertSentence(org.clulab.processors.Sentence s) {
        TokensField raw = new TokensField(this.rawTokenField(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])s.raw()), true);
        TokensField word = new TokensField(this.wordTokenField(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])s.words()), TokensField$.MODULE$.apply$default$3());
        Option maybeTag = s.tags().map((Function1 & Serializable & scala.Serializable)tags -> new TokensField(MODULE$.posTagTokenField(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])tags), TokensField$.MODULE$.apply$default$3()));
        Option maybeLemma = s.lemmas().map((Function1 & Serializable & scala.Serializable)lemmas -> new TokensField(MODULE$.lemmaTokenField(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])lemmas), TokensField$.MODULE$.apply$default$3()));
        Option maybeEntity = s.entities().map((Function1 & Serializable & scala.Serializable)entities -> new TokensField(MODULE$.entityTokenField(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])entities), TokensField$.MODULE$.apply$default$3()));
        Option maybeChunk = s.chunks().map((Function1 & Serializable & scala.Serializable)chunks -> new TokensField(MODULE$.chunkTokenField(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])chunks), TokensField$.MODULE$.apply$default$3()));
        Option maybeDeps = s.dependencies().map((Function1 & Serializable & scala.Serializable)g -> new GraphField(MODULE$.dependenciesField(), (Seq)g.allEdges(), g.roots(), GraphField$.MODULE$.apply$default$4()));
        Some some = new Some((Object)raw);
        Some some2 = new Some((Object)word);
        List fields = new .colon.colon((Object)maybeTag, (List)new .colon.colon((Object)maybeLemma, (List)new .colon.colon((Object)maybeEntity, (List)new .colon.colon((Object)maybeChunk, (List)new .colon.colon((Object)maybeDeps, (List)Nil$.MODULE$))))).$colon$colon((Object)some2).$colon$colon((Object)some);
        return new Sentence(s.size(), (Seq)fields.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)));
    }

    private ProcessorsUtils$() {
        MODULE$ = this;
        this.config = ConfigFactory$.MODULE$.load(ConfigFactory$.MODULE$.load$default$1(), ConfigFactory$.MODULE$.load$default$2(), ConfigFactory$.MODULE$.load$default$3(), ConfigFactory$.MODULE$.load$default$4());
        this.documentIdField = (String)ConfigUtils.LumAICommonConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.LumAICommonConfigWrapper(this.config()), "odinson.index.documentIdField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.rawTokenField = (String)ConfigUtils.LumAICommonConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.LumAICommonConfigWrapper(this.config()), "odinson.index.rawTokenField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.wordTokenField = (String)ConfigUtils.LumAICommonConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.LumAICommonConfigWrapper(this.config()), "odinson.index.wordTokenField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.lemmaTokenField = (String)ConfigUtils.LumAICommonConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.LumAICommonConfigWrapper(this.config()), "odinson.index.lemmaTokenField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.posTagTokenField = (String)ConfigUtils.LumAICommonConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.LumAICommonConfigWrapper(this.config()), "odinson.index.posTagTokenField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.chunkTokenField = (String)ConfigUtils.LumAICommonConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.LumAICommonConfigWrapper(this.config()), "odinson.index.chunkTokenField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.entityTokenField = (String)ConfigUtils.LumAICommonConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.LumAICommonConfigWrapper(this.config()), "odinson.index.entityTokenField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.dependenciesField = (String)ConfigUtils.LumAICommonConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.LumAICommonConfigWrapper(this.config()), "odinson.index.dependenciesField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
    }
}

