/*
 * Decompiled with CFR 0.152.
 */
package ai.lum.odinson.extra;

import ai.lum.common.ConfigUtils;
import ai.lum.common.ConfigUtils$;
import ai.lum.odinson.BuildInfo$;
import ai.lum.odinson.ExtractorEngine;
import ai.lum.odinson.ExtractorEngine$;
import ai.lum.odinson.digraph.Vocabulary;
import ai.lum.odinson.extra.Shell$delayedInit$body;
import ai.lum.odinson.lucene.OdinResults;
import ai.lum.odinson.lucene.Span;
import ai.lum.odinson.lucene.search.OdinsonScoreDoc;
import ai.lum.odinson.lucene.search.highlight.ConsoleHighlighter$;
import ai.lum.odinson.utils.ConfigFactory$;
import com.typesafe.config.Config;
import java.io.File;
import java.io.Serializable;
import java.text.NumberFormat;
import jline.console.ConsoleReader;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import scala.App;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class Shell$
implements App {
    public static Shell$ MODULE$;
    private ListMap<String, String> commands;
    private Config config;
    private int maxMatchesDisplay;
    private String prompt;
    private FileHistory history;
    private NumberFormat intFormatter;
    private NumberFormat numFormatter;
    private ExtractorEngine extractorEngine;
    private Vocabulary dependenciesVocabulary;
    private Vector<String> dependencies;
    private List<String> autoCompleteOptions;
    private ArgumentCompleter completer;
    private ConsoleReader reader;
    private Regex matchNumResultsToDisplay;
    private Regex matchSettingsScope;
    private String query;
    private OdinsonScoreDoc after;
    private int shownHits;
    private int totalHits;
    private String name;
    private String version;
    private String gitCommit;
    private String gitDirty;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new Shell$();
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    public ListMap<String, String> commands() {
        return this.commands;
    }

    public Config config() {
        return this.config;
    }

    public int maxMatchesDisplay() {
        return this.maxMatchesDisplay;
    }

    public void maxMatchesDisplay_$eq(int x$1) {
        this.maxMatchesDisplay = x$1;
    }

    public String prompt() {
        return this.prompt;
    }

    public FileHistory history() {
        return this.history;
    }

    public NumberFormat intFormatter() {
        return this.intFormatter;
    }

    public NumberFormat numFormatter() {
        return this.numFormatter;
    }

    public String fmt(int n) {
        return this.intFormatter().format(n);
    }

    public String fmt(float n) {
        return this.numFormatter().format(n);
    }

    public ExtractorEngine extractorEngine() {
        return this.extractorEngine;
    }

    public Vocabulary dependenciesVocabulary() {
        return this.dependenciesVocabulary;
    }

    public Vector<String> dependencies() {
        return this.dependencies;
    }

    public List<String> autoCompleteOptions() {
        return this.autoCompleteOptions;
    }

    public ArgumentCompleter completer() {
        return this.completer;
    }

    public ConsoleReader reader() {
        return this.reader;
    }

    public Regex matchNumResultsToDisplay() {
        return this.matchNumResultsToDisplay;
    }

    public Regex matchSettingsScope() {
        return this.matchSettingsScope;
    }

    public String query() {
        return this.query;
    }

    public void query_$eq(String x$1) {
        this.query = x$1;
    }

    public OdinsonScoreDoc after() {
        return this.after;
    }

    public void after_$eq(OdinsonScoreDoc x$1) {
        this.after = x$1;
    }

    public int shownHits() {
        return this.shownHits;
    }

    public void shownHits_$eq(int x$1) {
        this.shownHits = x$1;
    }

    public int totalHits() {
        return this.totalHits;
    }

    public void totalHits_$eq(int x$1) {
        this.totalHits = x$1;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public String gitCommit() {
        return this.gitCommit;
    }

    public String gitDirty() {
        return this.gitDirty;
    }

    public void printHelp() {
        Predef$.MODULE$.println((Object)"These are the commands at your disposal:\n");
        int longest = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.commands().keys().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.length()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        this.commands().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Shell$.$anonfun$printHelp$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            Shell$.$anonfun$printHelp$3(longest, x$2);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println();
    }

    public void printBuildInfo() {
        Predef$.MODULE$.println((Object)new StringBuilder(6).append("Name: ").append(BuildInfo$.MODULE$.name()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(9).append("Version: ").append(BuildInfo$.MODULE$.version()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(12).append("Build date: ").append(BuildInfo$.MODULE$.builtAtString()).toString());
        Predef$.MODULE$.print((Object)new StringBuilder(8).append("Commit: ").append(BuildInfo$.MODULE$.gitHeadCommit()).toString());
        if (BuildInfo$.MODULE$.gitUncommittedChanges()) {
            Predef$.MODULE$.print((Object)" (with uncommitted changes)");
        }
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("Scala version: ").append(BuildInfo$.MODULE$.scalaVersion()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("Sbt version: ").append(BuildInfo$.MODULE$.sbtVersion()).toString());
        Predef$.MODULE$.println((Object)"Dependencies:");
        BuildInfo$.MODULE$.libraryDependencies().foreach((Function1 & Serializable & scala.Serializable)s -> {
            Predef$.MODULE$.println((Object)new StringBuilder(2).append("  ").append(s).toString());
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)"Scalac options:");
        BuildInfo$.MODULE$.scalacOptions().foreach((Function1 & Serializable & scala.Serializable)s -> {
            Predef$.MODULE$.println((Object)new StringBuilder(2).append("  ").append(s).toString());
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println();
    }

    public void printSettings() {
        this.printSettings(this.config());
    }

    public void printSettings(String s) {
        this.printSettings((Config)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), s, (ConfigUtils.ConfigFieldReader)ConfigUtils.ConfigConfigFieldReader$.MODULE$));
    }

    public void printSettings(Config c) {
        Predef$.MODULE$.println((Object)c.root().render());
    }

    public void search(int n) {
        long start = System.currentTimeMillis();
        OdinResults results = this.extractorEngine().query(this.query(), n);
        float duration = (float)((double)(System.currentTimeMillis() - start) / 1000.0);
        this.after_$eq((OdinsonScoreDoc)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])results.scoreDocs())).lastOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> null));
        this.totalHits_$eq(results.totalHits());
        this.shownHits_$eq(package$.MODULE$.min(n, this.totalHits()));
        this.printResultsPage(results, 1, this.totalHits(), duration);
    }

    public void printMore(int n) {
        if (this.after() == null) {
            Predef$.MODULE$.println((Object)"there is no active query");
            return;
        }
        if (this.shownHits() == this.totalHits()) {
            Predef$.MODULE$.println((Object)"no more results");
            return;
        }
        long start = System.currentTimeMillis();
        OdinResults results = this.extractorEngine().query(this.query(), n, this.after());
        float duration = (float)((double)(System.currentTimeMillis() - start) / 1000.0);
        this.after_$eq((OdinsonScoreDoc)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])results.scoreDocs())).lastOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> null));
        if (this.after() == null) {
            Predef$.MODULE$.println((Object)"no more results");
            return;
        }
        Predef$.MODULE$.assert(this.totalHits() == results.totalHits());
        this.printResultsPage(results, this.shownHits() + 1, this.totalHits(), duration);
        this.shownHits_$eq(this.shownHits() + package$.MODULE$.min(n, this.totalHits()));
    }

    public void printResultsPage(OdinResults results, int start, int total, float duration) {
        if (total == 0) {
            Predef$.MODULE$.println((Object)"no matches");
            return;
        }
        int end = start + results.scoreDocs().length - 1;
        Predef$.MODULE$.println((Object)new StringBuilder(26).append("found ").append(this.fmt(total)).append(" matches in ").append(this.fmt(duration)).append(" seconds").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("showing ").append(this.fmt(start)).append(" to ").append(this.fmt(end)).append("\n").toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])results.scoreDocs())).foreach((Function1 & Serializable & scala.Serializable)hit -> {
            Shell$.$anonfun$printResultsPage$1(hit);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$printHelp$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$printHelp$3(int longest$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String cmd = (String)tuple2._1();
        String msg = (String)tuple2._2();
        String pad = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(longest$1 - cmd.length());
        Predef$.MODULE$.println((Object)new StringBuilder(5).append(" ").append(cmd).append(pad).append(" => ").append(msg).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$printResultsPage$1(OdinsonScoreDoc hit) {
        Document doc = MODULE$.extractorEngine().doc(hit.doc);
        String docID = doc.getField("docId").stringValue();
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("Doc ").append(docID).append(" (score = ").append(hit.score).append(")").toString());
        Vector spans = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hit.matches())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.span(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Span.class))))).toVector();
        Vector captures = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hit.matches())).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.captures(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toVector();
        IndexReader x$1 = MODULE$.extractorEngine().indexReader();
        int x$2 = hit.doc;
        Vector x$32 = spans;
        Vector x$42 = captures;
        String x$5 = ConsoleHighlighter$.MODULE$.highlight$default$3();
        Analyzer x$6 = ConsoleHighlighter$.MODULE$.highlight$default$4();
        String x$7 = ConsoleHighlighter$.MODULE$.highlight$default$7();
        String x$8 = ConsoleHighlighter$.MODULE$.highlight$default$8();
        String x$9 = ConsoleHighlighter$.MODULE$.highlight$default$9();
        String res = ConsoleHighlighter$.MODULE$.highlight(x$1, x$2, x$5, x$6, (Seq)x$32, (Seq)x$42, x$7, x$8, x$9);
        Predef$.MODULE$.println((Object)res);
        Predef$.MODULE$.println();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void delayedEndpoint$ai$lum$odinson$extra$Shell$1() {
        this.commands = (ListMap)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":help"), (Object)"show commands"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":exit"), (Object)"exit system"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":buildinfo"), (Object)"build information"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":settings"), (Object)"show settings (accepts optional scope)"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":corpus"), (Object)"show some corpus statistics"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":more"), (Object)"display a new results page"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":display"), (Object)"specify the maximum number of matches to display (ex. :display 10)")}));
        this.config = ConfigFactory$.MODULE$.load(ConfigFactory$.MODULE$.load$default$1(), ConfigFactory$.MODULE$.load$default$2(), ConfigFactory$.MODULE$.load$default$3(), ConfigFactory$.MODULE$.load$default$4());
        this.maxMatchesDisplay = BoxesRunTime.unboxToInt((Object)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.shell.maxMatchesDisplay", (ConfigUtils.ConfigFieldReader)ConfigUtils.IntConfigFieldReader$.MODULE$));
        this.prompt = (String)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.shell.prompt", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.history = new FileHistory((File)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.shell.history", (ConfigUtils.ConfigFieldReader)ConfigUtils.FileConfigFieldReader$.MODULE$));
        scala.sys.package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.history().flush());
        this.intFormatter = NumberFormat.getIntegerInstance();
        this.numFormatter = NumberFormat.getInstance();
        this.numFormatter().setMaximumFractionDigits(2);
        this.extractorEngine = ExtractorEngine$.MODULE$.fromConfig("odinson");
        this.dependenciesVocabulary = this.extractorEngine().compiler().dependenciesVocabulary();
        this.dependencies = (Vector)this.dependenciesVocabulary().terms().flatMap((Function1 & Serializable & scala.Serializable)dep -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(1).append(">").append((String)dep).toString(), new StringBuilder(1).append("<").append((String)dep).toString()})), Vector$.MODULE$.canBuildFrom());
        this.autoCompleteOptions = (List)this.dependencies().toList().$plus$plus((GenTraversableOnce)this.commands().keys().toList(), List$.MODULE$.canBuildFrom());
        this.completer = new ArgumentCompleter(new Completer[]{new StringsCompleter((String[])this.autoCompleteOptions().toArray(ClassTag$.MODULE$.apply(String.class)))});
        this.completer().setStrict(false);
        this.reader = new ConsoleReader();
        this.reader().setPrompt(this.prompt());
        this.reader().setHistory((History)this.history());
        this.reader().setExpandEvents(false);
        this.reader().addCompleter((Completer)this.completer());
        this.matchNumResultsToDisplay = new StringOps(Predef$.MODULE$.augmentString("^:display\\s+(\\d+)$")).r();
        this.matchSettingsScope = new StringOps(Predef$.MODULE$.augmentString("^:settings\\s+([\\w\\.-]+)$")).r();
        this.query = null;
        this.after = null;
        this.shownHits = 0;
        this.totalHits = 0;
        this.name = BuildInfo$.MODULE$.name();
        this.version = BuildInfo$.MODULE$.version();
        this.gitCommit = (String)new StringOps(Predef$.MODULE$.augmentString(BuildInfo$.MODULE$.gitHeadCommit())).take(7);
        this.gitDirty = BuildInfo$.MODULE$.gitUncommittedChanges() ? "*" : "";
        Predef$.MODULE$.println((Object)new StringBuilder(16).append("Welcome to ").append(this.name()).append(" v").append(this.version()).append(" (").append(this.gitCommit()).append(this.gitDirty()).append(")").toString());
        Predef$.MODULE$.println((Object)"Type :help for a list of commands");
        try {
            boolean running = true;
            while (running) {
                try {
                    BoxedUnit boxedUnit;
                    String line = this.reader().readLine();
                    if (line == null) {
                        Predef$.MODULE$.println((Object)":exit");
                        running = false;
                        continue;
                    }
                    String string = line.trim();
                    if ("".equals(string)) {
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (":help".equals(string)) {
                        this.printHelp();
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (":exit".equals(string)) {
                        running = false;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (":buildinfo".equals(string)) {
                        this.printBuildInfo();
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (":settings".equals(string)) {
                        this.printSettings();
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (":more".equals(string)) {
                        this.printMore(this.maxMatchesDisplay());
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (":corpus".equals(string)) {
                        Predef$.MODULE$.println((Object)new StringBuilder(21).append("Number of sentences: ").append(this.fmt(this.extractorEngine().numDocs())).toString());
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    Option option = this.matchSettingsScope().unapplySeq((CharSequence)string);
                    if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                        String s = (String)((LinearSeqOptimized)option.get()).apply(0);
                        this.printSettings(s);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    Option option2 = this.matchNumResultsToDisplay().unapplySeq((CharSequence)string);
                    if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                        String n = (String)((LinearSeqOptimized)option2.get()).apply(0);
                        this.maxMatchesDisplay_$eq(new StringOps(Predef$.MODULE$.augmentString(n)).toInt());
                        Predef$.MODULE$.println((Object)new StringBuilder(42).append("will now display a maximum of ").append(this.maxMatchesDisplay()).append(" matches ...").toString());
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (string.startsWith(":")) {
                        Predef$.MODULE$.println((Object)new StringBuilder(21).append("Unrecognized command ").append(string).toString());
                        Predef$.MODULE$.println((Object)"Type :help for a list of commands");
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (string.startsWith("#")) {
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    this.query_$eq(string);
                    this.search(this.maxMatchesDisplay());
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) throw throwable;
                    Throwable e = (Throwable)option.get();
                    e.printStackTrace();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                    return;
                }
            }
        }
        finally {
            this.reader().getTerminal().restore();
            this.reader().shutdown();
        }
    }

    private Shell$() {
        MODULE$ = this;
        App.$init$((App)this);
        this.delayedInit((Function0<BoxedUnit>)new Shell$delayedInit$body(this));
    }
}

