/*
 * Decompiled with CFR 0.152.
 */
package ai.lum.odinson.extra;

import ai.lum.common.ConfigUtils;
import ai.lum.common.ConfigUtils$;
import ai.lum.common.FileUtils;
import ai.lum.common.FileUtils$;
import ai.lum.common.Serializer$;
import ai.lum.labrador.DOI;
import ai.lum.labrador.DateTime;
import ai.lum.labrador.DocumentMetadata;
import ai.lum.labrador.PMID;
import ai.lum.odinson.OdinsonIndexWriter;
import ai.lum.odinson.OdinsonIndexWriter$;
import ai.lum.odinson.digraph.DirectedGraph;
import ai.lum.odinson.extra.DocUtils$;
import ai.lum.odinson.extra.GzipUtils$;
import ai.lum.odinson.extra.IndexDocuments$delayedInit$body;
import ai.lum.odinson.lucene.analysis.DependencyTokenStream;
import ai.lum.odinson.lucene.analysis.NormalizedTokenStream;
import ai.lum.odinson.lucene.analysis.OdinsonTokenStream;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.clulab.processors.Document;
import org.clulab.processors.Sentence;
import org.clulab.serialization.json.JSONSerializer$;
import org.json4s.DefaultFormats;
import org.json4s.DefaultFormats$;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.App;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.parallel.ParIterableLike;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class IndexDocuments$
implements App,
LazyLogging {
    public static IndexDocuments$ MODULE$;
    private Config config;
    private File indexDir;
    private File docsDir;
    private String documentIdField;
    private String sentenceIdField;
    private String sentenceLengthField;
    private String rawTokenField;
    private String wordTokenField;
    private String normalizedTokenField;
    private String lemmaTokenField;
    private String posTagTokenField;
    private String chunkTokenField;
    private String entityTokenField;
    private String incomingTokenField;
    private String outgoingTokenField;
    private String dependenciesField;
    private int sortedDocValuesFieldMaxSize;
    private int maxNumberOfTokensPerSentence;
    private boolean synchronizeOrderWithDocumentId;
    private boolean storeSentenceJson;
    private DefaultFormats formats;
    private OdinsonIndexWriter writer;
    private String SUPPORTED_EXTENSIONS;
    private GenSeq<File> documentFiles;
    private Logger logger;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;
    private volatile boolean bitmap$0;

    static {
        new IndexDocuments$();
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    private Logger logger$lzycompute() {
        IndexDocuments$ indexDocuments$ = this;
        synchronized (indexDocuments$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    public Config config() {
        return this.config;
    }

    public File indexDir() {
        return this.indexDir;
    }

    public File docsDir() {
        return this.docsDir;
    }

    public String documentIdField() {
        return this.documentIdField;
    }

    public String sentenceIdField() {
        return this.sentenceIdField;
    }

    public String sentenceLengthField() {
        return this.sentenceLengthField;
    }

    public String rawTokenField() {
        return this.rawTokenField;
    }

    public String wordTokenField() {
        return this.wordTokenField;
    }

    public String normalizedTokenField() {
        return this.normalizedTokenField;
    }

    public String lemmaTokenField() {
        return this.lemmaTokenField;
    }

    public String posTagTokenField() {
        return this.posTagTokenField;
    }

    public String chunkTokenField() {
        return this.chunkTokenField;
    }

    public String entityTokenField() {
        return this.entityTokenField;
    }

    public String incomingTokenField() {
        return this.incomingTokenField;
    }

    public String outgoingTokenField() {
        return this.outgoingTokenField;
    }

    public String dependenciesField() {
        return this.dependenciesField;
    }

    public int sortedDocValuesFieldMaxSize() {
        return this.sortedDocValuesFieldMaxSize;
    }

    public int maxNumberOfTokensPerSentence() {
        return this.maxNumberOfTokensPerSentence;
    }

    public boolean synchronizeOrderWithDocumentId() {
        return this.synchronizeOrderWithDocumentId;
    }

    public boolean storeSentenceJson() {
        return this.storeSentenceJson;
    }

    public DefaultFormats formats() {
        return this.formats;
    }

    public OdinsonIndexWriter writer() {
        return this.writer;
    }

    public String SUPPORTED_EXTENSIONS() {
        return this.SUPPORTED_EXTENSIONS;
    }

    public GenSeq<File> documentFiles() {
        return this.documentFiles;
    }

    public Tuple2<Document, Option<DocumentMetadata>> deserializeDoc(File f) {
        Tuple2 tuple2;
        String string = f.getName().toLowerCase();
        if (string.endsWith(".json")) {
            Document doc = JSONSerializer$.MODULE$.toDocument(f);
            tuple2 = new Tuple2((Object)doc, (Object)None$.MODULE$);
        } else if (string.endsWith(".ser")) {
            Document doc = (Document)Serializer$.MODULE$.deserialize(f);
            File mdFile = new File(f.getCanonicalPath().replaceAll("\\.ser", ".metadata.ser"));
            None$ md = mdFile.exists() ? new Some((Object)Serializer$.MODULE$.deserialize(mdFile)) : None$.MODULE$;
            tuple2 = new Tuple2((Object)doc, (Object)md);
        } else if (string.endsWith("json.gz")) {
            String contents = GzipUtils$.MODULE$.uncompress(f);
            JsonAST.JValue jast = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(contents), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
            Document doc = JSONSerializer$.MODULE$.toDocument(jast);
            tuple2 = new Tuple2((Object)doc, (Object)None$.MODULE$);
        } else {
            throw new Exception(new StringBuilder(79).append("Cannot deserialize ").append(f.getName()).append(" to org.clulab.processors.Document. Unsupported extension '").append(string).append("'").toString());
        }
        return tuple2;
    }

    public String generateUUID() {
        return UUID.randomUUID().toString();
    }

    public Seq<org.apache.lucene.document.Document> mkDocumentBlock(Document d, Option<DocumentMetadata> metadata) {
        String docId = (String)d.id().getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.generateUUID());
        ArrayBuffer block = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])d.sentences())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)IndexDocuments$.$anonfun$mkDocumentBlock$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x$5;
            if (tuple2 != null) {
                Sentence s = (Sentence)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (s.size() <= MODULE$.maxNumberOfTokensPerSentence()) {
                    boxedUnit = block.$plus$eq((Object)MODULE$.mkSentenceDoc(s, docId, ((Object)BoxesRunTime.boxToInteger((int)i)).toString()));
                } else if (MODULE$.logger().underlying().isWarnEnabled()) {
                    MODULE$.logger().underlying().warn("skipping sentence with {} tokens", new Object[]{BoxesRunTime.boxToInteger((int)s.size())});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        block.$plus$eq((Object)this.mkParentDoc(docId, metadata));
        return block;
    }

    public org.apache.lucene.document.Document mkParentDoc(String docId, Option<DocumentMetadata> metadata) {
        org.apache.lucene.document.Document parent;
        block4: {
            None$ none$;
            parent = new org.apache.lucene.document.Document();
            parent.add((IndexableField)new StringField("type", "parent", Field.Store.NO));
            parent.add((IndexableField)new StringField("docId", docId, Field.Store.YES));
            if (!metadata.nonEmpty()) break block4;
            DocumentMetadata md = (DocumentMetadata)metadata.get();
            Seq authors = (Seq)md.authors().map((Function1 & Serializable & scala.Serializable)a -> new StringBuilder(1).append(a.givenName()).append(" ").append(a.surName()).toString(), Seq$.MODULE$.canBuildFrom());
            Option doi2 = md.doi().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.doi());
            Option url2 = md.doi().nonEmpty() ? ((DOI)md.doi().get()).url() : (md.pmid().nonEmpty() ? ((PMID)md.pmid().get()).url() : None$.MODULE$);
            Option option = md.publicationDate();
            if (None$.MODULE$.equals(option)) {
                none$ = None$.MODULE$;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                DateTime pd = (DateTime)some.value();
                none$ = pd.year();
            } else {
                throw new MatchError((Object)option);
            }
            None$ pubYear = none$;
            authors.foreach((Function1 & Serializable & scala.Serializable)author -> {
                parent.add((IndexableField)new TextField("author", author, Field.Store.YES));
                return BoxedUnit.UNIT;
            });
            md.title().foreach((Function1 & Serializable & scala.Serializable)title -> {
                parent.add((IndexableField)new TextField("title", title, Field.Store.YES));
                return BoxedUnit.UNIT;
            });
            md.journal().foreach((Function1 & Serializable & scala.Serializable)v -> {
                parent.add((IndexableField)new TextField("venue", v, Field.Store.YES));
                return BoxedUnit.UNIT;
            });
            pubYear.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> {
                parent.add((IndexableField)new IntPoint("year", new int[]{y}));
                parent.add((IndexableField)new StoredField("year", y));
            });
            doi2.foreach((Function1 & Serializable & scala.Serializable)doi -> {
                parent.add((IndexableField)new TextField("doi", doi, Field.Store.YES));
                return BoxedUnit.UNIT;
            });
            url2.foreach((Function1 & Serializable & scala.Serializable)url -> {
                parent.add((IndexableField)new TextField("url", url, Field.Store.YES));
                return BoxedUnit.UNIT;
            });
        }
        return parent;
    }

    public org.apache.lucene.document.Document mkSentenceDoc(Sentence s, String docId, String sentId) {
        org.apache.lucene.document.Document sent;
        block10: {
            BoxedUnit boxedUnit;
            sent = new org.apache.lucene.document.Document();
            sent.add((IndexableField)new StoredField(this.documentIdField(), docId));
            sent.add((IndexableField)new StoredField(this.sentenceIdField(), sentId));
            sent.add((IndexableField)new NumericDocValuesField(this.sentenceLengthField(), (long)s.size()));
            sent.add((IndexableField)new TextField(this.rawTokenField(), (TokenStream)new OdinsonTokenStream((Seq)Predef$.MODULE$.wrapRefArray((Object[])s.raw()))));
            sent.add((IndexableField)new TextField(this.wordTokenField(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.words())).mkString(" "), Field.Store.YES));
            sent.add((IndexableField)new TextField(this.normalizedTokenField(), (TokenStream)new NormalizedTokenStream((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{Predef$.MODULE$.wrapRefArray((Object[])s.raw()), Predef$.MODULE$.wrapRefArray((Object[])s.words())}))));
            if (s.tags().isDefined()) {
                sent.add((IndexableField)new TextField(this.posTagTokenField(), (TokenStream)new OdinsonTokenStream((Seq)Predef$.MODULE$.wrapRefArray((Object[])s.tags().get()))));
            }
            if (s.lemmas().isDefined()) {
                sent.add((IndexableField)new TextField(this.lemmaTokenField(), (TokenStream)new OdinsonTokenStream((Seq)Predef$.MODULE$.wrapRefArray((Object[])s.lemmas().get()))));
            }
            if (s.entities().isDefined()) {
                sent.add((IndexableField)new TextField(this.entityTokenField(), (TokenStream)new OdinsonTokenStream((Seq)Predef$.MODULE$.wrapRefArray((Object[])s.entities().get()))));
            }
            if (s.chunks().isDefined()) {
                sent.add((IndexableField)new TextField(this.chunkTokenField(), (TokenStream)new OdinsonTokenStream((Seq)Predef$.MODULE$.wrapRefArray((Object[])s.chunks().get()))));
            }
            if (s.dependencies().isDefined()) {
                org.clulab.struct.DirectedGraph deps = (org.clulab.struct.DirectedGraph)s.dependencies().get();
                sent.add((IndexableField)new TextField(this.incomingTokenField(), (TokenStream)new DependencyTokenStream(deps.incomingEdges())));
                sent.add((IndexableField)new TextField(this.outgoingTokenField(), (TokenStream)new DependencyTokenStream(deps.outgoingEdges())));
                DirectedGraph graph = this.writer().mkDirectedGraph(deps.incomingEdges(), deps.outgoingEdges(), (int[])deps.roots().toArray(ClassTag$.MODULE$.Int()));
                byte[] bytes = graph.toBytes();
                if (bytes.length <= this.sortedDocValuesFieldMaxSize()) {
                    sent.add((IndexableField)new SortedDocValuesField(this.dependenciesField(), new BytesRef(bytes)));
                    boxedUnit = BoxedUnit.UNIT;
                } else if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("serialized dependencies too big for storage: {} > {} bytes", new Object[]{BoxesRunTime.boxToInteger((int)bytes.length), BoxesRunTime.boxToInteger((int)this.sortedDocValuesFieldMaxSize())});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (!this.storeSentenceJson()) break block10;
            sent.add((IndexableField)new StoredField("json-binary", DocUtils$.MODULE$.sentenceToBytes(s)));
        }
        return sent;
    }

    public static final /* synthetic */ boolean $anonfun$documentFiles$1(File f) {
        return !f.getName().endsWith(".metadata.ser");
    }

    public static final /* synthetic */ int $anonfun$documentFiles$3(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$documentFiles$6(File f) {
        return !f.getName().endsWith(".metadata.ser");
    }

    public static final /* synthetic */ void $anonfun$new$1(File f) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple2<Document, Option<DocumentMetadata>> tuple2 = MODULE$.deserializeDoc(f);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Document doc = (Document)tuple2._1();
            Option md = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)doc, (Object)md);
            Tuple2 tuple23 = tuple22;
            Document doc2 = (Document)tuple23._1();
            Option md2 = (Option)tuple23._2();
            Seq<org.apache.lucene.document.Document> block = MODULE$.mkDocumentBlock(doc2, (Option<DocumentMetadata>)md2);
            MODULE$.writer().addDocuments(block);
        });
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Indexed {}", new Object[]{f.getName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (MODULE$.logger().underlying().isErrorEnabled()) {
                MODULE$.logger().underlying().error(new StringBuilder(16).append("Failed to index ").append(f.getName()).toString(), e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ boolean $anonfun$mkDocumentBlock$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public final void delayedEndpoint$ai$lum$odinson$extra$IndexDocuments$1() {
        GenSeq genSeq;
        this.config = ConfigFactory.load();
        this.indexDir = (File)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.indexDir", (ConfigUtils.ConfigFieldReader)ConfigUtils.FileConfigFieldReader$.MODULE$);
        this.docsDir = (File)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.docsDir", (ConfigUtils.ConfigFieldReader)ConfigUtils.FileConfigFieldReader$.MODULE$);
        this.documentIdField = (String)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.index.documentIdField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.sentenceIdField = (String)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.index.sentenceIdField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.sentenceLengthField = (String)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.index.sentenceLengthField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.rawTokenField = (String)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.index.rawTokenField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.wordTokenField = (String)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.index.wordTokenField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.normalizedTokenField = (String)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.index.normalizedTokenField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.lemmaTokenField = (String)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.index.lemmaTokenField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.posTagTokenField = (String)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.index.posTagTokenField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.chunkTokenField = (String)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.index.chunkTokenField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.entityTokenField = (String)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.index.entityTokenField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.incomingTokenField = (String)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.index.incomingTokenField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.outgoingTokenField = (String)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.index.outgoingTokenField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.dependenciesField = (String)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.index.dependenciesField", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        this.sortedDocValuesFieldMaxSize = BoxesRunTime.unboxToInt((Object)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.index.sortedDocValuesFieldMaxSize", (ConfigUtils.ConfigFieldReader)ConfigUtils.IntConfigFieldReader$.MODULE$));
        this.maxNumberOfTokensPerSentence = BoxesRunTime.unboxToInt((Object)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.index.maxNumberOfTokensPerSentence", (ConfigUtils.ConfigFieldReader)ConfigUtils.IntConfigFieldReader$.MODULE$));
        this.synchronizeOrderWithDocumentId = BoxesRunTime.unboxToBoolean((Object)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.index.synchronizeOrderWithDocumentId", (ConfigUtils.ConfigFieldReader)ConfigUtils.BooleanConfigFieldReader$.MODULE$));
        this.storeSentenceJson = BoxesRunTime.unboxToBoolean((Object)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.extra.storeSentenceJson", (ConfigUtils.ConfigFieldReader)ConfigUtils.BooleanConfigFieldReader$.MODULE$));
        this.formats = DefaultFormats$.MODULE$;
        this.writer = OdinsonIndexWriter$.MODULE$.fromConfig();
        this.SUPPORTED_EXTENSIONS = "(?i).*?\\.(ser|json)$";
        if (this.synchronizeOrderWithDocumentId()) {
            File qual$1 = FileUtils$.MODULE$.FileWrapper(this.docsDir());
            String x$1 = this.SUPPORTED_EXTENSIONS();
            boolean x$22 = true;
            boolean x$32 = FileUtils.FileWrapper$.MODULE$.listFilesByRegex$default$2$extension(qual$1);
            genSeq = (GenSeq)((TraversableLike)FileUtils.FileWrapper$.MODULE$.listFilesByRegex$extension(qual$1, x$1, x$32, x$22).withFilter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)IndexDocuments$.$anonfun$documentFiles$1(f))).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)((Document)MODULE$.deserializeDoc((File)f)._1()).id().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)IndexDocuments$.$anonfun$documentFiles$3(x$1))), f)).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> (Option)x$2._1(), Ordering$.MODULE$.Option((Ordering)Ordering.Int$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$3 -> (File)x$3._2(), Seq$.MODULE$.canBuildFrom());
        } else {
            File qual$2 = FileUtils$.MODULE$.FileWrapper(this.docsDir());
            String x$4 = this.SUPPORTED_EXTENSIONS();
            boolean x$5 = true;
            boolean x$6 = FileUtils.FileWrapper$.MODULE$.listFilesByRegex$default$2$extension(qual$2);
            genSeq = (GenSeq)((ParIterableLike)FileUtils.FileWrapper$.MODULE$.listFilesByRegex$extension(qual$2, x$4, x$6, x$5).toSeq().par()).withFilter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)IndexDocuments$.$anonfun$documentFiles$6(f)));
        }
        this.documentFiles = genSeq;
        this.documentFiles().foreach((Function1 & Serializable & scala.Serializable)f -> {
            IndexDocuments$.$anonfun$new$1(f);
            return BoxedUnit.UNIT;
        });
        this.writer().close();
    }

    private IndexDocuments$() {
        MODULE$ = this;
        App.$init$((App)this);
        LazyLogging.$init$((LazyLogging)this);
        this.delayedInit((Function0<BoxedUnit>)new IndexDocuments$delayedInit$body(this));
    }
}

