/*
 * Decompiled with CFR 0.152.
 */
package ai.lum.odinson.extra;

import ai.lum.common.ConfigUtils;
import ai.lum.common.ConfigUtils$;
import ai.lum.common.FileUtils;
import ai.lum.common.FileUtils$;
import ai.lum.common.Serializer$;
import ai.lum.labrador.Author;
import ai.lum.labrador.DOI;
import ai.lum.labrador.DateTime;
import ai.lum.labrador.DocumentMetadata;
import ai.lum.labrador.PMID;
import ai.lum.nxmlreader.NxmlDocument;
import ai.lum.nxmlreader.NxmlReader;
import ai.lum.nxmlreader.PubDate;
import ai.lum.odinson.extra.AnnotateText$delayedInit$body;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.clulab.processors.Document;
import org.clulab.processors.Processor;
import org.clulab.processors.clu.BioCluProcessor;
import org.clulab.processors.clu.CluProcessor;
import org.clulab.processors.clu.CluProcessor$;
import org.clulab.utils.ScienceUtils;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.parallel.ParIterableLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class AnnotateText$
implements App,
LazyLogging {
    public static AnnotateText$ MODULE$;
    private Config config;
    private File textDir;
    private File docsDir;
    private String processorType;
    private Processor processor;
    private ScienceUtils scienceUtils;
    private NxmlReader nxmlReader;
    private Logger logger;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;
    private volatile boolean bitmap$0;

    static {
        new AnnotateText$();
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    private Logger logger$lzycompute() {
        AnnotateText$ annotateText$ = this;
        synchronized (annotateText$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    public Config config() {
        return this.config;
    }

    public File textDir() {
        return this.textDir;
    }

    public File docsDir() {
        return this.docsDir;
    }

    public String processorType() {
        return this.processorType;
    }

    public Processor processor() {
        return this.processor;
    }

    public ScienceUtils scienceUtils() {
        return this.scienceUtils;
    }

    public String preprocessText(String text) {
        String textWithoutUnicode = this.scienceUtils().replaceUnicodeWithAscii(text, this.scienceUtils().replaceUnicodeWithAscii$default$2());
        String textWithoutBibRefs = this.scienceUtils().removeBibRefs(textWithoutUnicode);
        String textWithoutFigRefs = this.scienceUtils().removeFigureAndTableReferences(textWithoutBibRefs);
        return textWithoutFigRefs;
    }

    public NxmlReader nxmlReader() {
        return this.nxmlReader;
    }

    public Option<DocumentMetadata> mkDocumentMetadata(NxmlDocument nxmlDoc) {
        None$ none$;
        Nil$ nil$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> nxmlDoc.doi());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String doi = (String)success.value();
            none$4 = new Some((Object)new DOI(doi));
        } else if (try_ instanceof Failure) {
            none$4 = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        None$ doi = none$4;
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> nxmlDoc.pmid());
        if (try_2 instanceof Success) {
            Success success = (Success)try_2;
            String pmid = (String)success.value();
            none$3 = new Some((Object)new PMID(pmid));
        } else if (try_2 instanceof Failure) {
            none$3 = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_2);
        }
        None$ pmid = none$3;
        Try try_3 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> nxmlDoc.title());
        if (try_3 instanceof Success) {
            Success success = (Success)try_3;
            String paperTitle = (String)success.value();
            none$2 = new Some((Object)paperTitle);
        } else if (try_3 instanceof Failure) {
            none$2 = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_3);
        }
        None$ title = none$2;
        Try try_4 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> nxmlDoc.authors());
        if (try_4 instanceof Success) {
            Success success = (Success)try_4;
            Seq nxmlAuthors = (Seq)success.value();
            nil$ = (Seq)nxmlAuthors.map((Function1 & Serializable & scala.Serializable)nxmlAuthor -> new Author(nxmlAuthor.givenNames(), nxmlAuthor.surname(), (Option)None$.MODULE$, (Option)None$.MODULE$), Seq$.MODULE$.canBuildFrom());
        } else if (try_4 instanceof Failure) {
            nil$ = Nil$.MODULE$;
        } else {
            throw new MatchError((Object)try_4);
        }
        Nil$ authors = nil$;
        Try try_5 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (PubDate)nxmlDoc.pubDate().head());
        if (try_5 instanceof Success) {
            Success success = (Success)try_5;
            PubDate nxmlPubDate = (PubDate)success.value();
            none$ = new Some((Object)new DateTime((Option)new Some((Object)BoxesRunTime.boxToInteger((int)nxmlPubDate.year())), nxmlPubDate.month(), nxmlPubDate.day()));
        } else if (try_5 instanceof Failure) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_5);
        }
        None$ pubDate = none$;
        DocumentMetadata dm = new DocumentMetadata((Seq)authors, (Seq)Nil$.MODULE$, (Option)title, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)pubDate, (Option)doi, (Option)pmid, (Option)None$.MODULE$);
        return new Some((Object)dm);
    }

    public Tuple2<Document, Option<DocumentMetadata>> annotateNxmlFile(File f) {
        NxmlDocument nxmlDoc = this.nxmlReader().read(f);
        NxmlDocument nxmlDocument = nxmlDoc;
        String string = new StringOps(Predef$.MODULE$.augmentString(nxmlDocument.doi())).nonEmpty() ? nxmlDocument.doi() : (new StringOps(Predef$.MODULE$.augmentString(nxmlDocument.pmc())).nonEmpty() ? nxmlDocument.pmc() : f.getName());
        String docId = string;
        String contents = new StringBuilder(2).append(nxmlDoc.paperAbstract()).append("\n\n").append(nxmlDoc.paperBody()).toString().trim();
        Document doc = this.processor().annotate(contents, this.processor().annotate$default$2());
        doc.id_$eq((Option)new Some((Object)docId));
        return new Tuple2((Object)doc, this.mkDocumentMetadata(nxmlDoc));
    }

    public Tuple2<Document, Option<DocumentMetadata>> annotateTextFile(File f) {
        File qual$1 = FileUtils$.MODULE$.FileWrapper(f);
        Charset x$1 = FileUtils.FileWrapper$.MODULE$.readString$default$1$extension(qual$1);
        String text = FileUtils.FileWrapper$.MODULE$.readString$extension1(qual$1, x$1);
        Document doc = this.processor().annotate(text, this.processor().annotate$default$2());
        doc.id_$eq((Option)new Some((Object)FileUtils.FileWrapper$.MODULE$.getBaseName$extension(FileUtils$.MODULE$.FileWrapper(f))));
        return new Tuple2((Object)doc, (Object)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$1(File f) {
        File docFile = new File(MODULE$.docsDir(), new StringBuilder(4).append(FileUtils.FileWrapper$.MODULE$.getBaseName$extension(FileUtils$.MODULE$.FileWrapper(f))).append(".ser").toString());
        File metadataFile = new File(MODULE$.docsDir(), new StringBuilder(13).append(FileUtils.FileWrapper$.MODULE$.getBaseName$extension(FileUtils$.MODULE$.FileWrapper(f))).append(".metadata.ser").toString());
        if (docFile.exists()) {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn("{} already exists", new Object[]{docFile.getCanonicalPath()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                block1: {
                    String string = f.getName().toLowerCase();
                    Tuple2<Document, Option<DocumentMetadata>> tuple2 = string.endsWith(".nxml") ? MODULE$.annotateNxmlFile(f) : MODULE$.annotateTextFile(f);
                    Tuple2<Document, Option<DocumentMetadata>> tuple22 = tuple2;
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    Document doc = (Document)tuple22._1();
                    Option md = (Option)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)doc, (Object)md);
                    Tuple2 tuple24 = tuple23;
                    Document doc2 = (Document)tuple24._1();
                    Option md2 = (Option)tuple24._2();
                    Serializer$.MODULE$.serialize((Serializable)doc2, docFile);
                    if (!md2.nonEmpty()) break block1;
                    Serializer$.MODULE$.serialize((Serializable)md2.get(), metadataFile);
                }
            });
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit;
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Annotated {}", new Object[]{f.getCanonicalPath()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (MODULE$.logger().underlying().isErrorEnabled()) {
                    MODULE$.logger().underlying().error(new StringBuilder(18).append("Failed to process ").append(f.getName()).toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else {
                throw new MatchError((Object)try_);
            }
        }
    }

    public final void delayedEndpoint$ai$lum$odinson$extra$AnnotateText$1() {
        Object object;
        CluProcessor cluProcessor;
        this.config = ConfigFactory.load();
        this.textDir = (File)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.textDir", (ConfigUtils.ConfigFieldReader)ConfigUtils.FileConfigFieldReader$.MODULE$);
        this.docsDir = (File)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.docsDir", (ConfigUtils.ConfigFieldReader)ConfigUtils.FileConfigFieldReader$.MODULE$);
        this.processorType = (String)ConfigUtils.ConfigWrapper$.MODULE$.apply$extension(ConfigUtils$.MODULE$.ConfigWrapper(this.config()), "odinson.extra.processorType", (ConfigUtils.ConfigFieldReader)ConfigUtils.StringConfigFieldReader$.MODULE$);
        String string = this.processorType();
        if ("CluProcessor".equals(string)) {
            cluProcessor = new CluProcessor(CluProcessor$.MODULE$.$lessinit$greater$default$1());
        } else if ("BioCluProcessor".equals(string)) {
            cluProcessor = new BioCluProcessor();
        } else {
            throw new MatchError((Object)string);
        }
        this.processor = cluProcessor;
        if (!this.docsDir().exists()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Making directory {}", new Object[]{this.docsDir()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            object = BoxesRunTime.boxToBoolean((boolean)this.docsDir().mkdirs());
        } else {
            object = BoxedUnit.UNIT;
        }
        this.scienceUtils = new ScienceUtils();
        this.nxmlReader = new NxmlReader((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"references", "materials", "materials|methods", "methods", "supplementary-material"})), true, (Function1 & Serializable & scala.Serializable)text -> MODULE$.preprocessText((String)text));
        this.processor().annotate("this", this.processor().annotate$default$2());
        ((ParIterableLike)FileUtils.FileWrapper$.MODULE$.listFilesByRegex$extension(FileUtils$.MODULE$.FileWrapper(this.textDir()), ".*\\.(txt|nxml)$", false, true).toSeq().par()).foreach((Function1 & Serializable & scala.Serializable)f -> {
            AnnotateText$.$anonfun$new$1(f);
            return BoxedUnit.UNIT;
        });
    }

    private AnnotateText$() {
        MODULE$ = this;
        App.$init$((App)this);
        LazyLogging.$init$((LazyLogging)this);
        this.delayedInit((Function0<BoxedUnit>)new AnnotateText$delayedInit$body(this));
    }
}

