/*
 * Decompiled with CFR 0.152.
 */
package ai.lucidtech.las.sdk;

import ai.lucidtech.las.sdk.MissingAccessTokenException;
import ai.lucidtech.las.sdk.MissingCredentialsException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class Credentials {
    private String clientId;
    private String clientSecret;
    private String apiKey;
    private String authEndpoint;
    private String apiEndpoint;
    private String accessToken;
    private long expires;

    public Credentials(String clientId, String clientSecret, String apiKey, String authEndpoint, String apiEndpoint) throws MissingCredentialsException {
        this.validateCredentials(clientId, clientSecret, apiKey, authEndpoint, apiEndpoint);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.apiKey = apiKey;
        this.authEndpoint = authEndpoint;
        this.apiEndpoint = apiEndpoint;
    }

    public String getAccessToken(HttpClient httpClient) throws MissingAccessTokenException {
        if (this.accessToken == null || this.accessToken.isEmpty() || this.expires < Instant.now().getEpochSecond()) {
            try {
                JSONObject tokenData = this.getClientCredentials(httpClient);
                this.accessToken = tokenData.getString("access_token");
                this.expires = Instant.now().getEpochSecond() + (long)tokenData.getInt("expires_in");
            }
            catch (IOException | RuntimeException ex) {
                throw new MissingAccessTokenException();
            }
        }
        return this.accessToken;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    private void validateCredentials(String ... credentials) throws MissingCredentialsException {
        for (String value : credentials) {
            if (value != null) continue;
            throw new MissingCredentialsException();
        }
    }

    private JSONObject getClientCredentials(HttpClient httpClient) throws IOException {
        HttpPost request = new HttpPost("https://" + this.authEndpoint + "/oauth2/token?grant_type=client_credentials");
        request.addHeader("Content-Type", "application/x-www-form-urlencoded");
        request.addHeader("Accept", "application/json");
        String authString = this.clientId + ":" + this.clientSecret;
        String encodedAuth = Base64.getEncoder().encodeToString(authString.getBytes(StandardCharsets.UTF_8));
        request.addHeader("Authorization", "Basic " + encodedAuth);
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        HttpEntity responseEntity = response.getEntity();
        int status = response.getStatusLine().getStatusCode();
        if (status != 200) {
            throw new RuntimeException("Failed to fetch access token: HTTP response code " + status);
        }
        String body = EntityUtils.toString((HttpEntity)responseEntity);
        JSONObject jsonResponse = new JSONObject(body);
        if (!jsonResponse.has("access_token") || !jsonResponse.has("expires_in")) {
            throw new RuntimeException("Failed to fetch access token: invalid response body");
        }
        return jsonResponse;
    }
}

