/*
 * Decompiled with CFR 0.152.
 */
package ai.foremast.metrics.k8s.starter;

import ai.foremast.metrics.k8s.starter.K8sMetricsProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;

@Configuration
@Order(value=101)
@EnableConfigurationProperties(value={K8sMetricsProperties.class})
@ConditionalOnClass(value={WebSecurityConfigurerAdapter.class})
public class ActuatorSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private K8sMetricsProperties k8sMetricsProperties;

    protected void configure(HttpSecurity http) throws Exception {
        if (this.k8sMetricsProperties.isDisableCsrf()) {
            http.csrf().disable();
        }
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/actuator/info", "/actuator/health", "/actuator/prometheus", "/metrics", "/actuator/k8s-metrics/*"})).permitAll();
    }
}

